/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.crowd;

import cc.lechun.active.entity.crowd.CrowdActiveConfigEntity;
import cc.lechun.active.entity.crowd.CrowdCommonConfigEntity;
import cc.lechun.active.entity.crowd.CrowdFundingEntity;
import cc.lechun.active.entity.crowd.CrowdFundingForumVo;
import cc.lechun.active.entity.crowd.CrowdPicEntity;
import cc.lechun.active.iservice.crowd.CrowdInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/crowdManage"})
public class CrowdController
extends BaseController {
    @Autowired
    private CrowdInterface crowdInterface;
    @Autowired
    private OssService ossService;

    @RequestMapping(value={"saveCrowdActiveInfo"})
    public BaseJsonVo saveCrowdActiveInfo(CrowdActiveConfigEntity crowdActiveConfigEntity) {
        return this.crowdInterface.saveCrowdActiveInfo(crowdActiveConfigEntity);
    }

    @RequestMapping(value={"getCrowActiveConfigList"})
    public BaseJsonVo getCrowActiveConfigList(PageForm pageForm, String activeName, String activeNo) {
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowActiveConfigList(pageForm, activeName, activeNo));
    }

    @RequestMapping(value={"getCrowdActiveProductList"})
    public BaseJsonVo getCrowdActiveProductList(String activeNo) {
        return this.crowdInterface.getCrowdActiveProductList(activeNo, null);
    }

    @RequestMapping(value={"editCrowdActiveProductInfo"})
    public BaseJsonVo editCrowdActiveProductInfo(String id) {
        return this.crowdInterface.getCrowdActiveProductList(null, id);
    }

    @RequestMapping(value={"getCrowdProductList"})
    public BaseJsonVo getCrowdProductList(PageForm pageForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdProductList(pageForm));
    }

    @RequestMapping(value={"saveCrowdProductConfig"})
    public BaseJsonVo saveCrowdProductConfig(CrowdFundingEntity crowdFundingEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.crowdInterface.saveCrowProduct(crowdFundingEntity));
    }

    @RequestMapping(value={"getCrowdProductCouponList"})
    public BaseJsonVo getCrowdProductCouponList(String activeNo, String proId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("selectCouponList", this.crowdInterface.getSelectCrowdProductCouponList(activeNo, proId).getValue());
        resultMap.put("allCouponList", this.crowdInterface.getAllCrowdProductCouponList().getValue());
        return BaseJsonVo.success(resultMap);
    }

    @RequestMapping(value={"saveCrowdCouponConfig"})
    public BaseJsonVo saveCrowdCouponConfig(String proId, String activeNo, String list) throws AuthorizeException, UnsupportedEncodingException {
        MallUserEntity user = this.getUser();
        return this.crowdInterface.saveCrowdCouponConfig(proId, activeNo, list);
    }

    @RequestMapping(value={"sendMessage"})
    public BaseJsonVo sendMessage(String proId, String activeNo, String list) throws AuthorizeException, UnsupportedEncodingException {
        MallUserEntity user = this.getUser();
        return this.crowdInterface.saveCrowdCouponConfig(proId, activeNo, list);
    }

    @RequestMapping(value={"getCrowdOrderList"})
    public BaseJsonVo getCrowdOrderList(Integer orderClass, String date) throws AuthorizeException, UnsupportedEncodingException {
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdOrderList(orderClass, "", "", date));
    }

    @RequestMapping(value={"deleteCrowdCoupon"})
    public BaseJsonVo deleteCrowdCoupon(String proId) throws AuthorizeException, UnsupportedEncodingException {
        return this.crowdInterface.deleteCrowdCoupon(proId);
    }

    @RequestMapping(value={"getCrowdConfigInfo"})
    public BaseJsonVo getCrowdConfigInfo(PageForm pageForm) {
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdConfig(pageForm));
    }

    @RequestMapping(value={"saveCrowdConfigInfo"})
    public BaseJsonVo saveCrowdConfigInfo(CrowdCommonConfigEntity crowdCommonConfigEntity) {
        return this.crowdInterface.saveCrowdConfigInfo(crowdCommonConfigEntity);
    }

    @RequestMapping(value={"getCrowdFundingForumList"})
    public BaseJsonVo getCrowdFundingForumList(PageForm pageForm, CrowdFundingForumVo crowdFundingForumVo) {
        return BaseJsonVo.success((Object)this.crowdInterface.getCrowdFundingForumList(pageForm, crowdFundingForumVo));
    }

    @RequestMapping(value={"deleteForum"})
    public BaseJsonVo deleteForum(String id) {
        return this.crowdInterface.deleteForum(id);
    }

    @RequestMapping(value={"/saveCrowdImage"})
    @ResponseBody
    public BaseJsonVo saveCrowdImage(String proId, String typeId, String classId, MultipartFile[] file) throws AuthorizeException, IOException {
        return this.crowdInterface.saveCrowdImage(proId, typeId, classId, file);
    }

    @RequestMapping(value={"getCrowdPicList"})
    public BaseJsonVo getCrowdPicList(CrowdPicEntity crowdPicEntity) {
        return this.crowdInterface.getCrowdPicList(crowdPicEntity);
    }

    @RequestMapping(value={"deleCrowdPicInfo"})
    public BaseJsonVo deleCrowdPicInfo(CrowdPicEntity crowdPicEntity) {
        this.crowdInterface.deleCrowdPicInfo(crowdPicEntity);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"crowdSucc"})
    public BaseJsonVo crowdSucc(Integer crowdId) {
        BaseJsonVo result = this.crowdInterface.crowdSucc(crowdId);
        return result;
    }

    @RequestMapping(value={"crowdFail"})
    public BaseJsonVo crowdFail(Integer crowdId) {
        BaseJsonVo result = this.crowdInterface.crowdFail(crowdId);
        return result;
    }

    @RequestMapping(value={"crowdExpireCompensate"})
    public BaseJsonVo crowdExpireCompensate(Integer crowdId) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"crowdSoldOutCompensate"})
    public BaseJsonVo crowdSoldOutCompensate(Integer crowdId) {
        return BaseJsonVo.success((Object)"");
    }
}

