/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.customer;

import cc.lechun.api.SobotApiImpl;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.cms.dto.SobotMessage;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerQueryVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInfoDetailInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerUserInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customer"})
public class CustomerController
extends BaseController {
    @Autowired
    private CustomerInfoDetailInterface customerInfoDetailService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private CustomerAddressInterface customerAddressService;
    @Autowired
    private MallTradeInterface mallTradeService;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private CustomerUserInterface customerUserInterface;
    @Autowired
    private SobotApiImpl sobotApi;

    @RequestMapping(value={"/getMessage"})
    public BaseJsonVo getMessage(SobotMessage message) {
        return this.sobotApi.getMessage(message);
    }

    @RequestMapping(value={"/saveCusertomerUserService"})
    public BaseJsonVo saveCusertomerUserService(String openId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/updateVipLevel"})
    public BaseJsonVo updateVipLevel(String customerId, Integer level) throws AuthorizeException {
        this.vipService.updateVipLevel(customerId, level);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/deleteUserVipInfoCache"})
    public BaseJsonVo deleteUserVipInfoCache(String customerId) throws AuthorizeException {
        this.vipService.deleteUserVipInfoCache(customerId);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/centerInfo"})
    public BaseJsonVo centerInfo(String customerId) throws AuthorizeException {
        Map vipCenterInfo = this.vipService.centerInfo(customerId);
        if (vipCenterInfo != null && vipCenterInfo.size() > 0) {
            return BaseJsonVo.success((Object)vipCenterInfo);
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
    }

    @RequestMapping(value={"/getCustomerInfo"})
    public BaseJsonVo getCustomerInfo(String customerId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerService.getCustomer(customerId));
    }

    @RequestMapping(value={"/saveMobile"})
    public BaseJsonVo saveMobile(String customerId, String mobile) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerService.saveMobile(mobile, customerId));
    }

    @RequestMapping(value={"/getCustomerList"})
    public BaseJsonVo getCustomerList(CustomerQueryVo customerQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.customerService.getCustomerList(customerQueryVo));
    }

    @RequestMapping(value={"/getCustomerOpenIdList"})
    public BaseJsonVo getCustomerOpenIdList(String customerId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerService.getCustomerOpenidList(customerId));
    }

    @RequestMapping(value={"/getCustomerAddressList"})
    public BaseJsonVo getCustomerAddressList(String customerId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerAddressService.getValidCustomerAddressList(customerId, "", -1));
    }

    @RequestMapping(value={"/getCustomerOrderList"})
    public BaseJsonVo getCustomerOrderList(String customerId, int statusClass, Integer pageSize, Integer pageCount) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customer", this.customerService.getCustomer(customerId));
        map.put("orderList", this.mallTradeService.getOrderList(customerId, statusClass, pageSize.intValue(), pageCount.intValue()));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getProvinceCityAreaByErp"})
    public BaseJsonVo getProvinceCityAreaByErp(Integer transportType, Integer isLongPeriodBuy) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerAddressService.getProvinceCityAreaByErp(transportType, isLongPeriodBuy));
    }

    @RequestMapping(value={"/getAddressType"})
    public BaseJsonVo getAddressType(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.customerAddressService.getAddressType());
    }

    @RequestMapping(value={"/addAddress"})
    @ResponseBody
    public BaseJsonVo addAddressType(HttpServletRequest request, HttpServletResponse response, AddressForm addressForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.customerAddressService.saveCustomerAddress(addressForm);
    }
}

