/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.organization.entity.OrgWeekEndExcelVo;
import cc.lechun.organization.entity.OrgWeekEndRedExcelVo;
import cc.lechun.organization.entity.OrgWeekEndUnFinishVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperBonusDetailExcelVo;
import cc.lechun.organization.entity.PaperBonusExcelVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperSearchVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPaperReportBounsService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.OrgPaperImportUserVisitInterface;
import cc.lechun.utils.ExcelUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"organization"})
public class PaperController
extends BaseController {
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgPaperAnswerService paperAnswerService;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private IOrgPaperDomain paperDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private IOrgQuestionDomain questionDomain;
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    private IOrgQuestionClassDomain iOrgQuestionClassDomain;
    @Autowired
    private MallUserInterface userInterface;
    @Autowired
    private IPaperReportBounsService paperReportBounsService;
    @Autowired
    private DingdingUtils dingdingUtils;
    @Autowired
    private OrgPaperImportUserVisitInterface userVisitInterface;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/getPaperPageList"})
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperSearchVo paper) throws AuthorizeException {
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        if (paper == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
        } else if (StringUtils.isNotEmpty((String)paper.getUserId())) {
            paperEntity.setUserId(paper.getUserId());
        }
        if (paper.getStatus() == null) return this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId(), userEntity.getDeptId());
        paperEntity.setStatus(paper.getStatus());
        return this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId(), userEntity.getDeptId());
    }

    @RequestMapping(value={"/getPaperPage"})
    public BaseJsonVo getPaperPage(PaperSearchVo paper) throws AuthorizeException {
        PageForm pageForm = new PageForm();
        pageForm.setCurrentPage(1);
        pageForm.setPageSize(1);
        if (paper == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        if (paper.getPaperId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,paperId\u4e0d\u80fd\u7a7a");
        }
        if (paper.getPeriodId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,periodId\u4e0d\u80fd\u7a7a");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        paperEntity.setQuestionClassId(paper.getClassId());
        paperEntity.setPeriodId(paper.getPeriodId());
        paperEntity.setId(paper.getPaperId());
        BaseJsonVo pageInfo = this.paperService.getPaperPageList(pageForm, paperEntity, userEntity.getUserId(), userEntity.getDeptId());
        if (pageInfo.isSuccess() && ((PageInfo)pageInfo.getValue()).getList().size() > 0) {
            return BaseJsonVo.success(((PageInfo)pageInfo.getValue()).getList().get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u62a5\u544a");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/getPublicPapers"})
    public BaseJsonVo getPublicPapers(PageForm pageForm, PaperSearchVo paper) throws AuthorizeException {
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        if (paper == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef,\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
            return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
        } else {
            if (!StringUtils.isNotEmpty((String)paper.getUserId())) return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
            paperEntity.setUserId(paper.getUserId());
        }
        return this.paperService.getPublicPapers(pageForm, paperEntity, userEntity.getUserId());
    }

    @RequestMapping(value={"/getPaperAnswerList"})
    public BaseJsonVo getPaperAnswerList(Integer classId, String paperId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }

    @RequestMapping(value={"/savePaperAnswer"})
    public BaseJsonVo savePaperAnswer(@RequestParam(value="answerEntityList") String answerEntityList) throws AuthorizeException {
        BaseJsonVo baseJson;
        List answerEntityList1 = JsonUtils.getListByArray(PaperAnswerEntity.class, (String)answerEntityList);
        MallUserEntity userEntity = this.getUser();
        if (answerEntityList == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ArrayList subAnswerEntityList = new ArrayList();
        PaperAnswerEntity paperAnswerEntity = (PaperAnswerEntity)answerEntityList1.get(0);
        this.log.info(">>>>>>>savePaperAnswer paperAnswerEntity >>>>>>>paperAnswerEntity={}", (Object)JSON.toJSONString((Object)paperAnswerEntity));
        String paperId = paperAnswerEntity.getPaperId();
        String userId = userEntity.getUserId();
        if (StringUtils.isNotEmpty((String)paperId)) {
            PaperAnswerEntity search = new PaperAnswerEntity();
            search.setPaperId(paperId);
            List answerEntities = this.orgPaperAnswerDomain.getList(search);
            if (answerEntities != null && answerEntities.size() > 0) {
                userId = ((PaperAnswerEntity)answerEntities.get(0)).getUserId();
            }
        }
        for (PaperAnswerEntity answerEntity : answerEntityList1) {
            answerEntity.setCreateTime(new Date());
            answerEntity.setUserId(userId);
            String answerStr = answerEntity.getAnswer() != null ? answerEntity.getAnswer().replace("\u3010\u5f02\u8bae\u3011", "") : "";
            answerEntity.setAnswer(answerStr);
            if (answerEntity.getAnswer() == null) {
                answerEntity.setAnswer("");
            }
            if (answerEntity.getAnswer().length() > 20000) {
                return BaseJsonVo.error((String)"\u56de\u7b54\u6587\u5b57\u4e0d\u80fd\u5927\u4e8e20000\u5b57");
            }
            if (answerEntity.getQuestionId() == null) {
                return BaseJsonVo.error((String)"\u95ee\u9898\u4e3a\u7a7a");
            }
            if (answerEntity.getPaperId() == null) {
                return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
            }
            QuestionEntity questionEntity = this.questionDomain.select(answerEntity.getQuestionId());
            if (answerEntity.getAnswer() == null || questionEntity == null || questionEntity.getQuestionType() != 10) continue;
            try {
                List l = JsonUtils.getListByArray(PaperAnswerEntity.class, (String)answerEntity.getAnswer());
                if (l == null || l.size() <= 0) continue;
                subAnswerEntityList.addAll(l);
            }
            catch (Exception exception) {}
        }
        if (subAnswerEntityList.size() > 0) {
            answerEntityList1.addAll(subAnswerEntityList);
        }
        try {
            this.log.info("=====answerEntityList1={}", (Object)JSON.toJSONString((Object)answerEntityList1));
            baseJson = this.paperAnswerService.savePaperAnswer(answerEntityList1, userId);
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/setWeekAfterWeekFinishStatus"})
    public BaseJsonVo setWeekAfterWeek(Integer id, Integer finished) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.setWeekAfterWeek(id, userEntity.getUserId(), finished);
    }

    @RequestMapping(value={"/savePaperAnswertest"})
    public BaseJsonVo savePaperAnswertest() throws AuthorizeException {
        BaseJsonVo baseJson;
        MallUserEntity userEntity = this.getUser();
        ArrayList<PaperAnswerEntity> answerEntityList = new ArrayList<PaperAnswerEntity>();
        for (int i = 1; i < 30; ++i) {
            PaperAnswerEntity answerEntity = new PaperAnswerEntity();
            answerEntity.setPaperId("1186938331029835776");
            answerEntity.setQuestionId(Integer.valueOf(i));
            answerEntity.setAnswer("20ewruodafdagragdsgdgsfdg");
            answerEntityList.add(answerEntity);
        }
        if (answerEntityList == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        for (PaperAnswerEntity answerEntity : answerEntityList) {
            answerEntity.setCreateTime(new Date());
            answerEntity.setUserId(userEntity.getUserId());
            if (answerEntity.getAnswer().length() > 5000) {
                return BaseJsonVo.error((String)"\u56de\u7b54\u6587\u5b57\u4e0d\u80fd\u5927\u4e8e5000\u5b57");
            }
            if (answerEntity.getQuestionId() == null) {
                return BaseJsonVo.error((String)"\u95ee\u9898\u4e3a\u7a7a");
            }
            if (answerEntity.getPaperId() != null) continue;
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e3a\u7a7a");
        }
        try {
            baseJson = this.paperAnswerService.savePaperAnswer(answerEntityList, null);
        }
        catch (RuntimeException e) {
            baseJson = BaseJsonVo.error((String)("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage()));
            e.printStackTrace();
        }
        return baseJson;
    }

    @RequestMapping(value={"/relationMe"})
    public BaseJsonVo relationMe(PageForm pageForm, String classId, Integer ctype, Integer isself) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        return this.paperAnswerService.relationMe(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), userEntity.getUserId(), classId, ctype, isself);
    }

    @RequestMapping(value={"/lookPaperAnswer"})
    public BaseJsonVo lookPaperAnswer(PageForm pageForm, Integer year, Integer period, Integer classId, Integer questionId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (pageForm == null) {
            pageForm = new PageForm();
            pageForm.setCurrentPage(1);
            pageForm.setPageSize(20);
        }
        return this.paperAnswerService.lookPaperAnswer(pageForm, year, period, classId, userEntity.getUserId(), questionId);
    }

    @RequestMapping(value={"/buidPaper"})
    public BaseJsonVo buildPaper(Integer periodId) {
        if (periodId == null) {
            return this.paperService.buildPaper();
        }
        return this.paperService.buildPaper(periodId);
    }

    @RequestMapping(value={"/buidRelation"})
    public BaseJsonVo buildRelation() throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        List paperEntities = this.paperDomain.getList(new PaperEntity());
        for (PaperEntity p : paperEntities) {
            this.paperAnswerService.savePaperAnswerRelation(p.getId(), userEntity.getUserId(), null);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getPeriod"})
    public BaseJsonVo getPeriod(String date, Integer type) {
        if (date == null) {
            date = DateUtils.date();
        }
        if (type == null) {
            type = 0;
        }
        Date d = DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd");
        return this.periodService.getPeriod(d, type);
    }

    @RequestMapping(value={"/saveAnswer"})
    public BaseJsonVo saveAnswer(Integer relationId, String content, String content1) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.relationService.saveAnswer(userEntity.getUserId(), relationId, content, content1);
    }

    @RequestMapping(value={"/setReportStatus"})
    public BaseJsonVo setReportStatus(Integer period) {
        if (period == null) {
            return this.paperReportBounsService.setReportStatus();
        }
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(1));
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(2));
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/setReportStatusByUserName"})
    public BaseJsonVo setReportStatus(Integer period, String userName) {
        if (period == null) {
            return this.paperReportBounsService.setReportStatus();
        }
        if (StringUtils.isEmpty((String)userName)) {
            return BaseJsonVo.error((String)"userName \u4e3a\u7a7a");
        }
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(1), userName);
        this.paperReportBounsService.setReportStatus(period, Integer.valueOf(2), userName);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getBonusesList"})
    public BaseJsonVo getBonusesList(Integer year, Integer month) {
        Calendar c1 = Calendar.getInstance();
        if (year == null) {
            Date start = c1.getTime();
            c1.add(2, -1);
            Date date = c1.getTime();
            c1.getWeekYear();
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getBonusesList(null, year, month, null));
    }

    @RequestMapping(value={"/getBonusesDate"})
    public BaseJsonVo getBonusesDate(Integer year, Integer month) {
        return BaseJsonVo.success((Object)DateUtils.formatDate((Date)this.paperReportBounsService.getBonusesDate(year, month), (String)"yyyy-MM-dd"));
    }

    @GetMapping(value={"/downloadBonuses"})
    public void downloadBonuses(Integer year, Integer month, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(year + "\u5e74" + month + "\u6708\u5956\u91d1", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            List list = this.paperReportBounsService.getBonusesList(null, year, month, null);
            ArrayList result = new ArrayList();
            ArrayList detailVos = new ArrayList();
            if (list.size() > 0) {
                list.forEach(p -> {
                    PaperBonusExcelVo paperBonusExcelVo = new PaperBonusExcelVo();
                    BeanUtils.copyProperties((Object)p, (Object)paperBonusExcelVo);
                    result.add(paperBonusExcelVo);
                    detailVos.addAll(this.paperReportBounsService.getPaperBonusDetailExcelList(p.getUserId(), year, month, Integer.valueOf(1), Integer.valueOf(3)));
                    detailVos.addAll(this.paperReportBounsService.getPaperBonusDetailExcelList(p.getUserId(), year, month, Integer.valueOf(2), Integer.valueOf(3)));
                });
            }
            ExcelWriter writer = new ExcelWriter((OutputStream)response.getOutputStream(), ExcelTypeEnum.XLSX);
            Sheet sheet = new Sheet(1, 0, PaperBonusExcelVo.class);
            sheet.setSheetName("\u5956\u91d1");
            writer.write(result, sheet);
            Sheet sheet2 = new Sheet(2, 0, PaperBonusDetailExcelVo.class);
            sheet2.setSheetName("\u5956\u91d1\u660e\u7ec6");
            writer.write(detailVos, sheet2);
            writer.finish();
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"/getBonusesListByUser"})
    public BaseJsonVo getBonusesListByUser(String userId, Integer year, Integer month, Integer questionClassId) throws AuthorizeException {
        if (year == null) {
            return BaseJsonVo.error((String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)userId)) {
            MallUserEntity userEntity = this.getUser();
            userId = userEntity.getUserId();
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getMyBonusesList(userId, year, month, questionClassId));
    }

    @RequestMapping(value={"/getPaperBonusDetaiList"})
    public BaseJsonVo getPaperBonusDetaiList(String userId, Integer year, Integer month, Integer questionClassId) throws AuthorizeException {
        if (year == null) {
            return BaseJsonVo.error((String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (month == null) {
            return BaseJsonVo.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer reportStatus = null;
        if (StringUtils.isEmpty((String)userId)) {
            MallUserEntity userEntity = this.getUser();
            userId = userEntity.getUserId();
        } else {
            reportStatus = 3;
        }
        return BaseJsonVo.success((Object)this.paperReportBounsService.getPaperBonusDetailExcelList(userId, year, month, questionClassId, reportStatus));
    }

    @RequestMapping(value={"/calculateBonuses"})
    public BaseJsonVo calculateBonuses(Integer period) throws AuthorizeException {
        this.paperReportBounsService.calculateBonuses(period);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/initReportStatus"})
    public BaseJsonVo initReportStatus() throws AuthorizeException {
        this.paperReportBounsService.initReportStatus();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/checkCurrentPeriodOrLastPeriod"})
    public BaseJsonVo checkCurrentPeriodOrLastPeriod(int periodId) {
        return BaseJsonVo.success((Object)this.periodService.checkCurrentPeriodOrLastPeriod(periodId));
    }

    @RequestMapping(value={"/modityPaperStatus"})
    public BaseJsonVo modityPaperStatus(PaperEntity paperEntity) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.modityPaperStatus(paperEntity, userEntity);
    }

    @RequestMapping(value={"/testmodityPaperStatus"})
    public BaseJsonVo testmodityPaperStatus(PaperEntity paperEntity) throws AuthorizeException {
        MallUserEntity userEntity = new MallUserEntity();
        userEntity.setUserId("3039238394131487336");
        return this.paperService.modityPaperStatus(paperEntity, userEntity);
    }

    @RequestMapping(value={"/getWeekThingWeekFinish"})
    public BaseJsonVo getWeekThingWeekFinish(Integer period, String userId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getWeekThingWeekFinish(period, userId, userEntity.getUserId());
    }

    @RequestMapping(value={"modifyPaperAnswerRelationSort"})
    public BaseJsonVo modifyPaperAnswerRelationSort(Integer answerRelationId, Integer questionId, int sort, String userId, Integer classId, String paperId) throws AuthorizeException {
        this.relationService.modifyPaperAnswerRelationSort(answerRelationId, questionId, sort, userId, paperId);
        MallUserEntity userEntity = this.getUser();
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }

    public BaseJsonVo modifyPaperAnswerRelationDissent(Integer id, Integer isDissent) {
        if (id == null || isDissent == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return this.relationService.modifyPaperAnswerRelationDissent(id, isDissent);
    }

    @RequestMapping(value={"importPaperAnswer"}, method={RequestMethod.POST})
    public BaseJsonVo importPaperAnswer(@RequestParam(value="file") MultipartFile file) throws IOException {
        return BaseJsonVo.error((String)"\u5bfc\u5165\u529f\u80fd\u5df2\u5931\u6548");
    }

    @RequestMapping(value={"queryDayReport"})
    public BaseJsonVo queryDayReport(Integer periodId, String userId) {
        return this.paperAnswerService.queryDayReport(periodId, userId, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"getExportData"})
    public void getExportData(PaperSearchVo paper, HttpServletResponse response) throws AuthorizeException, IOException {
        if (paper == null) {
            return;
        }
        MallUserEntity userEntity = this.getUser();
        PaperEntity paperEntity = new PaperEntity();
        Integer classId = paper.getClassId();
        if (classId == null) {
            return;
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId.intValue());
        if (paper.getYear() == null || paper.getPeriod() == null) {
            BaseJsonVo baseJsonVo = this.periodService.currentPeriod(periodType);
            if (baseJsonVo.getValue() == null) return;
            paperEntity.setPeriodId(((PeriodEntity)baseJsonVo.getValue()).getId());
        } else {
            BaseJsonVo inPeriodWithNum = this.periodService.getPeriodWithNum(paper.getYear(), paper.getPeriod().intValue(), periodType);
            if (!inPeriodWithNum.isSuccess()) return;
            paperEntity.setPeriodId(((PeriodEntity)inPeriodWithNum.getValue()).getId());
        }
        if (paper.getClassId() == null) {
            return;
        }
        paperEntity.setQuestionClassId(paper.getClassId());
        if (paper.getOnlyme() != null && paper.getOnlyme() == 1) {
            paperEntity.setUserId(userEntity.getUserId());
        } else if (StringUtils.isNotEmpty((String)paper.getUserId())) {
            paperEntity.setUserId(paper.getUserId());
        } else {
            paperEntity.setUserId(userEntity.getUserId());
        }
        String sheetName = "\u534f\u4f5c\u529e\u516c";
        QuestionClassEntity classEntity = this.iOrgQuestionClassDomain.select(paperEntity.getQuestionClassId());
        if (classEntity != null) {
            sheetName = classEntity.getClassName();
        }
        List maps = null;
        maps = classEntity.getClassId() == 10 ? this.paperService.getExportDataKpi(paperEntity) : this.paperService.getExportData(paperEntity);
        if (maps.size() <= 0) return;
        String[] s = new String[1];
        String[] b = ((LinkedHashMap)maps.get(0)).keySet().toArray(s);
        ExcelUtil.exportExcel((HttpServletResponse)response, (String)(sheetName + "_" + userEntity.getUserNick() + ".xlsx"), (String)sheetName, (String[])b, (List)maps, (String)"");
    }

    @RequestMapping(value={"/modityWeekAfterWeek"})
    public BaseJsonVo modityWeekAfterWeek(Integer id, Integer isFinishLeader, Integer isFinishEmploye, Boolean checked) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.modityWeekAfterWeek(id, userEntity.getUserId(), isFinishLeader, isFinishEmploye, checked);
    }

    @RequestMapping(value={"/saveRemarkInfo"})
    public BaseJsonVo saveRemarkInfo(Integer id, String leaderRemark, String employRemark) {
        return this.paperService.saveRemarkInfo(id, leaderRemark, employRemark);
    }

    @RequestMapping(value={"/saveIsDissentInfo"})
    public BaseJsonVo saveIsDissentInfo(Integer id, Integer isDissentLeader, Integer isDissent) {
        return this.paperService.saveIsDissentInfo(id, isDissentLeader, isDissent);
    }

    @RequestMapping(value={"/delPaperAnswerRelation"})
    public BaseJsonVo delPaperAnswerRelation(Integer relationId, Integer classId, String paperId) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        this.relationService.delPaperAnswerRelation(relationId, paperId);
        this.paperService.updatePaperTimeByParam(paperId);
        return this.paperAnswerService.getPaperAnswerList(classId, paperId, userEntity.getUserId());
    }

    @RequestMapping(value={"/getreport"})
    public BaseJsonVo getReport(String sdate, String edate) {
        return this.userVisitInterface.getAllFormData(sdate, edate);
    }

    @RequestMapping(value={"/getReportTemplate"})
    public BaseJsonVo getReportTemplate() {
        return this.dingdingUtils.getReport("\u6bcf\u65e5\u5c0f\u7ed3", DateUtils.getDateFromString((String)"2020-7-16", (String)"yyyy-MM-dd"), DateUtils.now(), "");
    }

    @RequestMapping(value={"/getUsers"})
    public BaseJsonVo getUsers() {
        return null;
    }

    @RequestMapping(value={"/getUser"})
    public BaseJsonVo getUser(String digndingId) {
        return BaseJsonVo.success((Object)this.dingdingUtils.getUser(digndingId));
    }

    @RequestMapping(value={"/sendmessage"})
    public BaseJsonVo sendmessage(String dingdingId) {
        return this.dingdingUtils.sendActionCardMessage(dingdingId, "\u5468\u62a5\u586b\u5199\u901a\u77e5", "\u8bf7\u586b\u5199\u672c\u5468\u5468\u62a5");
    }

    @RequestMapping(value={"/getSubordinateUnConfirmReport"})
    public BaseJsonVo getSubordinateUnConfirmReport() throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return BaseJsonVo.success((Object)this.paperService.getSubordinateUnConfirmReport(userEntity.getUserId()));
    }

    @RequestMapping(value={"/dingdingRemindSend"})
    public BaseJsonVo dingdingRemindSend(String today, Integer questionClassId, Integer remindType) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        return this.paperService.dingdingRemindSend(DateUtils.getDateFromString((String)today, (String)"yyyy-MM-dd"), questionClassId, remindType);
    }

    @RequestMapping(value={"/updateHistoryWeekEndFinishStatus"})
    public BaseJsonVo updateHistoryWeekEndFinishStatus(String date) {
        return this.paperService.updateHistoryWeekEndFinishStatus(date);
    }

    @RequestMapping(value={"/getWeekEndUnfinshList"})
    public BaseJsonVo getWeekEndUnfinshList(String periodIds) {
        PeriodEntity curr;
        Date sdate = DateUtils.getDateFromString((String)periodIds.split(",")[0], (String)"yyyy-MM-dd");
        Date edate = DateUtils.getDateFromString((String)periodIds.split(",")[1], (String)"yyyy-MM-dd");
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(sdate, Integer.valueOf(0)).getValue();
        PeriodEntity periodEntity1 = (PeriodEntity)this.periodService.getPeriod(edate, Integer.valueOf(0)).getValue();
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u8d77\u59cb\u5468\u4e0d\u5b58\u5728");
        }
        if (periodEntity1 == null) {
            return BaseJsonVo.error((String)"\u7ed3\u675f\u5468\u4e0d\u5b58\u5728");
        }
        List periodEntities = this.periodService.getPeriodInfoByDate(Integer.valueOf(0), periodEntity.getPeriodStart(), periodEntity1.getPeriodEnd());
        Integer weekIndex = DateUtils.getWeekIndexOfDate((Date)DateUtils.currentDate());
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        if (weekIndex < 6 && (weekIndex < 5 || hour < 20) && (curr = (PeriodEntity)this.periodService.currentPeriod(Integer.valueOf(0)).getValue()) != null) {
            periodEntities.remove(curr);
        }
        if (periodEntities.size() > 4) {
            return BaseJsonVo.error((String)"\u67e5\u8be2\u533a\u95f4\u6700\u591a\u90094\u5468");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (periodEntities.size() > 0) {
            for (PeriodEntity p : periodEntities) {
                ids.add(p.getId());
            }
        }
        return this.relationService.getWeekEndUnfinshList(ids);
    }

    @RequestMapping(value={"/getWeekEndfinshList"})
    public BaseJsonVo<List<OrgWeekEndUnFinishVo>> getWeekEndfinshList(String periodIds) {
        BaseJsonVo js;
        PeriodEntity curr;
        Date sdate = DateUtils.getDateFromString((String)periodIds.split(",")[0], (String)"yyyy-MM-dd");
        Date edate = DateUtils.getDateFromString((String)periodIds.split(",")[1], (String)"yyyy-MM-dd");
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(sdate, Integer.valueOf(0)).getValue();
        PeriodEntity periodEntity1 = (PeriodEntity)this.periodService.getPeriod(edate, Integer.valueOf(0)).getValue();
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u8d77\u59cb\u5468\u4e0d\u5b58\u5728");
        }
        if (periodEntity1 == null) {
            return BaseJsonVo.error((String)"\u7ed3\u675f\u5468\u4e0d\u5b58\u5728");
        }
        List periodEntities = this.periodService.getPeriodInfoByDate(Integer.valueOf(0), periodEntity.getPeriodStart(), periodEntity1.getPeriodEnd());
        Integer weekIndex = DateUtils.getWeekIndexOfDate((Date)DateUtils.currentDate());
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        if (weekIndex < 6 && weekIndex < 5 && (curr = (PeriodEntity)this.periodService.currentPeriod(Integer.valueOf(0)).getValue()) != null) {
            periodEntities.remove(curr);
        }
        if (periodEntities.size() > 4) {
            return BaseJsonVo.error((String)"\u67e5\u8be2\u533a\u95f4\u6700\u591a\u90094\u5468");
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (periodEntities.size() > 0) {
            for (PeriodEntity p : periodEntities) {
                ids.add(p.getId());
            }
        }
        if ((js = this.relationService.getWeekEndfinshList(ids)).isSuccess()) {
            return BaseJsonVo.success(((List)js.getValue()).stream().filter(cc -> cc.getTotalFinishCount() >= 2).collect(Collectors.toList()));
        }
        return js;
    }

    @RequestMapping(value={"/returnQues"})
    public BaseJsonVo returnQues(String paperId, Integer type) {
        MallUserEntity userEntity;
        PaperEntity paperEntity = this.paperDomain.select(paperId);
        if (paperEntity != null && (userEntity = (MallUserEntity)this.userInterface.selectByPrimaryKey((Serializable)((Object)paperEntity.getUserId()))) != null) {
            if (Integer.valueOf(2).equals(type)) {
                return this.dingdingUtils.sendOAMessage(userEntity.getDingdingId(), "", "\u60a8\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1\u88ableader\u6807\u8bb0\u4e3a\u4e0d\u5408\u683c\uff0c\u9700\u8981\u91cd\u65b0\u89c4\u5212\u5f53\u5468\u5de5\u4f5c\u4efb\u52a1\u5e76\u53ca\u65f6\u4e0eleader\u8054\u7cfb");
            }
            if (Integer.valueOf(1).equals(type)) {
                return this.dingdingUtils.sendOAMessage(userEntity.getDingdingId(), "", "\u4eb2\u7231\u7684\u5c0f\u4f19\u4f34\uff0c\u60a8\u7684leader\u9700\u8981\u548c\u60a8\u6c9f\u901a\u62c9\u5e73\u5468\u4e8b\u5468\u6bd5\u7684\u7ec6\u8282\uff0c\u8bf7\u53ca\u65f6\u627e\u4ed6/\u5979\u6c9f\u901a\u54e6~");
            }
        }
        return BaseJsonVo.error((String)"\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25");
    }

    @RequestMapping(value={"downloadExcelWeek"})
    public void downloadExcelWeek(String periodIds, Integer isFinish, HttpServletResponse response) throws IOException {
        PeriodEntity curr;
        Date sdate = DateUtils.getDateFromString((String)periodIds.split(",")[0], (String)"yyyy-MM-dd");
        Date edate = DateUtils.getDateFromString((String)periodIds.split(",")[1], (String)"yyyy-MM-dd");
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.getPeriod(sdate, Integer.valueOf(0)).getValue();
        PeriodEntity periodEntity1 = (PeriodEntity)this.periodService.getPeriod(edate, Integer.valueOf(0)).getValue();
        if (periodEntity == null) {
            return;
        }
        if (periodEntity1 == null) {
            return;
        }
        List periodEntities = this.periodService.getPeriodInfoByDate(Integer.valueOf(0), periodEntity.getPeriodStart(), periodEntity1.getPeriodEnd());
        Integer weekIndex = DateUtils.getWeekIndexOfDate((Date)DateUtils.currentDate());
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        if (isFinish == 0) {
            if (weekIndex < 6 && (weekIndex < 5 || hour < 20) && (curr = (PeriodEntity)this.periodService.currentPeriod(Integer.valueOf(0)).getValue()) != null) {
                periodEntities.remove(curr);
            }
        } else if (weekIndex < 6 && weekIndex < 5 && (curr = (PeriodEntity)this.periodService.currentPeriod(Integer.valueOf(0)).getValue()) != null) {
            periodEntities.remove(curr);
        }
        if (periodEntities.size() > 4) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (periodEntities.size() > 0) {
            for (PeriodEntity p : periodEntities) {
                ids.add(p.getId());
            }
        }
        try {
            ExcelWriter excelWriter;
            String sheetName;
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            if (isFinish == 0) {
                sheetName = "\u5468\u4e8b\u5468\u6bd5\u9ed1\u699c";
                response.setHeader("Content-disposition", "attachment;filename=" + DateUtils.formatDate((Date)periodEntity.getPeriodStart(), (String)"yyyy-MM-dd") + "-" + DateUtils.formatDate((Date)periodEntity1.getPeriodEnd(), (String)"yyyy-MM-dd") + URLEncoder.encode(sheetName, "UTF-8") + ".xlsx");
                excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
                List orgWeekEndExcelVoList = this.relationService.getExcelWeekEnd(ids, isFinish);
                WriteSheet writeSheetWeekEnd = EasyExcel.writerSheet((Integer)0, (String)(DateUtils.formatDate((Date)periodEntity.getPeriodStart(), (String)"yyyy-MM-dd") + "-" + DateUtils.formatDate((Date)periodEntity1.getPeriodEnd(), (String)"yyyy-MM-dd") + sheetName)).head(OrgWeekEndExcelVo.class).build();
                excelWriter.write(orgWeekEndExcelVoList, writeSheetWeekEnd);
                excelWriter.finish();
            } else {
                sheetName = "\u5468\u4e8b\u5468\u6bd5\u7ea2\u699c";
                response.setHeader("Content-disposition", "attachment;filename=" + DateUtils.formatDate((Date)periodEntity.getPeriodStart(), (String)"yyyy-MM-dd") + "-" + DateUtils.formatDate((Date)periodEntity1.getPeriodEnd(), (String)"yyyy-MM-dd") + URLEncoder.encode(sheetName, "UTF-8") + ".xlsx");
                excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).build();
                List orgWeekEndRedExcelVoList = this.relationService.getExcelWeekEndRed(ids, isFinish);
                WriteSheet writeSheetWeekEndRed = EasyExcel.writerSheet((Integer)0, (String)(DateUtils.formatDate((Date)periodEntity.getPeriodStart(), (String)"yyyy-MM-dd") + "-" + DateUtils.formatDate((Date)periodEntity1.getPeriodEnd(), (String)"yyyy-MM-dd") + sheetName)).head(OrgWeekEndRedExcelVo.class).build();
                excelWriter.write(orgWeekEndRedExcelVoList, writeSheetWeekEndRed);
                excelWriter.finish();
            }
        }
        catch (Exception e) {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"importWeekJob"}, method={RequestMethod.POST})
    public BaseJsonVo importWeekJob(@RequestParam(value="file") MultipartFile file) throws IOException {
        return this.paperAnswerService.importWeekJob(file);
    }
}

