/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.idomain.IOrgPeriodDomain;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPeriodService;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"periodManage"})
public class PeriodManageController {
    @Autowired
    IOrgPeriodDomain periodDomain;
    @Autowired
    IPeriodService periodService;
    @Autowired
    IOrgPaperService paperService;

    @RequestMapping(value={"/findPeriodList"})
    public BaseJsonVo findPeriodList(PageForm pageForm, Integer periodType) {
        PageInfo pageInfo = this.periodDomain.getPeriods(pageForm, periodType);
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/createPeriod"})
    public BaseJsonVo createPeriod() {
        try {
            BaseJsonVo nextPeriod;
            BaseJsonVo vo = this.periodService.createPeriods();
            if (!vo.isSuccess()) {
                return BaseJsonVo.error((String)("\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u5931\u8d25\uff1a" + vo.getError_msg()));
            }
            this.paperService.buildPaper();
            BaseJsonVo jsonVo = this.periodService.currentPeriod(Integer.valueOf(0));
            if (jsonVo.isSuccess() && (nextPeriod = this.periodService.getNextPeriod(((PeriodEntity)jsonVo.getValue()).getId().intValue())).isSuccess()) {
                this.paperService.buildPaper(((PeriodEntity)nextPeriod.getValue()).getId());
            }
            return BaseJsonVo.success((Object)"\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u6210\u529f");
        }
        catch (Exception e) {
            return BaseJsonVo.error((String)("\u6bcf\u5468\u521b\u5efa\u671f\u6b21\u5931\u8d25\uff1a" + e));
        }
    }
}

