/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutEntity;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutSpecialCaseEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassTimeoutDomain;
import cc.lechun.organization.iservice.OrgQuestionClassTimeoutSpecialCaseInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"questionClass"})
public class QuestionClassManageController {
    @Autowired
    IOrgQuestionClassDomain questionClassDomain;
    @Autowired
    IOrgQuestionClassTimeoutDomain timeoutDomain;
    @Autowired
    OrgQuestionClassTimeoutSpecialCaseInterface specialCaseInterface;

    @RequestMapping(value={"/findQuestionClass"})
    public BaseJsonVo findQuestionClass(PageForm pageForm) {
        PageInfo pageInfo = this.questionClassDomain.getQuestionClassPageList(pageForm);
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/findQuestionClassList"})
    public BaseJsonVo findQuestionClassList() {
        return BaseJsonVo.success((Object)this.questionClassDomain.getQuestionClassEntityList());
    }

    @RequestMapping(value={"/saveQuestionClass"})
    public BaseJsonVo saveQuestionClass(QuestionClassEntity questionClassEntity) {
        this.questionClassDomain.save(questionClassEntity);
        return BaseJsonVo.success(null);
    }

    @RequestMapping(value={"/getTimeout"})
    public BaseJsonVo getTimeout(Integer classId, Integer subType) {
        OrgQuestionClassTimeoutEntity timeout = this.timeoutDomain.getTimeout(classId, subType);
        return BaseJsonVo.success((Object)timeout);
    }

    @RequestMapping(value={"/saveQuestionClassTimeout"})
    public BaseJsonVo saveQuestionClassTimeout(OrgQuestionClassTimeoutEntity entity) {
        this.timeoutDomain.save(entity);
        return BaseJsonVo.success(null);
    }

    @RequestMapping(value={"/getTimeoutSpecialUsers"})
    public BaseJsonVo getTimeoutSpecialUsers(Integer timeoutId) {
        OrgQuestionClassTimeoutSpecialCaseEntity param = new OrgQuestionClassTimeoutSpecialCaseEntity();
        param.setTimeoutId(timeoutId);
        List list = this.specialCaseInterface.getList((Object)param);
        return BaseJsonVo.success((Object)list);
    }

    @RequestMapping(value={"/saveTimeoutSpecialUsers"})
    public BaseJsonVo saveTimeoutSpecialUsers(Integer timeoutId, String userIds) {
        if (userIds == null) {
            userIds = "";
        }
        this.timeoutDomain.batchSaveSpecialCase(timeoutId, userIds.split(","));
        return BaseJsonVo.success(null);
    }
}

