/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductSalesEntity;
import cc.lechun.mall.entity.sales.MallProductSalesEntityVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.sales.MallProductSalesInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/productSales"})
public class MallProductSalesController
extends BaseController {
    @Autowired
    private MallProductSalesInterface mallProductSalesInterface;

    @RequestMapping(value={"/getProductSalesListByPage"}, method={RequestMethod.GET})
    public PageInfo getProductSalesListByPage(PageForm pageForm, MallProductSalesEntityVo mallProductSalesEntityVo) {
        PageInfo listPage = this.mallProductSalesInterface.getProductSalesListByPage(pageForm.getCurrentPage(), pageForm.getPageSize(), mallProductSalesEntityVo);
        return listPage;
    }

    @RequestMapping(value={"/saveProductInfo"})
    public BaseJsonVo saveProductInfo(MallProductSalesEntity mallProductSalesEntity) {
        this.log.info("==========MallProductSalesController.saveProductInfo======================mallProductSalesEntity={}", (Object)JSON.toJSONString((Object)mallProductSalesEntity));
        MallUserEntity user = null;
        try {
            user = this.getUser();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        this.mallProductSalesInterface.saveProductInfo(mallProductSalesEntity, user);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/deleteProductSalesByProId"})
    public BaseJsonVo deleteProductSalesByProId(MallProductSalesEntity mallProductSalesEntity) {
        this.mallProductSalesInterface.deleteProductSalesByProId(mallProductSalesEntity);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/checkSalesNum"})
    public BaseJsonVo checkSalesNum(Map<String, Integer> producSalesNummap, Integer cityId) {
        BaseJsonVo baseJsonVo = this.mallProductSalesInterface.checkSalesNum(producSalesNummap, cityId);
        this.log.info("===================baseJsonVo=======baseJsonVo={}", (Object)baseJsonVo.getStatus(), (Object)baseJsonVo.getMessage());
        return baseJsonVo;
    }

    @RequestMapping(value={"/updateProductSalesNumByProId"})
    public BaseJsonVo updateProductSalesNumByProId(Map<String, Integer> producSalesNummap, Integer cityId) {
        BaseJsonVo baseJsonVo = this.mallProductSalesInterface.updateProductSalesNumByProId(producSalesNummap, cityId);
        this.log.info("===================baseJsonVo=======baseJsonVo={}", (Object)baseJsonVo.getStatus(), (Object)baseJsonVo.getMessage());
        return baseJsonVo;
    }
}

