/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.weixin;

import cc.lechun.active.vo.ActiveBaseVo;
import cc.lechun.active.vo.ActiveVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/keyworldManage"})
public class WeiXinKeywordController
extends BaseController {
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private WeiXinMediaInterface weiXinMediaService;

    @RequestMapping(value={"/getEnableKeywords"})
    public ActiveBaseVo<List<WeiXinKeywordEntity>> getEnableKeywords(ActiveVo activeVo) {
        ActiveBaseVo activeBaseVo;
        activeBaseVo.setStatus(((List)(activeBaseVo = new ActiveBaseVo()).getData()).size() >= 1 ? 1 : 0);
        return activeBaseVo;
    }

    @RequestMapping(value={"/getKeywordsList"})
    public Map<String, Object> getKeywordsList(PageForm pageForm, WeiXinKeywordEntity keywordEntity) throws AuthorizeException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int platformGroupId = this.getUser().getPlatformGroupId();
        keywordEntity.setPlatformGroupId(Integer.valueOf(platformGroupId));
        if (keywordEntity.getKeyword() != null && keywordEntity.getKeyword().isEmpty()) {
            keywordEntity.setKeyword(null);
        }
        if (keywordEntity.getTitle() != null && keywordEntity.getTitle().isEmpty()) {
            keywordEntity.setTitle(null);
        }
        List keywordlist = this.weiXinKeywordService.getKeywordList4Media(pageForm.getCurrentPage(), pageForm.getPageSize(), keywordEntity);
        map.put("keywordList", new PageInfo(keywordlist));
        map.put("platFormList", this.platFormService.getValidPlatFormList(platformGroupId));
        map.put("mediaList", this.weiXinMediaService.getMediaListForOption(keywordEntity.getPlatformId()));
        return map;
    }

    @RequestMapping(value={"/saveKeywords"})
    public BaseJsonVo saveKeywords(WeiXinKeywordEntity weiXinKeywordEntity) throws AuthorizeException {
        if (weiXinKeywordEntity.getPlatformGroupId() == null || weiXinKeywordEntity.getPlatformGroupId() == 0) {
            weiXinKeywordEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
            weiXinKeywordEntity.setStatus(Short.valueOf((short)1));
        }
        return this.weiXinKeywordService.saveKeyword(weiXinKeywordEntity);
    }

    @RequestMapping(value={"/getKeyword"})
    public ActiveBaseVo<WeiXinKeywordEntity> getKeywordById(Integer id) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        activeBaseVo.setData((Object)this.weiXinKeywordService.getWeiXinKeywordById(id.intValue()));
        return activeBaseVo;
    }

    @RequestMapping(value={"/deleteKeyword"})
    public BaseJsonVo deleteKeywordById(Integer id) {
        boolean b = this.weiXinKeywordService.deleteKeyword(id.intValue());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"/getKeywordsOptionList"})
    public List<WeiXinKeywordEntity> getKeywordsOptionList(Integer platformId) throws AuthorizeException {
        return this.weiXinKeywordService.getEnableKeywordList(platformId);
    }
}

