/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.weixin;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.MallImportExcelService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.MallMessageConfigEntity;
import cc.lechun.mall.entity.weixin.MallTemplateMessageLogEntity;
import cc.lechun.mall.entity.weixin.MessageTestParamVo;
import cc.lechun.mall.entity.weixin.TemplateMessageBodyVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.weixin.MallMessageConfigInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageLogInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/wexinMessage"})
public class WeiXinMessageController
extends BaseController {
    @Autowired
    private MallMessageConfigInterface messageConfigInterface;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private TemplateMessageLogInterface templateMessageLogInterface;
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MessageInterface messageInterface;
    @Autowired
    private MallImportExcelService mallImportExcelService;

    @RequestMapping(value={"saveMessageConfig"})
    @ResponseBody
    public BaseJsonVo saveMessageConfig(MallMessageConfigEntity configEntity) throws AuthorizeException {
        configEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        configEntity.setCreateUserId(this.getUser().getUserId());
        return this.messageConfigInterface.save(configEntity);
    }

    @RequestMapping(value={"selectMessageConfig"})
    public Map<String, Object> selectMessageConfig(Integer messageConfigId) throws AuthorizeException {
        HashedMap map = new HashedMap();
        if (messageConfigId == null) {
            return map;
        }
        map.put("messageConfig", this.messageConfigInterface.select(messageConfigId.intValue()));
        map.put("active", this.activeInterface.getEnableActiveForOption());
        map.put("actionType", this.dictionaryInterface.getValidDictionaryList(this.getUser().getPlatformGroupId(), Integer.valueOf(51)));
        map.put("action", this.dictionaryInterface.getValidDictionaryList(this.getUser().getPlatformGroupId(), Integer.valueOf(52)));
        return map;
    }

    @RequestMapping(value={"deleteMessageConfig"})
    public BaseJsonVo deleteMessageConfig(int messageConfigId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.messageConfigInterface.delete(Integer.valueOf(messageConfigId)));
    }

    @RequestMapping(value={"listMessageConfig"})
    public BaseJsonVo listMessageConfig(MallMessageConfigEntity configEntity) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.messageConfigInterface.getMessageConfigList(configEntity));
    }

    @RequestMapping(value={"saveTemplateMessage"})
    @ResponseBody
    public BaseJsonVo saveTemplateMessage(TemplateMessageEntity entity) throws AuthorizeException {
        entity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        return this.templateMessageInterface.save(entity);
    }

    @RequestMapping(value={"selectTemplateMessage"})
    public Map<String, Object> selectTemplateMessage(Integer messageId) throws AuthorizeException {
        List templateMessageBodyVos = new ArrayList();
        TemplateMessageEntity templateMessage = null;
        if (messageId != null) {
            templateMessage = this.templateMessageInterface.getTemplateMessage(messageId);
        }
        HashedMap map = new HashedMap();
        map.put("messageEntity", templateMessage);
        if (templateMessage != null && !templateMessage.getVariable().isEmpty()) {
            templateMessageBodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)templateMessage.getVariable());
        }
        map.put("body", templateMessageBodyVos);
        return map;
    }

    @RequestMapping(value={"listTemplateMessage"})
    public Map<String, Object> listTemplateMessage(PageForm pageForm, TemplateMessageEntity entity) throws AuthorizeException {
        HashedMap map = new HashedMap();
        entity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        if (entity.getMessageName() != null && entity.getMessageName().isEmpty()) {
            entity.setMessageName(null);
        }
        String platformGroupName = this.platFormGroupInterface.getPlatFormGroup(this.getUser().getPlatformGroupId().intValue()).getPlatformGroupName();
        map.put("messageList", this.templateMessageInterface.list(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), entity));
        map.put("platformGroupName", platformGroupName);
        return map;
    }

    @RequestMapping(value={"deleteTemplateMessage"})
    public BaseJsonVo deleteTemplateMessage(Integer messageId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.templateMessageInterface.delete(messageId));
    }

    @RequestMapping(value={"saveTemplateLogMessage"})
    @ResponseBody
    public BaseJsonVo saveTemplateLogMessage(MallTemplateMessageLogEntity entity) throws AuthorizeException {
        boolean b = this.templateMessageLogInterface.save(entity);
        if (b) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"getTemplateMessagesOption"})
    public List<TemplateMessageEntity> getTemplateMessagesOption(Integer platformId) throws AuthorizeException {
        return this.templateMessageInterface.getTemplateMessageList(platformId);
    }

    @RequestMapping(value={"pushNoticeMQ"})
    public BaseJsonVo pushNoticeMQ(String customerType, String action, Date sendTime, Integer type, Integer platformId) throws AuthorizeException {
        this.messageConfigInterface.pushNoticeMQ(customerType, action, sendTime, type, platformId);
        return BaseJsonVo.success((Object)1);
    }

    @RequestMapping(value={"pushCustomizedNoticeMQ"})
    public BaseJsonVo pushCustomizedNoticeMQ(String type, String action, Integer platformId, String connector, Integer lastCreateTimeBegin, Integer lastCreateTimeEnd, Integer totalOrderNumBegin, Integer totalOrderNumEnd, Integer perOrderCostBegin, Integer perOrderCostEnd) throws AuthorizeException {
        if (StringUtils.isEmpty((String)type) || !"1".equals(type) && !"0".equals(type)) {
            return BaseJsonVo.error((String)"type\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)connector) || !"1".equals(connector) && !"0".equals(connector)) {
            return BaseJsonVo.error((String)"\u8fde\u63a5\u7b26\u53c2\u6570\u9519\u8bef");
        }
        if (lastCreateTimeBegin == null && lastCreateTimeEnd != null || lastCreateTimeBegin != null && lastCreateTimeEnd == null || lastCreateTimeBegin != null && lastCreateTimeEnd != null && lastCreateTimeBegin.compareTo(lastCreateTimeEnd) > 0) {
            return BaseJsonVo.error((String)"\u672b\u5355\u8ddd\u4eca\u5929\u6570\u586b\u5199\u9519\u8bef");
        }
        if (totalOrderNumBegin == null && totalOrderNumEnd != null || totalOrderNumBegin != null && totalOrderNumEnd == null || totalOrderNumBegin != null && totalOrderNumEnd != null && totalOrderNumBegin.compareTo(totalOrderNumEnd) > 0) {
            return BaseJsonVo.error((String)"\u7d2f\u8ba1\u5355\u6570\u586b\u5199\u9519\u8bef");
        }
        if (perOrderCostBegin == null && perOrderCostEnd != null || perOrderCostBegin != null && perOrderCostEnd == null || perOrderCostBegin != null && perOrderCostEnd != null && perOrderCostBegin.compareTo(perOrderCostEnd) > 0) {
            return BaseJsonVo.error((String)"\u5ba2\u5355\u4ef7\u586b\u5199\u9519\u8bef");
        }
        if ("0".equals(type)) {
            Integer sendNum = this.messageConfigInterface.getPushCustomizedNoticeMQNum(action, platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
            return BaseJsonVo.success((Object)sendNum);
        }
        if ("1".equals(type)) {
            this.messageConfigInterface.pushCustomizedNoticeMQ(action, platformId, connector, lastCreateTimeBegin, lastCreateTimeEnd, totalOrderNumBegin, totalOrderNumEnd, perOrderCostBegin, perOrderCostEnd);
            return BaseJsonVo.success((Object)1);
        }
        return BaseJsonVo.success((Object)1);
    }

    @RequestMapping(value={"pushCustomerNum"})
    public BaseJsonVo pushCustomerNum(String customerType, String action) {
        return this.messageConfigInterface.pushCustomerNum(customerType, action);
    }

    @RequestMapping(value={"testSendMessage"})
    public BaseJsonVo testSendMessage(MessageTestParamVo messageTestParamVo) {
        return this.messageInterface.testSendMessage(messageTestParamVo.getSendObject(), messageTestParamVo.getMessageConfigId(), messageTestParamVo.getPlatformId());
    }

    @RequestMapping(value={"testMiniSendMessage"})
    public BaseJsonVo testMiniSendMessage(MessageTestParamVo messageTestParamVo) {
        this.messageConfigInterface.pushNoticeMQTest(messageTestParamVo.getSendObject(), messageTestParamVo.getMessageConfigId(), messageTestParamVo.getPlatformId());
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"importCustomerInfoUrl"}, method={RequestMethod.POST})
    public BaseJsonVo importCustomerInfoUrl(@RequestParam(value="file") MultipartFile file, String actionId) {
        return this.mallImportExcelService.importCustomerInfoUrl(file, actionId);
    }

    @RequestMapping(value={"putAllUsersIntoRedisSet"})
    public BaseJsonVo putAllUsersIntoRedisSet() {
        this.messageConfigInterface.putAllUsersIntoRedisSet();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"pushAll"})
    public BaseJsonVo pushAll() {
        this.messageConfigInterface.pushNoticeMQFromRedisSet();
        return BaseJsonVo.success((Object)"");
    }
}

