/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller;

import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.user.MallUserInterface;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallUserInterface mallUserInterface;
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;

    protected MallUserEntity getUser() throws AuthorizeException {
        Subject subject = SecurityUtils.getSubject();
        if (null != subject && null != subject.getPrincipal()) {
            MallUserEntity user = (MallUserEntity)subject.getPrincipal();
            return user;
        }
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        Cookie userName = CookieUtils.getCookie((HttpServletRequest)request, (String)"userName");
        if (userName != null) {
            MallUserEntity userEntity = new MallUserEntity();
            userEntity.setUserName(userName.getValue());
            userEntity = (MallUserEntity)this.mallUserInterface.getSingle((Object)userEntity);
            if (userEntity != null) {
                return userEntity;
            }
        }
        throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
    }

    protected List<PlatFormEntity> getUserPlatFormList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.getUserPlatFormList(user.getPlatformGroupId().intValue(), user.getPlatformId());
    }

    protected List<PlatFormEntity> getUserPlatFormList2() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.getUserPlatFormList(user.getPlatformGroupId().intValue());
    }

    protected List<PlatFormEntity> getUserPlatFormList(int platformGroupId, String platformIds) {
        List ls = null;
        ls = platformGroupId == 0 ? this.platFormInterface.getValidPlatFormList4All() : this.platFormInterface.getValidPlatFormList(platformGroupId);
        if (StringUtils.isEmpty((String)platformIds)) {
            return ls;
        }
        List<String> platFormList = Arrays.asList(platformIds.split(","));
        return ls.stream().filter(platFormEntity -> platFormList.contains(platFormEntity.getPlatformId() + "")).collect(Collectors.toList());
    }

    protected List<PlatFormEntity> getUserPlatFormList(int platformGroupId) {
        List ls = null;
        ls = platformGroupId == 0 ? this.platFormInterface.getValidPlatFormList4All() : this.platFormInterface.getValidPlatFormList(platformGroupId);
        if (ls != null && ls.size() > 0) {
            ls.stream().filter(platFormEntity -> platFormEntity.getPlatformName().contains("\u5fae\u4fe1") || platFormEntity.getPlatformName().contains("\u5c0f\u7a0b\u5e8f")).collect(Collectors.toList());
        }
        return ls;
    }

    protected String getUserPlatFormNames(int platformGroupId, String platformIds) {
        if (StringUtils.isEmpty((String)platformIds)) {
            return "\u5168\u90e8";
        }
        return String.join((CharSequence)",", this.getUserPlatFormList(platformGroupId, platformIds).stream().map(platFormEntity -> platFormEntity.getPlatformName()).collect(Collectors.toList()));
    }

    protected List<PlatFormGroupEntity> getUserValidPlatFormGroupList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.getUserValidPlatFormGroupList(user.getPlatformGroupId());
    }

    protected List<PlatFormGroupEntity> getUserValidPlatFormGroupList(Integer platformGroupId) {
        List ls = this.platFormGroupInterface.getValidPlatFormGroupList();
        if (platformGroupId != null && platformGroupId != 0) {
            ls = ls.stream().filter(platFormGroupEntity -> platformGroupId.equals(platFormGroupEntity.getPlatformGroupId())).collect(Collectors.toList());
        }
        return ls;
    }

    protected String getUserValidPlatFormGroupName(Integer platformGroupId) {
        String name = "\u5168\u90e8\u516c\u53f8";
        if (platformGroupId != null && platformGroupId != 0) {
            name = this.platFormGroupInterface.getPlatFormGroup(platformGroupId.intValue()).getPlatformGroupName();
        }
        return name;
    }
}

