/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.UrlScheme;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.minischeme.MiniSchemeEntity;
import cc.lechun.mall.entity.minischeme.MiniSchemeQueryVo;
import cc.lechun.mall.iservice.minischeme.MiniSchemeInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/urlScheme"})
public class UrlSchemeController
extends BaseController {
    @Autowired
    private MiniSchemeInterface miniSchemeInterface;
    @Autowired
    private PlatFormInterface platFormService;

    @RequestMapping(value={"/saveUrlScheme"})
    public BaseJsonVo saveMiniSchemeEntity(MiniSchemeEntity miniSchemeEntity) throws AuthorizeException {
        return this.miniSchemeInterface.saveMiniScheme(miniSchemeEntity);
    }

    @RequestMapping(value={"/getUrlSchemeList"})
    public BaseJsonVo getUrlSchemeList(MiniSchemeQueryVo miniSchemeQueryVo) throws AuthorizeException {
        HashMap map = new HashMap();
        map.put("platFormList", this.platFormService.getPlatFormList(this.getUser().getPlatformGroupId().intValue()));
        miniSchemeQueryVo.setSchemeType(Integer.valueOf(0));
        map.put("schemeList", this.miniSchemeInterface.getMiniSchemeList(miniSchemeQueryVo));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/delete"})
    public BaseJsonVo delete(int urlSchemeId) throws AuthorizeException {
        return this.miniSchemeInterface.deleteMiniScheme(urlSchemeId);
    }

    @RequestMapping(value={"/getMiniSchemeSystem"})
    public BaseJsonVo getMiniSchemeSystem(Integer linkType, Integer activeType, @RequestParam Map<String, Object> params) throws AuthorizeException {
        if (linkType == null) {
            linkType = 1;
        }
        if (activeType == null) {
            activeType = -1;
        }
        try {
            params = (Map)JsonUtils.fromJson((String)params.get("params").toString(), Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (activeType.equals(2)) {
            if (params == null) {
                params = new HashedMap();
            }
            params.put("orderMainNo", "201603041583609");
        }
        return this.miniSchemeInterface.getMiniSchemeSystem(linkType, activeType, params);
    }

    @RequestMapping(value={"/getMiniSchemeSystemByPara"})
    public BaseJsonVo getMiniSchemeSystemByPara(String miniPath) throws AuthorizeException {
        return this.miniSchemeInterface.getMiniSchemeSystemByPara(miniPath);
    }
}

