/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveIndexEntity;
import cc.lechun.active.entity.active.ActiveItemEntity;
import cc.lechun.active.entity.active.ActivePageEntity;
import cc.lechun.active.entity.active.ActiveQueryVo;
import cc.lechun.active.entity.active.ActiveRuleEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveItemInterface;
import cc.lechun.active.iservice.active.ActivePageInterface;
import cc.lechun.active.iservice.active.ActiveRuleInterface;
import cc.lechun.active.service.check.ActiveCheckOnlineContext;
import cc.lechun.active.vo.ActiveBaseVo;
import cc.lechun.active.vo.ActiveCashticketVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/activeManage"})
public class ActiveController
extends BaseController {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private ActiveRuleInterface activeRuleService;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private PlatFormGroupInterface platFormGroupService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private ActiveCashticketInterface activeCashticketServcie;
    @Autowired
    private ActivePageInterface activePageService;
    @Autowired
    private ActiveCheckOnlineContext checkOnlineContext;
    @Autowired
    private DistributorItemInterface distributorItemInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    private ActiveItemInterface activeItemInterface;

    @RequestMapping(value={"/saveActiveIndex"})
    public BaseJsonVo saveActiveIndex(ActiveIndexEntity activeIndexEntity) {
        return this.activeIndexInterface.saveActiveIndex(activeIndexEntity);
    }

    @RequestMapping(value={"/deletActiveIndex"})
    public BaseJsonVo deletActiveIndex(Integer activeIndexId) {
        return this.activeIndexInterface.deleteByPrimaryKey((Serializable)activeIndexId) >= 1 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25\u8bf7\u91cd\u8bd5!");
    }

    @RequestMapping(value={"/getActiveIndexList"})
    public BaseJsonVo getActiveIndexList(PageForm pageForm, String activeNo) {
        return BaseJsonVo.success((Object)this.activeIndexInterface.getActiveIndexList(pageForm, Integer.valueOf(1000), activeNo));
    }

    @RequestMapping(value={"/activeOnlineCheck"})
    public BaseJsonVo ActiveOnlineCheck(String activeNo, Integer status) {
        BaseJsonVo js = this.checkOnlineContext.checkOnLine(activeNo, status);
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/saveActive"})
    public BaseJsonVo saveActive(ActiveEntity active, HttpServletRequest request, HttpServletResponse response) {
        ActiveEntity activeEntity;
        BaseJsonVo js = this.activeService.saveActive(active);
        if (js.isSuccess() && (activeEntity = (ActiveEntity)js.getValue()) != null) {
            this.distributorItemInterface.initDistributorItem(activeEntity.getActiveNo(), Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/getActiveList"})
    public BaseJsonVo getActiveList(ActiveQueryVo activeQueryVo) {
        return BaseJsonVo.success((Object)this.activeService.getActiveList(activeQueryVo));
    }

    @RequestMapping(value={"/getActive/{activeNo}"})
    public ActiveEntity getActiveParam(@PathVariable String activeNo) {
        return this.activeService.getActiveEntityByActiveNo(activeNo);
    }

    @RequestMapping(value={"/getActive"})
    public BaseJsonVo getActive(String activeNo) {
        return BaseJsonVo.success((Object)this.activeService.getActiveEntityByActiveNo(activeNo));
    }

    @RequestMapping(value={"/getActiveForOption"})
    public BaseJsonVo getEnableActiveList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.activeService.getActiveForOption(user.getPlatformGroupId()));
    }

    @RequestMapping(value={"/getActiveForOptionList"})
    public BaseJsonVo getActiveForOptionList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.activeService.getActiveForOptionByStatus(Integer.valueOf(1), user.getPlatformGroupId()));
    }

    @RequestMapping(value={"/getActiveForOptionListByType"})
    public BaseJsonVo getActiveForOptionListByType(Integer activeType) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.activeService.getActiveForOptionListByType(activeType));
    }

    @RequestMapping(value={"/changeActiveStatus"})
    public BaseJsonVo changeActiveStatus(String activeNo) {
        BaseJsonVo js;
        ActiveEntity activeEntity = this.activeService.getActiveEntityByActiveNo(activeNo);
        ActiveEntity update = new ActiveEntity();
        update.setStatus(Integer.valueOf(activeEntity.getStatus() == 1 ? 0 : 1));
        BaseJsonVo baseJsonVo = js = this.activeService.updateActive(activeEntity) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
        }
        return js;
    }

    @RequestMapping(value={"/deleteActive/{activeNo}"})
    public ActiveBaseVo<String> deleteActive(@PathVariable String activeNo) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        boolean result = this.activeService.deleteActive(activeNo);
        if (result) {
            activeBaseVo.setStatus(1);
            this.distributorItemInterface.initDistributorItem(activeNo, Integer.valueOf(5));
            activeBaseVo.setMsg("\u6210\u529f");
        } else {
            activeBaseVo.setStatus(0);
            activeBaseVo.setMsg("\u6d3b\u52a8\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5~");
        }
        return activeBaseVo;
    }

    @RequestMapping(value={"/saveActiveRule"})
    public BaseJsonVo saveActiveRule(ActiveRuleEntity activeRuleEntity) {
        return this.activeRuleService.saveActiveRule(activeRuleEntity);
    }

    @RequestMapping(value={"/getActiveRuleList"})
    public BaseJsonVo getActiveList(String activeNo) {
        return BaseJsonVo.success((Object)this.activeRuleService.getRuleList(activeNo));
    }

    @RequestMapping(value={"/deleteActiveRule"})
    public BaseJsonVo deleteActiveRule(int id) {
        return this.activeRuleService.deleteActiveRule(id) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/getActiveCashticket"})
    public ActiveBaseVo<List<ActiveCashticketVo>> getActiveCashticket(String bindCode, Integer platformId) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        activeBaseVo.setData((Object)this.activeCashticketServcie.getActiveCashticketList(bindCode, platformId));
        return activeBaseVo;
    }

    @RequestMapping(value={"/saveActivePage"})
    public BaseJsonVo saveActivePage(ActivePageEntity activePageEntity) {
        return this.activePageService.saveActivePage(activePageEntity);
    }

    @RequestMapping(value={"/getActivePage"})
    public BaseJsonVo getActivePage(String activeNo) {
        return BaseJsonVo.success((Object)this.activePageService.getActivePageEntityByActiveNo(activeNo));
    }

    @RequestMapping(value={"/saveActiveCheckInConfig"})
    public BaseJsonVo saveActiveCheckInConfig(String activeNo, String remindText, Integer maxCount) {
        return this.activeService.saveActiveCheckInConfig(activeNo, remindText, maxCount);
    }

    @RequestMapping(value={"/getActiveCheckInConfig"})
    public BaseJsonVo getActiveCheckInConfig(String activeNo) {
        return this.activeService.getActiveCheckInConfig(activeNo);
    }

    @RequestMapping(value={"/copyActive"})
    public BaseJsonVo copyActive(String activeNo) {
        return this.activeService.copyActive(activeNo, Integer.valueOf(1));
    }

    @RequestMapping(value={"/getOptionActiveList"})
    public BaseJsonVo getOptionActiveList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.activeService.getOptionActiveList(this.getUser().getPlatformGroupId(), null));
    }

    @RequestMapping(value={"/getActiveItemList"})
    public BaseJsonVo getActiveItemList(ActiveItemEntity activeItemEntity, int currentPage, int pageSize) {
        return BaseJsonVo.success((Object)this.activeItemInterface.getActiveItemList(activeItemEntity, currentPage, pageSize));
    }

    @RequestMapping(value={"/deleteActiveItem"})
    public BaseJsonVo deleteActiveItem(ActiveItemEntity activeItemEntity) {
        return this.activeItemInterface.deleteActiveItem(activeItemEntity);
    }

    @RequestMapping(value={"/saveActiveItem"})
    public BaseJsonVo saveActiveItem(ActiveItemEntity activeItemEntity) {
        if (StringUtils.isNotEmpty((String)activeItemEntity.getItemId())) {
            if (activeItemEntity.getItemId().contains("[")) {
                String[] lst = activeItemEntity.getItemId().replace("[", "").replace("]", "").replace("\"", "").replace("\"", "").split(",");
                if (lst.length == 0) {
                    return BaseJsonVo.error((String)"\u89e3\u6790\u591a\u9009\u7684\u5546\u54c1\u5f02\u5e38");
                }
                for (String item : lst) {
                    this.log.info("\u5546\u54c1Id:{}", (Object)item);
                    activeItemEntity.setItemId(item);
                    BaseJsonVo jsonVo = this.activeItemInterface.saveActiveItem(activeItemEntity);
                    if (jsonVo.isSuccess()) continue;
                    return jsonVo;
                }
            } else {
                BaseJsonVo jsonVo = this.activeItemInterface.saveActiveItem(activeItemEntity);
                if (!jsonVo.isSuccess()) {
                    return jsonVo;
                }
            }
        } else {
            return BaseJsonVo.error((String)"\u5546\u54c1Id\u4e3a\u7a7a\u4e0d\u80fd\u4fdd\u5b58");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/saveItemSalePriceList"})
    public BaseJsonVo saveItemSalePriceList(Integer id, String priceList) {
        return this.activeItemInterface.saveItemSalePriceList(id, priceList);
    }

    @RequestMapping(value={"/setActiveItemStatus"})
    public BaseJsonVo setActiveItemStatus(Integer id, Integer status) {
        return this.activeItemInterface.setActiveItemStatus(id, status);
    }
}

