/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.collage;

import cc.lechun.active.entity.collage.CollageConfigEntity;
import cc.lechun.active.entity.collage.CollageConfigProductEntity;
import cc.lechun.active.entity.collage.CollageConfigVo;
import cc.lechun.active.entity.collage.CollageDiscountEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/collageManage"})
public class CollageController
extends BaseController {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private OssService ossService;

    @RequestMapping(value={"getCollageConfigList"})
    public BaseJsonVo getCollageList(PageForm pageForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, List> map = new HashMap<String, List>();
        Integer[] activeTypes = null;
        map.put("activeData", this.activeInterface.getOptionActiveList(this.getUser().getPlatformGroupId(), activeTypes));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveCollageConfig"})
    public BaseJsonVo saveCollageConfig(CollageConfigVo collageConfig) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"uploadCollageConfigBanner"})
    public BaseJsonVo uploadCollageConfigBanner(MultipartFile file) throws AuthorizeException, IOException {
        if (file == null) {
            return BaseJsonVo.error((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        String path = AliyunOSSDir.TEMP_IMG_STORAGE.getPath().replace("$date", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd")) + file.getOriginalFilename();
        this.ossService.uploadFile(path, file.getInputStream());
        return BaseJsonVo.success((Object)this.ossService.getImageResoure(path));
    }

    @RequestMapping(value={"getCollageProductConfigList"})
    public BaseJsonVo getCollageProductConfigList(String activeNo) throws AuthorizeException {
        HashMap map = new HashMap();
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveCollageProductConfigList"})
    public BaseJsonVo saveCollageProductConfig(String list) throws UnsupportedEncodingException {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"saveCollageProductConfig"})
    public BaseJsonVo saveCollageProductConfig(CollageConfigProductEntity collageConfigProduct) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"deleteCollageProductConfig"})
    public BaseJsonVo deleteCollageProductConfig(String id) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getCollageDiscountConfigList"})
    public BaseJsonVo getCollageDiscountConfigList(String activeNo) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"saveCollageDiscountConfig"})
    public BaseJsonVo saveCollageDiscountConfig(CollageDiscountEntity collageDiscount) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"setCollageConfigProduct"})
    public BaseJsonVo setCollageConfigProduct(CollageConfigEntity configEntity) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"deleteCollageDiscountConfig"})
    public BaseJsonVo deleteCollageDiscountConfig(String id) {
        return BaseJsonVo.success((Object)"");
    }
}

