/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.groupon;

import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponDetailExportVo;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponQueryVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/grouponManage"})
public class GrouponManageController
extends BaseController {
    @Autowired
    private GrouponInterface grouponService;
    @Autowired
    private PlatFormInterface platFormService;

    @RequestMapping(value={"getGrouponOrderList"})
    public BaseJsonVo getGrouponQueryVoList(GrouponQueryVo grouponQueryVo) {
        return BaseJsonVo.success((Object)this.grouponService.getGrouponQueryVoList(grouponQueryVo));
    }

    @RequestMapping(value={"getGrouponDtailList"})
    public BaseJsonVo getGrouponDtailList(GrouponQueryVo grouponQueryVo) {
        grouponQueryVo.setPageSize(Integer.valueOf(500));
        return BaseJsonVo.success((Object)this.grouponService.getGrouponDtailList(grouponQueryVo));
    }

    @RequestMapping(value={"/downloadJoinOrder"})
    public void downloadJoinOrder(GrouponQueryVo grouponQueryVo, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            GrouponEntity grouponEntity = this.grouponService.getGrouponEntity(grouponQueryVo.getInviteId());
            String fileName = URLEncoder.encode(grouponEntity.getGroupName(), "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            List orderList = this.grouponService.getGrouponDetailExportVoList(grouponQueryVo);
            EasyExcel.write((OutputStream)response.getOutputStream(), GrouponDetailExportVo.class).autoCloseStream(Boolean.FALSE).sheet("\u8ba2\u5355").doWrite(orderList);
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"creatGroup"})
    public BaseJsonVo creatGroup(GrouponEntity grouponEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        grouponEntity.setCustomerId(user.getUserId());
        return this.grouponService.creatGroup(grouponEntity);
    }

    @RequestMapping(value={"getLink"})
    public BaseJsonVo getLink(String inviteId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.grouponService.getLink(inviteId));
    }

    @RequestMapping(value={"setPrize"})
    public BaseJsonVo setPrize(String inviteId) {
        return this.grouponService.setPrize(inviteId);
    }

    @RequestMapping(value={"getGrouponList"})
    public BaseJsonVo getGrouponList(GrouponQueryVo grouponQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.grouponService.getGrouponQueryVoList(grouponQueryVo));
    }

    @RequestMapping(value={"saveGrouponConfig"})
    public BaseJsonVo saveGrouponConfig(GrouponConfigEntity grouponConfigEntity) {
        return this.grouponService.saveGrouponConfig(grouponConfigEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @RequestMapping(value={"getGrouponConfig"})
    public BaseJsonVo getGrouponConfig(String activeNo) throws AuthorizeException {
        int platformGroupId = this.getUser().getPlatformGroupId();
        HashMap map = new HashMap();
        map.put("platFormList", this.platFormService.getValidPlatFormList(platformGroupId));
        map.put("grouponConfig", this.grouponService.getGrouponConfig(activeNo));
        return BaseJsonVo.success(map);
    }
}

