/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.property;

import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActivePropertyQueryVo;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import java.io.UnsupportedEncodingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"property"})
public class PropertyController
extends BaseController {
    @Autowired
    private ActivePropertyInterface activePropertyInterface;

    @RequestMapping(value={"/saveActiveProperty"})
    public BaseJsonVo saveActiveProperty(ActivePropertyEntity activePropertyEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        activePropertyEntity.setPlatformGroupId(user.getPlatformGroupId());
        return this.activePropertyInterface.saveActiveProperty(activePropertyEntity);
    }

    @RequestMapping(value={"/deleteActiveProperty"})
    public BaseJsonVo deleteActiveProperty(ActivePropertyEntity activePropertyEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        activePropertyEntity.setPlatformGroupId(user.getPlatformGroupId());
        return this.activePropertyInterface.deleteActiveProperty(activePropertyEntity);
    }

    @RequestMapping(value={"/saveActivePropertyList"})
    public BaseJsonVo saveActivePropertyList(String itemList) throws AuthorizeException, UnsupportedEncodingException {
        MallUserEntity user = this.getUser();
        return this.activePropertyInterface.saveReunionActiveProperty(itemList, user.getPlatformGroupId());
    }

    @RequestMapping(value={"/getActivePropertyList"})
    public BaseJsonVo getActivePropertyList(ActivePropertyQueryVo activePropertyQueryVo) throws AuthorizeException {
        if (activePropertyQueryVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u6761\u4ef6");
        }
        return BaseJsonVo.success((Object)this.activePropertyInterface.getActivePropertyList(activePropertyQueryVo));
    }

    @RequestMapping(value={"/getActiveProperty"})
    public BaseJsonVo getActiveProperty(ActivePropertyQueryVo activePropertyQueryVo) throws AuthorizeException {
        if (activePropertyQueryVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u6761\u4ef6");
        }
        return this.activePropertyInterface.getActiveProperty(activePropertyQueryVo);
    }

    @RequestMapping(value={"/getActiveValuePropertyList"})
    public BaseJsonVo getActiveValuePropertyList(ActivePropertyQueryVo activePropertyQueryVo) throws AuthorizeException {
        if (activePropertyQueryVo == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u6761\u4ef6");
        }
        if (StringUtils.isEmpty((String)activePropertyQueryVo.getPropertyName())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u5c5e\u6027");
        }
        return this.activePropertyInterface.getPicPropertyList(activePropertyQueryVo);
    }
}

