/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.reserve;

import cc.lechun.active.entity.active.ActivePropertyEntity;
import cc.lechun.active.entity.active.ActiveReserveQueryVo;
import cc.lechun.active.entity.active.ReserveCustomerDo;
import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.active.service.message.MarketMessage;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reserveManage"})
public class ReserveController
extends BaseController {
    @Autowired
    private ReserveInterface reserveService;
    @Autowired
    MarketMessage marketMessage;

    @RequestMapping(value={"/exportCustomer"})
    public void exportCustomer(String proId, Integer status, String type, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u9884\u7ea6\u7528\u6237", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), ReserveCustomerDo.class).autoCloseStream(Boolean.FALSE).sheet("\u9884\u7ea6\u7528\u6237").doWrite(this.reserveService.exportCustomer(proId, status, type));
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"/getReserveList"})
    public BaseJsonVo getActiveList(ActiveReserveQueryVo activeReserveQueryVo) {
        return BaseJsonVo.success((Object)this.reserveService.reserveList(activeReserveQueryVo));
    }

    @RequestMapping(value={"/sendReserveMessage"})
    public BaseJsonVo sendReserveMessage(String bindCode, String type) {
        String actionId = "\u9884\u7ea6\u63d0\u9192\u6a21\u677f";
        if (Objects.equals(type, "1")) {
            actionId = "reserveArrived";
        }
        return this.marketMessage.sendReserveMessage(bindCode, type, actionId);
    }

    @RequestMapping(value={"/testSendReserveMessage"})
    public BaseJsonVo testSendReserveMessage() {
        ActivePropertyEntity activePropertyEntity = new ActivePropertyEntity();
        return this.marketMessage.sendReserveMessage(DateUtils.now());
    }

    @RequestMapping(value={"/testSendSMSMessage"})
    public BaseJsonVo testSendSMSMessage() {
        return this.marketMessage.sendSMSMessage(DateUtils.now());
    }

    @RequestMapping(value={"/testSendNewUserGiftSMSMessage"})
    public BaseJsonVo testSendNewUserGiftSMSMessage(String operationId) {
        return this.marketMessage.sendNewUserGiftSMSMessage(operationId);
    }

    @RequestMapping(value={"/sendPreview"})
    public BaseJsonVo sendPreview(String openId, String actionId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.marketMessage.sendPreview(openId, Integer.valueOf(1000), StringUtils.isNotEmpty((String)actionId) ? actionId : "\u9884\u7ea6\u63d0\u9192\u6a21\u677f");
    }

    @RequestMapping(value={"/sendReserveCoupon"})
    public BaseJsonVo sendReserveCoupon(String bindCode) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.reserveService.sendReserveCoupon(bindCode);
    }

    @RequestMapping(value={"/sendCoupon"})
    BaseJsonVo sendReserveCoupon(String bindCode, String type, String proId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.reserveService.sendReserveCoupon(bindCode, type, proId);
    }
}

