/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.common;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.common.MallTreeVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverCityInterface;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class MallCommonController
extends BaseController {
    @Autowired
    private CustomerAddressInterface addressInterface;
    @Autowired
    private DeliverCityInterface deliverCityService;

    @RequestMapping(value={"getProvinceCity"})
    public List<MallTreeVo> getProvinceCity(Integer transportType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.addressInterface.getProvinceCity(user.getPlatformGroupId().intValue(), transportType.intValue());
    }

    @RequestMapping(value={"getEnableallCityList"})
    public BaseJsonVo getEnableallCityList(Integer transportType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.deliverCityService.getEnableAllCityList(transportType.intValue()));
    }

    @RequestMapping(value={"getProvinceCityMap"})
    public BaseJsonVo getProvinceCityMap() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        String regionDataName = "label";
        String regionDataValue = "value";
        return BaseJsonVo.success((Object)this.addressInterface.getProvinceCity(regionDataName, regionDataValue));
    }

    @RequestMapping(value={"getTablePrimaryKey"})
    public BaseJsonVo getTablePrimaryKey() {
        return BaseJsonVo.success((Object)IDGenerate.getUniqueIdStr());
    }
}

