/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.customer;

import cc.lechun.apiinvoke.mall.CustomerInfoInvoke;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerFreeEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerFreeInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardFreeInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customerFree"})
public class CustomerFreeController
extends BaseController {
    @Autowired
    private CustomerFreeInterface customerFreeInterface;
    @Autowired
    private PrepayCardFreeInterface prepayCardFreeInterface;
    @Autowired
    private CustomerInfoInvoke customerInfoInvoke;

    @RequestMapping(value={"/getCustomerFreePool"})
    public BaseJsonVo getCustomerFreePool(String customerId) {
        return BaseJsonVo.success((Object)this.customerFreeInterface.getCustomerFreePool(customerId));
    }

    @RequestMapping(value={"/disabledFreePoolProduct"})
    public BaseJsonVo disabledFreePoolProduct(Integer id) {
        return this.customerFreeInterface.disabledFreePoolProduct(id);
    }

    @RequestMapping(value={"/addFreeProductToPool"})
    @ResponseBody
    public BaseJsonVo addFreeProductToPool(@RequestBody CustomerFreeEntity freeEntityDTO) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        freeEntityDTO.setCreater(user.getUserNick());
        freeEntityDTO.setQyWeixinUserid(user.getQyWeixinUserid());
        return this.customerInfoInvoke.addFreeProductToPool(JsonUtils.toJson((Object)freeEntityDTO, (boolean)false));
    }

    @RequestMapping(value={"/recordFreeAndDistribution"})
    @ResponseBody
    public BaseJsonVo recordFreeAndDistribution(String customerId, String orderMainNo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        this.log.info(customerId + "," + orderMainNo);
        return this.customerInfoInvoke.recordFreeAndDistribution(orderMainNo, user.getQyWeixinUserid(), customerId);
    }

    @RequestMapping(value={"/cleanFreePoolProduct"})
    public BaseJsonVo cleanFreePoolProduct(Integer id) {
        return this.customerFreeInterface.cleanFreePoolProduct(id);
    }
}

