/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.deliver;

import cc.lechun.apiinvoke.mall.MiniShopInvoke;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.LogisticsEntity;
import cc.lechun.mall.iservice.deliver.LogisticsInterface;
import cc.lechun.mall.iservice.deliver.MallOrderDeliverRecordInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logistics"})
public class MallLogisticsController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(MallLogisticsController.class);
    @Autowired
    private LogisticsInterface logisticsInterface;
    @Autowired
    private MallOrderDeliverRecordInterface deliverRecordInterface;
    @Autowired
    private MiniShopInvoke miniShopInvoke;

    @RequestMapping(value={"/getMiniShopLogisticsList"})
    public BaseJsonVo getMiniShopLogisticsList() throws AuthorizeException {
        return this.miniShopInvoke.getLogisticsList();
    }

    @RequestMapping(value={"/saveLogisticsLink"})
    public BaseJsonVo saveLogisticsLink(LogisticsEntity logisticsEntity, BindingResult result) throws AuthorizeException {
        return this.logisticsInterface.save(logisticsEntity);
    }

    @RequestMapping(value={"/getLogisticsList"})
    public BaseJsonVo getLogisticsList(Integer currentPage, Integer pageSize) throws AuthorizeException {
        return this.logisticsInterface.getList(currentPage, pageSize);
    }

    @RequestMapping(value={"/pullOrderRouteInfo"})
    public BaseJsonVo pullOrderRouteInfo() throws AuthorizeException {
        return this.deliverRecordInterface.pullOrderRouteInfo();
    }
}

