/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.distribution;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.enums.sql.SqlLikeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.sql.SqlUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.WordsEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.distribution.WordsInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/distribution"})
public class DistributionController
extends BaseController {
    @Autowired
    private WordsInterface wordsInterface;

    @RequestMapping(value={"/saveWords"})
    public BaseJsonVo saveWords(WordsEntity wordsEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (user != null && wordsEntity.getId() == null) {
            wordsEntity.setCreateUser(user.getUserNick());
        }
        return this.wordsInterface.saveWords(wordsEntity);
    }

    @RequestMapping(value={"/deleteWords"})
    public BaseJsonVo deleteWords(Integer id) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.wordsInterface.deleteWords(id);
    }

    @RequestMapping(value={"/getWordsList"})
    public BaseJsonVo getWordsList(int currentPage, int pageSize, WordsEntity wordsEntity) {
        if ("".equals(wordsEntity.getUserAllWords())) {
            wordsEntity.setUserAllWords(null);
        }
        wordsEntity.setUserAllWords(SqlUtils.sqlLike((String)wordsEntity.getUserAllWords(), (SqlLikeEnum)SqlLikeEnum.sqlLike_All));
        return BaseJsonVo.success((Object)this.wordsInterface.getWordsList(Integer.valueOf(currentPage), Integer.valueOf(pageSize), wordsEntity, "ID desc"));
    }

    @RequestMapping(value={"/getWordsEntity"})
    public BaseJsonVo getWordsEntity(Integer id) {
        return BaseJsonVo.success((Object)this.wordsInterface.getWordsEntity(id));
    }
}

