/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.distribution;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.common.weixin.MessageUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.BatchMediaStaffDo;
import cc.lechun.mall.entity.distribution.DistributionMediaEntity;
import cc.lechun.mall.entity.distribution.DistributionMediaQueryVo;
import cc.lechun.mall.entity.distribution.DistributionMediaStaffEntity;
import cc.lechun.mall.entity.distribution.DistributionOrderVo;
import cc.lechun.mall.entity.distribution.DistributorEntity;
import cc.lechun.mall.entity.distribution.DistributorGroupEntity;
import cc.lechun.mall.entity.distribution.DistributorItemEntity;
import cc.lechun.mall.entity.distribution.DistributorItemEntityVo;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.entity.distribution.DistributorVo;
import cc.lechun.mall.entity.distribution.OffLineShopEntity;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.entity.distribution.ShopSalePersionEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionMediaBaseInterface;
import cc.lechun.mall.iservice.distribution.DistributionOrderInterface;
import cc.lechun.mall.iservice.distribution.DistributorGroupInterface;
import cc.lechun.mall.iservice.distribution.DistributorInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.distribution.OffLineShopInterface;
import cc.lechun.mall.iservice.distribution.QwConfigInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.distribution.ShopSalePersionInterface;
import cc.lechun.qiyeweixin.service.callback.CorpCallBackContext;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/distributor"})
public class DistributorController
extends BaseController {
    @Autowired
    private DistributorGroupInterface distributorGroupInterface;
    @Autowired
    private DistributorInterface distributorInterface;
    @Autowired
    private DistributorRelationInterface distributorRelationInterface;
    @Autowired
    private DistributionInviteInterface distributionInviteInterface;
    @Autowired
    private DistributionOrderInterface distributionOrderInterface;
    @Autowired
    private ShareInterface shareInterface;
    @Autowired
    private OssService ossService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private DistributorItemInterface distributorItemInterface;
    @Autowired
    private DistributionMediaBaseInterface distributionMediaBaseInterface;
    @Autowired
    private OffLineShopInterface offLineShopInterface;
    @Autowired
    private ShopSalePersionInterface shopSalePersionInterface;
    @Autowired
    private QwConfigInterface qwConfigInterface;
    @Autowired
    CorpCallBackContext corpCallBackContext;

    @RequestMapping(value={"/getOffLineShopList"})
    public BaseJsonVo getOffLineShopList(String cityName, String shopName) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        OffLineShopEntity offLineShopEntity = new OffLineShopEntity();
        if (StringUtils.isNotEmpty((String)cityName)) {
            offLineShopEntity.setCityName(cityName);
        }
        if (StringUtils.isNotEmpty((String)shopName)) {
            offLineShopEntity.setShopName(shopName);
        }
        return BaseJsonVo.success((Object)this.offLineShopInterface.getList((Object)offLineShopEntity, 0L));
    }

    @RequestMapping(value={"/getSalePersionList"})
    public BaseJsonVo getSalePersionList(String salePersonName, String salePersonMobile) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        ShopSalePersionEntity shopSalePersionEntity = new ShopSalePersionEntity();
        if (StringUtils.isNotEmpty((String)salePersonName)) {
            shopSalePersionEntity.setSalePersonName(salePersonName);
        }
        if (StringUtils.isNotEmpty((String)salePersonMobile)) {
            shopSalePersionEntity.setSalePersonMobile(salePersonMobile);
        }
        return BaseJsonVo.success((Object)this.shopSalePersionInterface.getList((Object)shopSalePersionEntity, 0L));
    }

    @RequestMapping(value={"/saveOffLineShop"})
    public BaseJsonVo saveOffLineShop(OffLineShopEntity offLineShopEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.offLineShopInterface.insertOrUpdate((Object)offLineShopEntity));
    }

    @RequestMapping(value={"/saveSalePersion"})
    public BaseJsonVo saveSalePersion(ShopSalePersionEntity shopSalePersionEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.shopSalePersionInterface.insertOrUpdate((Object)shopSalePersionEntity));
    }

    @RequestMapping(value={"/deleteOffLineShop"})
    public BaseJsonVo deleteOffLineShop(Integer shopId) throws AuthorizeException {
        OffLineShopEntity offLineShopEntity;
        MallUserEntity user = this.getUser();
        offLineShopEntity.setStatus(Integer.valueOf((offLineShopEntity = (OffLineShopEntity)this.offLineShopInterface.selectByPrimaryKey((Serializable)shopId)).getStatus() == 1 ? 0 : 1));
        return BaseJsonVo.success((Object)this.offLineShopInterface.updateByPrimaryKeySelective((Object)offLineShopEntity));
    }

    @RequestMapping(value={"/deleteShopSalePersion"})
    public BaseJsonVo deleteShopSalePersion(Integer salePersonId) throws AuthorizeException {
        ShopSalePersionEntity shopSalePersionEntity;
        MallUserEntity user = this.getUser();
        shopSalePersionEntity.setStatus(Integer.valueOf((shopSalePersionEntity = (ShopSalePersionEntity)this.shopSalePersionInterface.selectByPrimaryKey((Serializable)salePersonId)).getStatus() == 1 ? 0 : 1));
        return BaseJsonVo.success((Object)this.shopSalePersionInterface.updateByPrimaryKeySelective((Object)shopSalePersionEntity));
    }

    @RequestMapping(value={"/saveBatchMediaStaff"})
    public BaseJsonVo saveBatchMediaStaff(BatchMediaStaffDo batchMediaStaffDo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.saveBatchMediaStaff(batchMediaStaffDo));
    }

    @RequestMapping(value={"/getDistributionMedia"})
    public BaseJsonVo getDistributionMedia(Integer mediaId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.getDistributionMedia(mediaId));
    }

    @RequestMapping(value={"/getDistributionMediaList"})
    public BaseJsonVo getDistributionMediaList(DistributionMediaQueryVo distributionMediaQueryVo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.getDistributionMediaList(distributionMediaQueryVo));
    }

    @RequestMapping(value={"/deleteMedia"})
    public BaseJsonVo deleteMedia(Integer mediaId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.deleteMedia(mediaId));
    }

    @RequestMapping(value={"/deleteMediaStaff"})
    public BaseJsonVo deleteMediaStaff(Integer mediaStaffId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.deleteMediaStaff(mediaStaffId));
    }

    @RequestMapping(value={"/getDistributionMediaStaffList"})
    public BaseJsonVo getDistributionMediaStaffList(DistributionMediaStaffEntity distributionMediaStaffEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.getDistributionMediaStaffList(distributionMediaStaffEntity));
    }

    @RequestMapping(value={"/getDistributorLinkVoList"})
    public BaseJsonVo getDistributorLinkVoList(String miniPath) {
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.getDistributorLinkVoList(miniPath));
    }

    @RequestMapping(value={"/saveDistributionMedia"})
    public BaseJsonVo saveDistributionMedia(DistributionMediaEntity distributionMediaEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.save(distributionMediaEntity));
    }

    @RequestMapping(value={"/saveDistributionStaffMedia"})
    public BaseJsonVo saveDistributionStaffMedia(DistributionMediaStaffEntity distributionMediaStaffVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.distributionMediaBaseInterface.save(distributionMediaStaffVo));
    }

    @RequestMapping(value={"/saveGroup"})
    public BaseJsonVo saveGroup(DistributorGroupEntity groupEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (groupEntity.getId() == null) {
            groupEntity.setCreateTime(new Date());
        }
        groupEntity.setUpdateTime(new Date());
        groupEntity.setOperater(user.getUserNick());
        return this.distributorGroupInterface.saveGroup(groupEntity);
    }

    @RequestMapping(value={"/getGroup"})
    public BaseJsonVo getGroup(Integer id) {
        DistributorGroupEntity groupEntity = (DistributorGroupEntity)this.distributorGroupInterface.selectByPrimaryKey((Serializable)id);
        if (groupEntity != null) {
            return BaseJsonVo.success((Object)groupEntity);
        }
        return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"/getGroupOption"})
    public BaseJsonVo getGroupOption(Integer id) {
        return BaseJsonVo.success((Object)this.distributorGroupInterface.getList((Object)new DistributorGroupEntity()));
    }

    @RequestMapping(value={"/deleteGroup"})
    public BaseJsonVo deleteGroup(Integer id) {
        DistributorGroupEntity groupEntity = (DistributorGroupEntity)this.distributorGroupInterface.selectByPrimaryKey((Serializable)id);
        if (groupEntity == null) {
            return BaseJsonVo.error((String)"\u5206\u7ec4\u540d\u79f0\u4e0d\u5b58\u5728");
        }
        DistributorEntity param = new DistributorEntity();
        param.setGroupId(id);
        if (this.distributorInterface.existsByEntity((Object)param) > 0) {
            return BaseJsonVo.error((String)"\u5206\u7ec4\u4e0b\u5df2\u7ecf\u6709\u5206\u9500\u5458\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.distributorGroupInterface.deleteByPrimaryKey((Serializable)id);
        return BaseJsonVo.success((Object)"\u5206\u4eab\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getGroupPageList"})
    public BaseJsonVo getGroupPageList(PageForm pageForm, DistributorGroupEntity groupEntity) {
        return BaseJsonVo.success((Object)this.distributorGroupInterface.getGroupPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), groupEntity));
    }

    @RequestMapping(value={"/saveDistributor"})
    public BaseJsonVo saveDistributor(DistributorVo distributorVo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (distributorVo.getId() == null) {
            distributorVo.setCreateTime(new Date());
        }
        distributorVo.setUpdateTime(new Date());
        distributorVo.setOperater(user.getUserNick());
        return this.distributorInterface.saveDistributor(distributorVo);
    }

    @RequestMapping(value={"/getDistributor"})
    public BaseJsonVo getDistributor(Integer id) {
        List relationEntityList;
        DistributorEntity entity = (DistributorEntity)this.distributorInterface.selectByPrimaryKey((Serializable)id);
        if (entity != null && (relationEntityList = this.distributorRelationInterface.getDistributorRelation(id)).size() > 0) {
            CustomerEntity customerEntity;
            DistributorVo distributorVo = new DistributorVo();
            BeanUtils.beanCopy(relationEntityList.get(0), (Object)distributorVo);
            BeanUtils.beanCopy((Object)entity, (Object)distributorVo);
            if (StringUtils.isNotEmpty((String)((DistributorRelationEntity)relationEntityList.get(0)).getRelationUserId()) && (customerEntity = this.customerInterface.getCustomer(((DistributorRelationEntity)relationEntityList.get(0)).getRelationUserId())) != null) {
                distributorVo.setRelationNickName(customerEntity.getNickName());
            }
            return BaseJsonVo.success((Object)distributorVo);
        }
        return BaseJsonVo.error((String)"\u5206\u9500\u5458\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"/getDistributorPageList"})
    public BaseJsonVo getDistributorPageList(PageForm pageForm, DistributorEntity entity) {
        return BaseJsonVo.success((Object)this.distributorInterface.getDistributorPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), entity));
    }

    @RequestMapping(value={"/getDistributorOption"})
    public BaseJsonVo getDistributorOption(DistributorEntity entity) {
        return BaseJsonVo.success((Object)this.distributorInterface.getList((Object)entity));
    }

    @RequestMapping(value={"/getDistributionInvitePageList"})
    public BaseJsonVo getDistributionInvitePageList(PageForm pageForm, Integer distributorId, String sdate, String edate, String mobile, String nickName) {
        Date endDate;
        Date beginDate = StringUtils.isEmpty((String)sdate) ? null : DateUtils.getDateFromString((String)sdate.split("T")[0], (String)"yyyy-MM-dd");
        Date date = endDate = StringUtils.isEmpty((String)edate) ? null : DateUtils.getDateFromString((String)edate.split("T")[0], (String)"yyyy-MM-dd");
        if (endDate != null) {
            endDate = DateUtils.getAddDateByDay((Date)endDate, (int)1);
        }
        return BaseJsonVo.success((Object)this.distributionInviteInterface.getListVo(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), distributorId, beginDate, endDate, mobile, nickName));
    }

    @RequestMapping(value={"/saveShare"})
    public BaseJsonVo saveShare(ShareEntity shareEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (shareEntity.getId() == null) {
            shareEntity.setCreateTime(new Date());
        }
        shareEntity.setUpdateTime(new Date());
        shareEntity.setOperater(user.getUserNick());
        return this.shareInterface.saveShare(shareEntity);
    }

    @RequestMapping(value={"/getShare"})
    public BaseJsonVo getShare(Integer id) {
        ShareEntity shareEntity = (ShareEntity)this.shareInterface.selectByPrimaryKey((Serializable)id);
        if (shareEntity != null) {
            shareEntity.setShareImageUrl(this.ossService.getImageResoure(shareEntity.getShareImageUrl()));
            return BaseJsonVo.success((Object)shareEntity);
        }
        return BaseJsonVo.error((String)"\u5206\u4eab\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"/deleteShare"})
    public BaseJsonVo deleteShare(Integer id) {
        ShareEntity shareEntity = (ShareEntity)this.shareInterface.selectByPrimaryKey((Serializable)id);
        if (shareEntity == null) {
            return BaseJsonVo.error((String)"\u5206\u4eab\u4e0d\u5b58\u5728");
        }
        if (shareEntity.getDefaultConfig() == 1) {
            return BaseJsonVo.error((String)"\u9ed8\u8ba4\u7684\u5206\u4eab\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.shareInterface.deleteByPrimaryKey((Serializable)id);
        return BaseJsonVo.success((Object)"\u5206\u4eab\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getSharePageList"})
    public BaseJsonVo getSharePageList(PageForm pageForm, ShareEntity shareEntity) {
        return BaseJsonVo.success((Object)this.shareInterface.getSharePageList(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), shareEntity));
    }

    @RequestMapping(value={"/getDistributionOrderPageList"})
    public BaseJsonVo getDistributionOrderPageList(PageForm pageForm, DistributionOrderVo vo) {
        if (vo.getEdate() != null) {
            vo.setEdate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)vo.getEdate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        }
        return BaseJsonVo.success((Object)this.distributionOrderInterface.getListVo(Integer.valueOf(pageForm.getCurrentPage()), Integer.valueOf(pageForm.getPageSize()), vo));
    }

    @RequestMapping(value={"/test"})
    public void getorderfinial() {
        this.distributionOrderInterface.finishDistributionOrders();
    }

    @RequestMapping(value={"initDistributorItem"})
    public BaseJsonVo initDistributorItem(String itemId, Integer groupType) {
        return this.distributorItemInterface.initDistributorItem(itemId, groupType);
    }

    @RequestMapping(value={"getDistributorItemList"})
    public BaseJsonVo getDistributorItemList(PageForm pageForm, DistributorItemEntity entity) {
        return BaseJsonVo.success((Object)this.distributorItemInterface.getDistributorItemList(pageForm.getCurrentPage(), pageForm.getPageSize(), entity));
    }

    @RequestMapping(value={"getSingleDistributorItem"})
    public BaseJsonVo getSingleDistributorItem(Integer id) {
        return BaseJsonVo.success((Object)this.distributorItemInterface.getSingleDistributorItem(id));
    }

    @RequestMapping(value={"saveDistributorItem"})
    public BaseJsonVo saveDistributorItem(@RequestParam(value="entities") String entities) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (StringUtil.isNotEmpty((String)entities)) {
            List entityVos = JsonUtils.getListByArray(DistributorItemEntityVo.class, (String)entities);
            if (entityVos.size() == 0) {
                return BaseJsonVo.success((Object)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570entities\u4e3a\u7a7a");
            }
            return this.distributorItemInterface.saveDistributorItem(entityVos, user);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570entities\u4e3a\u7a7a");
    }

    @RequestMapping(value={"getQiyeWeixinFollowUsers"})
    public BaseJsonVo getQiyeWeixinFollowUsers() {
        return this.distributorInterface.getQiyeWeixinFollowUsers();
    }

    @RequestMapping(value={"getQiyeWeixinFollowUserContacts"})
    public BaseJsonVo getQiyeWeixinFollowUserContacts(String userId, String externalId) {
        return this.distributorInterface.addOrUpdateExternalContact(userId, externalId);
    }

    @RequestMapping(value={"getQiyeWeixinFollowUserContactResult"})
    public BaseJsonVo getQiyeWeixinFollowUserContactResult(String userId, String externalId) {
        return this.distributorInterface.getQiyeWeixinFollowUserContactResult(userId, externalId);
    }

    @RequestMapping(value={"sendInvitePageMsg"})
    public BaseJsonVo sendInvitePageMsg(String bindcode) {
        return this.distributorInterface.sendInvitePageMsg(bindcode);
    }

    @RequestMapping(value={"addQYFollowUserContact"})
    public String addQYFollowUserContact(@RequestBody String requestBody, String msg_signature, String timestamp, String nonce, String cid) throws Exception {
        this.log.debug("<<<<<<<<< requestBody: " + requestBody);
        this.log.debug("<<<<<<<<< msg_signature: " + msg_signature);
        this.log.debug("<<<<<<<<< timestamp: " + timestamp);
        this.log.debug("<<<<<<<<< nonce: " + nonce);
        requestBody = this.processArg(requestBody);
        msg_signature = this.processArg(msg_signature);
        timestamp = this.processArg(timestamp);
        nonce = this.processArg(nonce);
        String token = "6YmuO";
        String wxCorpId = "wwc2a973e34f38f9e5";
        String encodingAesKey = "NnOsLbLDAeGNtjSlkQzHKwh8ImAhge8EdMpzizTUIJf";
        WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(token, encodingAesKey, wxCorpId);
        String sMsg = wxcpt.decryptMsg(msg_signature, timestamp, nonce, requestBody);
        this.log.debug(" >>>>>>>> \u5fae\u4fe1\u56de\u8c03\u4fe1\u606f:{} ", (Object)sMsg);
        Map dataMap = MessageUtil.parseXml((String)sMsg);
        String dataJson = JSON.toJSONString((Object)dataMap);
        this.log.debug(dataJson);
        return this.corpCallBackContext.callBack(dataJson);
    }

    private String processArg(String arg) {
        int index = arg.indexOf(",");
        if (index > 0) {
            return arg.substring(index + 1);
        }
        return arg;
    }

    @RequestMapping(value={"getQwConfig"})
    public BaseJsonVo getQwConfig(String url, String type, long timestamp, String nonceStr) {
        timestamp = DateUtils.nowMillis();
        return this.qwConfigInterface.getWeiXinPermissionsValidationConfig(url, type, timestamp, nonceStr);
    }

    @RequestMapping(value={"syncContactBatchWithoutTag"})
    public BaseJsonVo syncContactBatchWithoutTag() {
        return this.distributorInterface.syncContactBatchWithoutTag();
    }

    @RequestMapping(value={"afterSyncContactBatchDoDeleteContact"})
    public BaseJsonVo afterSyncContactBatchDoDeleteContact() {
        return this.distributorInterface.afterSyncContactBatchDoDeleteContact();
    }
}

