/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.edb;

import cc.lechun.cms.controller.edb.EdbController;
import cc.lechun.common.enums.trade.OrderFailsEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.RefundSourceEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderFailsEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.entity.trade.MallRefundEntity;
import cc.lechun.mall.entity.trade.OrderRefundApplyVo;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallRefundInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.OrderRefundInterface;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/edb"})
public class EdbController {
    private static final Logger log = LoggerFactory.getLogger(EdbController.class);
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private OrderRefundInterface orderRefundInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Autowired
    private MallRefundInterface mallRefundInterface;

    @RequestMapping(value={"/order/refundSync"})
    public BaseJsonVo refundSync(String orderNo, String return_amount, String wechat_refund, String alipay_refund, String balance_refund) {
        BaseJsonVo baseJsonVo;
        MallOrderMainEntity mallOrderMainEntity;
        MallOrderEntity orderEntity;
        int returnOrderType;
        BigDecimal balanceAmount;
        BigDecimal alipayAmount;
        BigDecimal wechatAmount;
        BigDecimal returnAmount;
        1 paramsMap;
        BaseJsonVo returnBaseJson;
        String finalOrderNo;
        block38: {
            block37: {
                block36: {
                    block35: {
                        finalOrderNo = orderNo;
                        log.info("\u8ba2\u5355[" + finalOrderNo + "]\u88ab\u91cd\u5b9a\u5411\u5230\u6b64cms\u4e2d");
                        returnBaseJson = null;
                        String return_Amount = return_amount;
                        String wechat_Refund = wechat_refund;
                        String alipay_Refund = alipay_refund;
                        String balance_Refund = balance_refund;
                        paramsMap = new /* Unavailable Anonymous Inner Class!! */;
                        log.info("**********\u8fdb\u5165\u540c\u610f\u9000\u6b3e\u63a5\u53e3********orderNo={},return_amount={},wechat_refund={},alipay_refund={},balance_refund={}", new Object[]{finalOrderNo, return_amount, wechat_refund, alipay_refund, balance_refund});
                        if (!StringUtils.isEmpty((String)finalOrderNo)) break block35;
                        BaseJsonVo baseJsonVo2 = returnBaseJson = BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570\uff1a\u8ba2\u5355\u53f7");
                        log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
                        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                        entity.setApiName("refundSync");
                        entity.setOrderNo(finalOrderNo);
                        entity.setSuccess(Integer.valueOf(0));
                        List list = this.orderSyncInfoService.getList(entity);
                        log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list.size());
                        if (list.size() >= 5) {
                            log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
                            MallOrderFailsEntity fail = new MallOrderFailsEntity();
                            fail.setOrderNo(finalOrderNo);
                            fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
                            fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
                            fail.setCreateTime(DateUtils.now());
                            fail.setFailReason(returnBaseJson.getError_msg());
                            BaseJsonVo vo = this.orderSyncInfoService.recordOrderFails(fail);
                            log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo.isSuccess());
                            returnBaseJson.setStatus(200);
                            returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
                        } else {
                            log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
                            entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                            entity.setDirection(Integer.valueOf(1));
                            entity.setCreateTime(DateUtils.now());
                            entity.setSyncName("EDB");
                            entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                            entity.setWarnLevel(Integer.valueOf(5));
                            entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                            this.orderSyncInfoService.recordInfo(entity);
                        }
                        return baseJsonVo2;
                    }
                    if (StringUtils.isEmpty((String)return_amount)) {
                        return_amount = "0";
                    }
                    if (StringUtils.isEmpty((String)wechat_refund)) {
                        wechat_refund = "0";
                    }
                    if (StringUtils.isEmpty((String)alipay_refund)) {
                        alipay_refund = "0";
                    }
                    if (StringUtils.isEmpty((String)balance_refund)) {
                        balance_refund = "0";
                    }
                    if (return_amount.contains("\u5143")) {
                        return_amount = return_amount.replace("\u5143", "");
                    }
                    if (wechat_refund.contains("\u5143")) {
                        wechat_refund = wechat_refund.replace("\u5143", "");
                    }
                    if (alipay_refund.contains("\u5143")) {
                        alipay_refund = alipay_refund.replace("\u5143", "");
                    }
                    if (balance_refund.contains("\u5143")) {
                        balance_refund = balance_refund.replace("\u5143", "");
                    }
                    returnAmount = PriceUtils.format((String)return_amount);
                    wechatAmount = PriceUtils.format((String)wechat_refund);
                    alipayAmount = PriceUtils.format((String)alipay_refund);
                    balanceAmount = PriceUtils.format((String)balance_refund);
                    if (returnAmount.compareTo(BigDecimal.ZERO) != 0 || wechatAmount.compareTo(BigDecimal.ZERO) != 0 || alipayAmount.compareTo(BigDecimal.ZERO) != 0 || balanceAmount.compareTo(BigDecimal.ZERO) != 0) break block36;
                    BaseJsonVo vo = returnBaseJson = BaseJsonVo.error((String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5168\u90e8\u4e3a0");
                    log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
                    MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                    entity.setApiName("refundSync");
                    entity.setOrderNo(finalOrderNo);
                    entity.setSuccess(Integer.valueOf(0));
                    List list = this.orderSyncInfoService.getList(entity);
                    log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list.size());
                    if (list.size() >= 5) {
                        log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
                        MallOrderFailsEntity fail = new MallOrderFailsEntity();
                        fail.setOrderNo(finalOrderNo);
                        fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
                        fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
                        fail.setCreateTime(DateUtils.now());
                        fail.setFailReason(returnBaseJson.getError_msg());
                        BaseJsonVo vo2 = this.orderSyncInfoService.recordOrderFails(fail);
                        log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo2.isSuccess());
                        returnBaseJson.setStatus(200);
                        returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
                    } else {
                        log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
                        entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                        entity.setDirection(Integer.valueOf(1));
                        entity.setCreateTime(DateUtils.now());
                        entity.setSyncName("EDB");
                        entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                        entity.setWarnLevel(Integer.valueOf(5));
                        entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                        this.orderSyncInfoService.recordInfo(entity);
                    }
                    return vo;
                }
                if (PriceUtils.format((BigDecimal)wechatAmount.add(alipayAmount).add(balanceAmount)).compareTo(BigDecimal.ZERO) > 0) {
                    returnAmount = PriceUtils.format((BigDecimal)wechatAmount.add(alipayAmount).add(balanceAmount));
                }
                returnOrderType = 1;
                orderEntity = this.orderInterface.getmallOrder(finalOrderNo);
                if (orderEntity != null) break block37;
                BaseJsonVo list = returnBaseJson = BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728OrderNo:" + finalOrderNo));
                log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("refundSync");
                entity.setOrderNo(finalOrderNo);
                entity.setSuccess(Integer.valueOf(0));
                List list2 = this.orderSyncInfoService.getList(entity);
                log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list2.size());
                if (list2.size() >= 5) {
                    log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
                    MallOrderFailsEntity fail = new MallOrderFailsEntity();
                    fail.setOrderNo(finalOrderNo);
                    fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
                    fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
                    fail.setCreateTime(DateUtils.now());
                    fail.setFailReason(returnBaseJson.getError_msg());
                    BaseJsonVo vo = this.orderSyncInfoService.recordOrderFails(fail);
                    log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo.isSuccess());
                    returnBaseJson.setStatus(200);
                    returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
                } else {
                    log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
                    entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                    entity.setDirection(Integer.valueOf(1));
                    entity.setCreateTime(DateUtils.now());
                    entity.setSyncName("EDB");
                    entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                    entity.setWarnLevel(Integer.valueOf(5));
                    entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                    this.orderSyncInfoService.recordInfo(entity);
                }
                return list;
            }
            mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
            if (mallOrderMainEntity != null) break block38;
            BaseJsonVo entity = returnBaseJson = BaseJsonVo.error((String)("\u8ba2\u5355\u4e0d\u5b58\u5728OrderNo:" + finalOrderNo));
            log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
            MallOrderSyncInfoEntity entity2 = new MallOrderSyncInfoEntity();
            entity2.setApiName("refundSync");
            entity2.setOrderNo(finalOrderNo);
            entity2.setSuccess(Integer.valueOf(0));
            List list = this.orderSyncInfoService.getList(entity2);
            log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list.size());
            if (list.size() >= 5) {
                log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
                MallOrderFailsEntity fail = new MallOrderFailsEntity();
                fail.setOrderNo(finalOrderNo);
                fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
                fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
                fail.setCreateTime(DateUtils.now());
                fail.setFailReason(returnBaseJson.getError_msg());
                BaseJsonVo vo = this.orderSyncInfoService.recordOrderFails(fail);
                log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo.isSuccess());
                returnBaseJson.setStatus(200);
                returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
            } else {
                log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
                entity2.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                entity2.setDirection(Integer.valueOf(1));
                entity2.setCreateTime(DateUtils.now());
                entity2.setSyncName("EDB");
                entity2.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                entity2.setWarnLevel(Integer.valueOf(5));
                entity2.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                this.orderSyncInfoService.recordInfo(entity2);
            }
            return entity;
        }
        try {
            BigDecimal sumReturnAmount;
            boolean isMilkFlag = false;
            if (OrderSourceEnum.CARDPLAN.getValue() == mallOrderMainEntity.getOrderSource().intValue()) {
                isMilkFlag = true;
                String sourceOrderNo = mallOrderMainEntity.getSourceOrderNo();
                MallOrderEntity mallOrderEntity = new MallOrderEntity();
                mallOrderEntity.setOrderMainNo(sourceOrderNo);
                mallOrderEntity = this.orderInterface.getmallOrder(mallOrderEntity);
                orderNo = mallOrderEntity.getOrderNo();
                orderEntity = mallOrderEntity;
            }
            BigDecimal factReturnAmountSum = new BigDecimal(0);
            BigDecimal payAmountSum = new BigDecimal(0);
            MallRefundEntity mallRefundEntity = this.orderRefundInterface.getReturnAmountSum(orderEntity.getOrderMainNo());
            MallOrderPayEntity mallOrderPayEntity = this.mallOrderPayInterface.getPayAmountSum(orderEntity.getOrderMainNo());
            if (mallRefundEntity != null) {
                factReturnAmountSum = PriceUtils.format((BigDecimal)mallRefundEntity.getFactReturnAmount());
            }
            if (mallOrderPayEntity != null) {
                payAmountSum = PriceUtils.format((BigDecimal)mallOrderPayEntity.getPayamount());
            }
            if (payAmountSum.compareTo(sumReturnAmount = PriceUtils.format((BigDecimal)factReturnAmountSum.add(returnAmount))) > 0) {
                returnOrderType = 2;
            }
            if (orderEntity.getStatus() >= 10) {
                returnOrderType = 2;
            }
            OrderRefundApplyVo refundApplyVo = new OrderRefundApplyVo();
            refundApplyVo.setOrderMainNo(orderEntity.getOrderMainNo());
            refundApplyVo.setOrderNo(orderNo);
            refundApplyVo.setSourceEnum(RefundSourceEnum.edb);
            refundApplyVo.setRefundOrderType(returnOrderType);
            refundApplyVo.setReason("EDB\u9000\u6b3e");
            refundApplyVo.setReturnAmount(returnAmount);
            refundApplyVo.setPayDetailVos(null);
            refundApplyVo.setBalanceAmount(balanceAmount);
            refundApplyVo.setCashAmount(PriceUtils.format((BigDecimal)wechatAmount.add(alipayAmount)));
            refundApplyVo.setIsRefundCoupon(2);
            refundApplyVo.setOtherTkOrderNo(mallOrderMainEntity.getOrderMainNo());
            refundApplyVo.setOperator("edb-system");
            returnBaseJson = this.orderRefundInterface.createRefundBill(refundApplyVo, isMilkFlag);
            if (returnBaseJson.isSuccess()) {
                MallRefundEntity refundEntity = (MallRefundEntity)returnBaseJson.getValue();
                returnBaseJson = this.orderRefundInterface.passOrderRefund(refundEntity.getRefundId(), "edb-system", null);
            }
            baseJsonVo = returnBaseJson;
        }
        catch (Exception e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)sw, true));
                returnBaseJson = BaseJsonVo.error((String)sw.toString());
                throw e;
            }
            catch (Throwable throwable) {
                log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
                MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                entity.setApiName("refundSync");
                entity.setOrderNo(finalOrderNo);
                entity.setSuccess(Integer.valueOf(0));
                List list = this.orderSyncInfoService.getList(entity);
                log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list.size());
                if (list.size() >= 5) {
                    log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
                    MallOrderFailsEntity fail = new MallOrderFailsEntity();
                    fail.setOrderNo(finalOrderNo);
                    fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
                    fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
                    fail.setCreateTime(DateUtils.now());
                    fail.setFailReason(returnBaseJson.getError_msg());
                    BaseJsonVo vo = this.orderSyncInfoService.recordOrderFails(fail);
                    log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo.isSuccess());
                    returnBaseJson.setStatus(200);
                    returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
                } else {
                    log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
                    entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
                    entity.setDirection(Integer.valueOf(1));
                    entity.setCreateTime(DateUtils.now());
                    entity.setSyncName("EDB");
                    entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
                    entity.setWarnLevel(Integer.valueOf(5));
                    entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
                    this.orderSyncInfoService.recordInfo(entity);
                }
                throw throwable;
            }
        }
        log.info("\u5373\u5c06\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570:" + finalOrderNo);
        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
        entity.setApiName("refundSync");
        entity.setOrderNo(finalOrderNo);
        entity.setSuccess(Integer.valueOf(0));
        List list = this.orderSyncInfoService.getList(entity);
        log.info("\u67e5\u8be2\u6b64\u8ba2\u5355\u7684\u9000\u6b3e\u540c\u6b65\u8bb0\u5f55\u6570[" + finalOrderNo + "]\u4e3a:" + list.size());
        if (list.size() >= 5) {
            log.info("\u51c6\u5907\u63d2\u5165fail\u8868[" + finalOrderNo + "]");
            MallOrderFailsEntity fail = new MallOrderFailsEntity();
            fail.setOrderNo(finalOrderNo);
            fail.setFailType(Integer.valueOf(OrderFailsEnum.REFUND_ORDER.getValue()));
            fail.setFailTitle("EDB\u540c\u6b65\u8ba2\u5355\u5931\u8d25");
            fail.setCreateTime(DateUtils.now());
            fail.setFailReason(returnBaseJson.getError_msg());
            BaseJsonVo vo = this.orderSyncInfoService.recordOrderFails(fail);
            log.info("\u63d2\u5165fail\u8868[" + finalOrderNo + "]\u7ed3\u679c:" + vo.isSuccess());
            returnBaseJson.setStatus(200);
            returnBaseJson.setMessage("\u591a\u6b21\u540c\u6b65\u5931\u8d25");
        } else {
            log.info("\u51c6\u5907\u63d2\u5165sync\u8868[" + finalOrderNo + "]");
            entity.setApiParam(JsonUtils.toJson((Object)paramsMap, (boolean)false));
            entity.setDirection(Integer.valueOf(1));
            entity.setCreateTime(DateUtils.now());
            entity.setSyncName("EDB");
            entity.setApiReturn(returnBaseJson != null ? JsonUtils.toJson((Object)returnBaseJson, (boolean)false) : null);
            entity.setWarnLevel(Integer.valueOf(5));
            entity.setSuccess(Integer.valueOf(returnBaseJson != null && returnBaseJson.isSuccess() ? 1 : 0));
            this.orderSyncInfoService.recordInfo(entity);
        }
        return baseJsonVo;
    }
}

