/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.minishop;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.minishop.ProductQueryVo;
import cc.lechun.mall.service.minishop.MiniShopService;
import cc.lechun.mall.service.minishop.TreeItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.bean.shop.Brand;
import weixin.popular.util.JsonUtil;

@RestController
@RequestMapping(value={"/minishop"})
public class MiniShopController {
    @Autowired
    private MiniShopService miniShopService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/register"})
    public BaseJsonVo register(int platformId) {
        return this.miniShopService.register(platformId);
    }

    @RequestMapping(value={"/getSkuCatList"})
    public BaseJsonVo getSkuCatList(int platformId) {
        BaseJsonVo baseJsonVo = this.miniShopService.getSkuCatList(platformId);
        HashMap resultMap = new HashMap();
        if (baseJsonVo.isSuccess()) {
            HashSet first_catSet = new HashSet();
            ((List)baseJsonVo.getValue()).stream().map(item -> {
                TreeItem mallSelectDataVo = new TreeItem();
                mallSelectDataVo.setId(item.getFirst_cat_id());
                mallSelectDataVo.setName(item.getFirst_cat_name());
                mallSelectDataVo.setParentId(Integer.valueOf(0));
                first_catSet.add(mallSelectDataVo);
                return mallSelectDataVo;
            }).collect(Collectors.toList());
            resultMap.put("firstCat", new ArrayList(first_catSet));
            HashSet second_catList = new HashSet();
            ((List)baseJsonVo.getValue()).stream().map(item -> {
                TreeItem mallSelectDataVo = new TreeItem();
                mallSelectDataVo.setId(item.getSecond_cat_id());
                mallSelectDataVo.setName(item.getSecond_cat_name());
                mallSelectDataVo.setParentId(item.getFirst_cat_id());
                second_catList.add(mallSelectDataVo);
                return mallSelectDataVo;
            }).collect(Collectors.toList());
            resultMap.put("secondtCat", new ArrayList(second_catList));
            HashSet third_catSet = new HashSet();
            ((List)baseJsonVo.getValue()).stream().map(item -> {
                TreeItem mallSelectDataVo = new TreeItem();
                mallSelectDataVo.setId(item.getThird_cat_id());
                mallSelectDataVo.setName(item.getThird_cat_name());
                mallSelectDataVo.setParentId(item.getSecond_cat_id());
                third_catSet.add(mallSelectDataVo);
                return mallSelectDataVo;
            }).collect(Collectors.toList());
            resultMap.put("thirdtCat", new ArrayList(third_catSet));
            return BaseJsonVo.success(resultMap);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/getAllSkuCatList"})
    public BaseJsonVo getAllSkuCatList(int platformId) {
        return this.miniShopService.getSkuCatList(platformId);
    }

    @RequestMapping(value={"/audit_category"})
    public BaseJsonVo audit_category(String data) {
        int platformId = 4;
        return this.miniShopService.audit_category(platformId, data);
    }

    @RequestMapping(value={"/audit_Brand"})
    public BaseJsonVo audit_Brand(String brand) {
        int platformId = 4;
        return this.miniShopService.audit_Brand(platformId, brand);
    }

    @RequestMapping(value={"/testaudit_Brand"})
    public BaseJsonVo testaudit_Brand() {
        int platformId = 4;
        Brand brand = new Brand();
        Brand.AuditReq auditReq = new Brand.AuditReq();
        auditReq.setLicense("http://resourcetest.lechun.cc/1000/sysImg/d9aaf9a7300248fc88c712024212ea41.jpg");
        Brand.AuditReq.BrandInfo brandInfo = new Brand.AuditReq.BrandInfo();
        brandInfo.setBrand_audit_type(1);
        brandInfo.setTrademark_type("29");
        brandInfo.setBrand_management_type(1);
        brandInfo.setCommodity_origin_type(1);
        brandInfo.setBrand_wording("\u4e50\u7eaf");
        ArrayList<String> saleAuthor = new ArrayList<String>();
        saleAuthor.add("http://resourcetest.lechun.cc/1000/sysImg/d9aaf9a7300248fc88c712024212ea41.jpg");
        brandInfo.setSale_authorization(saleAuthor);
        brandInfo.setTrademark_registration_certificate(saleAuthor);
        brandInfo.setTrademark_change_certificate(saleAuthor);
        brandInfo.setTrademark_registrant("http://resourcetest.lechun.cc/1000/sysImg/d9aaf9a7300248fc88c712024212ea41.jpg");
        brandInfo.setTrademark_registrant_nu("\u4e50\u7eaf");
        brandInfo.setTrademark_authorization_period(DateUtils.formatDate((Date)DateUtils.now(), (String)""));
        brandInfo.setTrademark_registration_application("\u4e50\u7eaf");
        brandInfo.setTrademark_applicant("\u4e50\u7eaf");
        brandInfo.setTrademark_application_time(DateUtils.formatDate((Date)DateUtils.now(), (String)""));
        brandInfo.setImported_goods_form(saleAuthor);
        auditReq.setBrand_info(brandInfo);
        brand.setAudit_req(auditReq);
        return this.miniShopService.audit_Brand(platformId, JsonUtil.toJSONString((Object)brand));
    }

    @RequestMapping(value={"/get_brand_list"})
    public BaseJsonVo get_brand_list(int platformId) {
        return this.miniShopService.get_brand_list(platformId);
    }

    @RequestMapping(value={"/get_audit_category"})
    public BaseJsonVo get_audit_category(int platformId, String audit_id) {
        return this.miniShopService.get_audit_category(platformId, audit_id);
    }

    @RequestMapping(value={"/initProduct"})
    public BaseJsonVo initProduct(int platformId) {
        return this.miniShopService.initProduct(platformId);
    }

    @RequestMapping(value={"/getProductList"})
    public BaseJsonVo getProductList(ProductQueryVo productQueryVo) {
        return this.miniShopService.getProductList(4, productQueryVo.getCurrentPage(), productQueryVo.getPageSize(), productQueryVo.getNeed_edit_spu());
    }

    @RequestMapping(value={"/setProductOn"})
    public BaseJsonVo setProductOn(Integer platformId, Integer product_id, String out_product_id) {
        return this.miniShopService.setProductOn(platformId == null ? 4 : platformId, product_id, out_product_id);
    }

    @RequestMapping(value={"/setProductOff"})
    public BaseJsonVo setProductOff(Integer platformId, Integer product_id, String out_product_id) {
        return this.miniShopService.setProductOff(platformId == null ? 4 : platformId, product_id, out_product_id);
    }

    @RequestMapping(value={"/deletProduct"})
    public BaseJsonVo deletProduct(Integer platformId, int product_id, String out_product_id) {
        return this.miniShopService.deleteProduct(platformId == null ? 4 : platformId, product_id, out_product_id);
    }
}

