/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.qiyeweixin;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.qiyeweixin.entity.tag.ContactTagEntity;
import cc.lechun.qiyeweixin.entity.tag.ContactTagGroupQueryVo;
import cc.lechun.qiyeweixin.entity.tag.CorpTagQueryVo;
import cc.lechun.qiyeweixin.entity.tag.NewTagItemVo;
import cc.lechun.qiyeweixin.entity.tag.TagCustomerQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagRuleEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupEntity;
import cc.lechun.qiyeweixin.entity.tag.TagRuleGroupQueryVo;
import cc.lechun.qiyeweixin.entity.tag.TagRuleQueryVo;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagGroupInterface;
import cc.lechun.qiyeweixin.iservice.tag.ContactTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.CorpTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.CustomerTagInterface;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleGroupInterface;
import cc.lechun.qiyeweixin.iservice.tag.TagRuleInterface;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.bean.qy.LaunchCode;

@RestController
@RequestMapping(value={"tag"})
public class TagController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContactTagGroupInterface contactTagGroupInterface;
    @Autowired
    private ContactTagInterface contactTagService;
    @Autowired
    private CustomerTagInterface customerTagService;
    @Autowired
    CorpTagInterface corpTagService;
    @Autowired
    private TagRuleGroupInterface tagRuleGroupService;
    @Autowired
    TagRuleInterface tagRuleService;
    @Autowired
    private SysUserInterface userInterface;

    @RequestMapping(value={"getTagGroupVoList"})
    public BaseJsonVo getTagGroupVoList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.corpTagService.getTagGroupVoList());
    }

    @RequestMapping(value={"getCustomerQiWeiTagVoList"})
    public BaseJsonVo getCustomerQiWeiTagVoList(String item, String userId) throws AuthorizeException {
        this.log.info("\u5f00\u59cb\u67e5\u8be2\u7528\u6237\u6807\u7b7e:{},userId={}", (Object)item, (Object)userId);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        return this.corpTagService.getCustomerQiWeiTagVoList(item, userEntity.getQyWeixinUserid());
    }

    @RequestMapping(value={"getTagGroupList"})
    public BaseJsonVo getTagGroupList(ContactTagGroupQueryVo contactTagGroupQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.contactTagGroupInterface.getTagGroupList(contactTagGroupQueryVo));
    }

    @RequestMapping(value={"getTagList"})
    public BaseJsonVo getTagList(CorpTagQueryVo corpTagQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.contactTagService.getTagList(corpTagQueryVo));
    }

    @RequestMapping(value={"getTagCustomerList"})
    public BaseJsonVo getTagCustomerList(TagCustomerQueryVo tagCustomerQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.customerTagService.getTagCustomerList(tagCustomerQueryVo));
    }

    @RequestMapping(value={"saveTagItem"})
    public BaseJsonVo saveTagItem(String item) throws UnsupportedEncodingException, IOException {
        String items = URLDecoder.decode(item, "UTF-8");
        this.log.info("josn={}", (Object)items);
        NewTagItemVo tagItemVo = (NewTagItemVo)JsonUtils.fromJson((String)items, NewTagItemVo.class);
        return BaseJsonVo.success((Object)this.contactTagService.saveTagItem(tagItemVo));
    }

    @RequestMapping(value={"getTagItem"})
    public BaseJsonVo getTagItem(String tagId) throws UnsupportedEncodingException, IOException {
        return BaseJsonVo.success((Object)this.contactTagService.saveTag(tagId));
    }

    @RequestMapping(value={"saveTag"})
    public BaseJsonVo saveTagItem(ContactTagEntity contactTagEntity) throws UnsupportedEncodingException, IOException {
        return BaseJsonVo.success((Object)this.contactTagService.updateByPrimaryKeySelective((Object)contactTagEntity));
    }

    @RequestMapping(value={"deleteTag"})
    public BaseJsonVo deleteTag(String tagId) {
        return this.corpTagService.deleteTag(tagId);
    }

    @RequestMapping(value={"pullTag"})
    public BaseJsonVo pullTag() {
        return this.corpTagService.pullTag();
    }

    @RequestMapping(value={"getTagRuleGroupList"})
    public BaseJsonVo getTagRuleGroupList(TagRuleGroupQueryVo tagRuleGroupQueryVo) {
        return BaseJsonVo.success((Object)this.tagRuleGroupService.getList(tagRuleGroupQueryVo));
    }

    @RequestMapping(value={"saveRuleGroup"})
    public BaseJsonVo saveRuleGroup(TagRuleGroupEntity tagRuleGroupEntity) {
        if (tagRuleGroupEntity.getCreateTime() == null) {
            tagRuleGroupEntity.setCreateTime(DateUtils.now());
        }
        return BaseJsonVo.success((Object)this.tagRuleGroupService.insertOrUpdate((Object)tagRuleGroupEntity));
    }

    @RequestMapping(value={"deletRuleGroup"})
    public BaseJsonVo deletRuleGroup(Integer id) {
        return BaseJsonVo.success((Object)this.tagRuleGroupService.deleteByPrimaryKey((Serializable)id));
    }

    @RequestMapping(value={"getTagRuleList"})
    public BaseJsonVo getTagRuleList(TagRuleQueryVo tagRuleQueryVo) {
        return BaseJsonVo.success((Object)this.tagRuleService.getList(tagRuleQueryVo));
    }

    @RequestMapping(value={"saveRule"})
    public BaseJsonVo saveRule(TagRuleEntity tagRuleEntity) {
        if (tagRuleEntity.getCreateTime() == null) {
            tagRuleEntity.setCreateTime(DateUtils.now());
        }
        return BaseJsonVo.success((Object)this.tagRuleService.insertOrUpdate((Object)tagRuleEntity));
    }

    @RequestMapping(value={"deletRule"})
    public BaseJsonVo deletRule(Integer id) {
        return BaseJsonVo.success((Object)this.tagRuleService.deleteByPrimaryKey((Serializable)id));
    }

    @RequestMapping(value={"getLaunchCode"})
    public BaseJsonVo getLaunchCode(LaunchCode launchCode) {
        return this.corpTagService.getLaunchCode(launchCode);
    }

    @RequestMapping(value={"testQiWeiAccess"})
    public BaseJsonVo testQiWeiAccess(Integer tagId) {
        this.contactTagService.testMarkTag(tagId);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testMarkTag"})
    public BaseJsonVo testMarkTag(String customerId, Integer pageNum) {
        this.corpTagService.markTagNew(customerId, pageNum);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testYestodayMarkTag"})
    public BaseJsonVo testYestodayMarkTag(String tagId, String customerId) {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testCommunityPhoneTag"})
    public BaseJsonVo testCommunityPhoneTag(String userId, String externalUserID) {
        this.customerTagService.addUserTag(userId, externalUserID);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testGetUserList"})
    public BaseJsonVo getUserTag(String customerId, Integer pageNum) {
        this.corpTagService.getUserTag(customerId, pageNum);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testRemoveUserTag"})
    public BaseJsonVo testRemoveUserTag(String tagId, String customerId, Integer pageNum) {
        this.corpTagService.removeTag(tagId, customerId, pageNum);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testDailyOrder"})
    public BaseJsonVo testDailyOrder(String date) {
        Date execDate = DateUtils.StrToDate((String)(date + " 00:00:00"));
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testDailyOrder4User"})
    public BaseJsonVo testDailyOrder4User(String date) {
        Date execDate = DateUtils.StrToDate((String)(date + " 00:00:00"));
        HashMap<String, Object> orderItemMap = new HashMap<String, Object>();
        orderItemMap.put("createTime", DateUtils.now());
        orderItemMap.put("channelName", "\u5fae\u4fe1");
        orderItemMap.put("totalAmount", "120.2");
        orderItemMap.put("payAmount", "100.2");
        orderItemMap.put("province", "\u5317\u4eac");
        orderItemMap.put("customerId", "");
        orderItemMap.put("phone", "18518673993");
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"setBiTagsTest"})
    public BaseJsonVo setBiTagsTest(String customerId) {
        return this.corpTagService.setBiTags(customerId);
    }
}

