/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.reunion;

import cc.lechun.apiinvoke.mall.ActiveReunionApiInvoke;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.reunion.OrderCoveryImportVo;
import cc.lechun.mall.entity.reunion.ReunionProductEntity;
import cc.lechun.mall.entity.reunion.ReunionSiteEntity;
import cc.lechun.mall.entity.reunion.ReunionStockEntity;
import cc.lechun.mall.entity.reunion.ReunionStockVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.reunion.ReunionActivePropertyInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionSiteInterface;
import cc.lechun.mall.iservice.reunion.ReunionStockInterface;
import cc.lechun.mall.service.reunion.OrderRecoveryUploadListener;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"reunion"})
public class ReunionController
extends BaseController {
    @Autowired
    ReunionProductInterface reunionProductInterface;
    @Autowired
    private ReunionSiteInterface reunionSiteInterface;
    @Autowired
    private ReunionOrderInterface reunionOrderInterface;
    @Autowired
    ReunionActivePropertyInterface reunionActivePropertyInterface;
    @Autowired
    ReunionStockInterface reunionStockInterface;
    @Autowired
    ActiveReunionApiInvoke activeReunionApiInvoke;

    @RequestMapping(value={"getReunionProductStockList"})
    public BaseJsonVo getReunionProductStockList() {
        return BaseJsonVo.success((Object)this.reunionActivePropertyInterface.getReunionActivePropertyList(""));
    }

    @RequestMapping(value={"getReunionActivePropertyList"})
    public BaseJsonVo getReunionActivePropertyList(String bindCode) {
        return BaseJsonVo.success((Object)this.reunionActivePropertyInterface.getReunionActivePropertyList(bindCode));
    }

    @RequestMapping(value={"productList"})
    public PageInfo productList(PageForm pageForm, String bindCode) {
        return this.reunionProductInterface.productList(bindCode, pageForm);
    }

    @RequestMapping(value={"saveProdcts"})
    public BaseJsonVo saveProdcts(ReunionProductEntity entity) {
        this.log.info(JsonUtils.toJson((Object)entity, (boolean)false));
        if (entity == null) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u6ca1\u6709\u53c2\u6570");
        }
        if (StringUtils.isEmpty((String)entity.getBindCode())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8");
        }
        if (StringUtils.isEmpty((String)entity.getProductId())) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        return this.reunionProductInterface.saveProdcts(entity);
    }

    @RequestMapping(value={"deleteProduct"})
    public BaseJsonVo deleteProdct(Integer id) {
        return this.reunionProductInterface.deleteProdct(id);
    }

    @RequestMapping(value={"copyProdcts"})
    public BaseJsonVo copyProdcts(String bindCode, String copyFromBindCode) {
        if (StringUtils.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6d3b\u52a8");
        }
        if (StringUtils.isEmpty((String)copyFromBindCode)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u54ea\u4e2a\u6d3b\u52a8");
        }
        return this.reunionProductInterface.copyProdcts(bindCode, copyFromBindCode);
    }

    @RequestMapping(value={"saveReunionSite"})
    public BaseJsonVo saveReunionSite(ReunionSiteEntity entity, BindingResult result) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (entity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u9519\u8bef");
        }
        if (entity.getCreateTime() == null) {
            entity.setCreateTime(new Date());
        }
        return this.reunionSiteInterface.saveReunionSite(entity);
    }

    @RequestMapping(value={"getReunionSiteEntity"})
    public BaseJsonVo getReunionSiteEntity(Integer siteId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (siteId == null) {
            return BaseJsonVo.error((String)"siteId\u9519\u8bef");
        }
        return BaseJsonVo.success((Object)this.reunionSiteInterface.getReunionSiteEntity(siteId));
    }

    @RequestMapping(value={"getReunionSiteList"})
    public BaseJsonVo getReunionSiteList(Integer currentPage, Integer pageSize, String siteName) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.reunionSiteInterface.getReunionSiteList(currentPage, pageSize, siteName));
    }

    @RequestMapping(value={"deleteReunionSite"})
    public BaseJsonVo deleteReunionSite(Integer siteId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (siteId == null) {
            return BaseJsonVo.error((String)"siteId\u9519\u8bef");
        }
        return this.reunionSiteInterface.deleteReunionSite(siteId);
    }

    @RequestMapping(value={"getVerificationReunionOrderList"})
    public BaseJsonVo getVerificationReunionOrderList(String bindcode, Integer pageNum, Integer pageSize, Integer orderId, String mobile, Integer orderStatus, String createDate) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.reunionOrderInterface.getVerificationReunionOrderList(pageNum, pageSize, orderId, orderStatus, mobile, user.getUserName(), StringUtils.isEmpty((String)createDate) ? null : DateUtils.getDateFromString((String)createDate, (String)"yyyy-MM-dd"), bindcode));
    }

    @RequestMapping(value={"cancelReunionOrder"})
    public BaseJsonVo cancelReunionOrder(Integer orderId) throws AuthorizeException {
        return this.reunionOrderInterface.cancelReunionOrder(orderId);
    }

    @RequestMapping(value={"importOrderRecovery"})
    public BaseJsonVo importOrderRecovery() throws AuthorizeException {
        return this.reunionOrderInterface.importOrderRecovery();
    }

    @RequestMapping(value={"VerificationReunionOrder"})
    public BaseJsonVo VerificationReunionOrder(Integer orderId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.reunionOrderInterface.VerificationReunionOrder(orderId, user.getUserId());
    }

    @RequestMapping(value={"saveStock"})
    public BaseJsonVo saveStock(ReunionStockVo stock, BindingResult result) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.reunionStockInterface.saveStock(stock);
    }

    @RequestMapping(value={"getStockList"})
    public BaseJsonVo getStockList(Integer pageNum, Integer pageSize, String bindCode) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        ReunionStockEntity stockEntity = new ReunionStockEntity();
        stockEntity.setBindCode(bindCode);
        return BaseJsonVo.success((Object)this.reunionStockInterface.getStockList(pageNum, pageSize, stockEntity));
    }

    @RequestMapping(value={"importOrderRecoverProducts"}, method={RequestMethod.POST})
    public BaseJsonVo importOrderRecoverProducts(@RequestParam(value="file") MultipartFile file) throws AuthorizeException {
        try {
            if (file.isEmpty()) {
                return BaseJsonVo.error((String)"\u6587\u4ef6\u4e3a\u7a7a");
            }
            EasyExcel.read((InputStream)file.getInputStream(), OrderCoveryImportVo.class, (ReadListener)new OrderRecoveryUploadListener(this.activeReunionApiInvoke)).sheet().doRead();
            return BaseJsonVo.success((Object)"\u6b63\u5728\u6279\u91cf\u5bfc\u5165\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u5728\u5217\u8868\u4e2d\u67e5\u770b");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.error((String)"\u5bfc\u5165\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
    }

    @RequestMapping(value={"modifyReunionOrderArriveTime"})
    public BaseJsonVo modifyReunionOrderArriveTime(Integer orderId, String selectTime) {
        if (orderId == null || StringUtils.isEmpty((String)selectTime)) {
            return BaseJsonVo.error((String)"\u8bf7\u8f93\u5165\u65f6\u95f4");
        }
        return this.reunionOrderInterface.modifyReunionOrderArriveTime(orderId, selectTime);
    }
}

