/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallFullCutNumberVo;
import cc.lechun.mall.entity.sales.MallFullcutDetailEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntity;
import cc.lechun.mall.entity.sales.MallFullcutEntityForm;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.check.OnlineCheckInterface;
import cc.lechun.mall.iservice.sales.MallFullcutDetailInterface;
import cc.lechun.mall.iservice.sales.MallFullcutInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fullcut"})
public class MallFullcatController
extends BaseController {
    @Autowired
    private MallFullcutInterface mallFullcutInterface;
    @Autowired
    private MallFullcutDetailInterface mallFullcutDetailInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallGroupInterface mallGroupInterface;
    @Autowired
    private OnlineCheckInterface onlineCheckInterface;

    @RequestMapping(value={"getProductList"})
    public BaseJsonVo getProductList() throws AuthorizeException {
        List ps = this.mallProductInterface.getAllProductList(this.getUser().getPlatformGroupId());
        return BaseJsonVo.success((Object)ps);
    }

    @RequestMapping(value={"getGroupList"})
    public BaseJsonVo getGroupList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallGroupInterface.getOptionGroupList(this.getUser().getPlatformGroupId()));
    }

    @RequestMapping(value={"getActiveList"})
    public BaseJsonVo getActiveList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.activeInterface.getActiveList4ActiveType(this.getUser().getPlatformGroupId().intValue(), 11));
    }

    @RequestMapping(value={"getFullCutList"})
    public BaseJsonVo getFullCutList(PageForm pageForm, String fullCutName, Integer fullClass, Integer status) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.onlineCheckInterface.check(this.mallFullcutInterface.getFullCutList(pageForm.getCurrentPage(), pageForm.getPageSize(), this.getUser().getPlatformGroupId().intValue(), fullCutName, fullClass, status)));
    }

    @RequestMapping(value={"getFullCutEntity"})
    public BaseJsonVo getFullCutEntity(String fullcutId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallFullcutInterface.getFullCutEntity(fullcutId));
    }

    @RequestMapping(value={"saveOrUpdateFullCutList"})
    public BaseJsonVo saveOrUpdateFullCutList(@RequestBody MallFullcutEntityForm mallFullcutEntity) throws AuthorizeException {
        MallUserEntity userEntity = this.getUser();
        if (userEntity.getPlatformGroupId() == 0) {
            return BaseJsonVo.success((Object)"\u7528\u6237\u65e0\u6743\u9650\uff0c\u8bf7\u66f4\u6362\u5bf9\u5e94\u516c\u53f8\u8d26\u53f7");
        }
        mallFullcutEntity.setPlatformGroupId(userEntity.getPlatformGroupId());
        if (mallFullcutEntity.getType() == 1 || mallFullcutEntity.getType() == 2) {
            if (mallFullcutEntity.getFullCutNumbersForm() == null || mallFullcutEntity.getFullCutNumbersForm().size() == 0) {
                return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u6ee1\u51cf\u540e\u70b9\u6dfb\u52a0\u6309\u94ae\u6dfb\u52a0\u5230\u6ee1\u51cf\u6761\u4ef6\u4e2d");
            }
            mallFullcutEntity.setFullCutNumbers(JsonUtils.toJson((Object)mallFullcutEntity.getFullCutNumbersForm(), (boolean)false));
            Optional optionalFullcutEntity = mallFullcutEntity.getFullCutNumbersForm().stream().sorted((t1, t2) -> t1.getFullNumber().compareTo(t2.getFullNumber())).findFirst();
            if (optionalFullcutEntity.isPresent()) {
                mallFullcutEntity.setFullNumber(((MallFullCutNumberVo)optionalFullcutEntity.get()).getFullNumber());
                mallFullcutEntity.setCutNumber(((MallFullCutNumberVo)optionalFullcutEntity.get()).getCutNumber());
            }
        }
        if (mallFullcutEntity.getProductIdsForm() == null || mallFullcutEntity.getProductIdsForm().size() == 0) {
            mallFullcutEntity.setProductIds(null);
            mallFullcutEntity.setProductNames(null);
        } else {
            mallFullcutEntity.setProductIds(String.join((CharSequence)",", mallFullcutEntity.getProductIdsForm()));
            ArrayList l = new ArrayList();
            mallFullcutEntity.getProductIdsForm().forEach(s -> l.add(this.mallProductInterface.getProduct(s).getProName()));
            mallFullcutEntity.setProductNames(String.join((CharSequence)",", l));
        }
        return this.mallFullcutInterface.saveOrUpdateFullCutList((MallFullcutEntity)mallFullcutEntity);
    }

    @RequestMapping(value={"getFullCutDetailList"})
    public BaseJsonVo getFullCutDetailList(PageForm pageForm, String fullcutId) {
        return BaseJsonVo.success((Object)this.mallFullcutDetailInterface.getFullCutDetailList(pageForm.getCurrentPage(), pageForm.getPageSize(), fullcutId));
    }

    @RequestMapping(value={"saveMallFullcutDetail"})
    public BaseJsonVo saveMallFullcutDetail(@RequestBody HashMap map) throws AuthorizeException {
        String fullCutId = map.get("fullCutId").toString();
        List productId = (List)map.get("productId");
        List groupId = (List)map.get("groupId");
        if (StringUtils.isEmpty((String)fullCutId)) {
            return BaseJsonVo.paramError((String)"\u5931\u8d25");
        }
        MallFullcutEntity fullcutEntity = this.mallFullcutInterface.getFullCutEntity(fullCutId);
        if (fullcutEntity == null) {
            return BaseJsonVo.error((String)"\u6ee1\u51cf\u4e0d\u5b58\u5728");
        }
        if (fullcutEntity.getCutRule() == 4 && groupId.size() > 0) {
            return BaseJsonVo.error((String)"\u5957\u88c5\u4e0d\u652f\u6301\u6309\u5546\u54c1\u51cf");
        }
        BaseJsonVo baseJsonVo = this.mallFullcutDetailInterface.checkGroup(fullCutId);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        if (productId != null && productId.size() > 0) {
            productId.forEach(s -> {
                MallFullcutDetailEntity mallFullcutDetailEntity = new MallFullcutDetailEntity();
                mallFullcutDetailEntity.setProductId(s);
                mallFullcutDetailEntity.setFullCutId(fullCutId);
                mallFullcutDetailEntity.setGroupType(Integer.valueOf(4));
                this.mallFullcutDetailInterface.saveMallFullcutDetail(mallFullcutDetailEntity);
            });
        }
        this.log.info("groupId:" + groupId.toString());
        if (groupId != null && groupId.size() > 0) {
            groupId.forEach(s -> {
                MallFullcutDetailEntity mallFullcutDetailEntity = new MallFullcutDetailEntity();
                mallFullcutDetailEntity.setGroupId(s);
                mallFullcutDetailEntity.setFullCutId(fullCutId);
                mallFullcutDetailEntity.setGroupType(Integer.valueOf(2));
                BaseJsonVo vo = this.mallFullcutDetailInterface.saveMallFullcutDetail(mallFullcutDetailEntity);
                if (!vo.isSuccess()) {
                    this.log.error(vo.getError_msg());
                }
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"deleteMallFullcutDetail"})
    public BaseJsonVo deleteMallFullcutDetail(String fullCutDetailId) throws AuthorizeException {
        return this.mallFullcutDetailInterface.deleteMallFullcutDetail(fullCutDetailId);
    }

    @RequestMapping(value={"addFullCutAllColdProducts"})
    public BaseJsonVo addFullCutAllColdProducts(String fullCutId) {
        return this.mallFullcutInterface.addFullCutAllColdProducts(fullCutId, 1);
    }

    @RequestMapping(value={"addFullCutAllNomalProducts"})
    public BaseJsonVo addFullCutAllNomalProducts(String fullCutId) {
        return this.mallFullcutInterface.addFullCutAllColdProducts(fullCutId, 2);
    }

    @RequestMapping(value={"delFullCutAllProducts"})
    public BaseJsonVo delFullCutAllProducts(String fullCutId) {
        return this.mallFullcutInterface.delFullCutAllProducts(fullCutId);
    }
}

