/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.form.sales.ItemProductVo;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/proItem"})
public class MallProductItemController
extends BaseController {
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private MallProductInterface productInterface;

    @RequestMapping(value={"/getItem"})
    @ResponseBody
    public BaseJsonVo getItem(String itemId, Integer itemType) throws AuthorizeException {
        if (Objects.equals(itemType, SalesTypeEnum.SALES_PRODUCT.getValue())) {
            MallProductEntity promotionEntity = this.productInterface.getProduct(itemId);
            ItemProductVo itemProductVo = new ItemProductVo();
            itemProductVo.setItemId(itemId);
            itemProductVo.setItemName(promotionEntity.getProName());
            itemProductVo.setItemType(itemType);
            itemProductVo.setItemTypeName(SalesTypeEnum.SALES_PRODUCT.getName());
            return BaseJsonVo.success((Object)itemProductVo);
        }
        if (Objects.equals(itemType, SalesTypeEnum.SALES_PROMOTION.getValue())) {
            MallPromotionEntity promotionEntity = this.promotionInterface.getPromotion(itemId);
            ItemProductVo itemProductVo = new ItemProductVo();
            itemProductVo.setItemId(itemId);
            itemProductVo.setItemName(promotionEntity.getPromotionName());
            itemProductVo.setItemType(itemType);
            itemProductVo.setItemTypeName(SalesTypeEnum.SALES_PROMOTION.getName());
            return BaseJsonVo.success((Object)itemProductVo);
        }
        return BaseJsonVo.error((String)"");
    }
}

