/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/productpic"})
public class MallProductPicController
extends BaseController {
    @Autowired
    private MallProductPicInterface picService;

    @RequestMapping(value={"getProductPics"})
    public BaseJsonVo getProductPics(Integer picType, String proId) {
        if (StringUtils.isEmpty((CharSequence)proId) && picType == null) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        List pics = this.picService.getProductPics(proId, picType);
        return BaseJsonVo.success((Object)pics);
    }

    @RequestMapping(value={"addProductPic"})
    public BaseJsonVo addProductPic(MallProductPicEntity pic) {
        pic.setGroupType(pic.getPicType());
        pic.setPicType(Integer.valueOf(pic.getPicType() % 10));
        this.picService.save(pic);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"addProductPicByBatch"})
    public BaseJsonVo addProductPicByBatch(String picListJson) {
        this.log.info("*******\u6279\u91cf\u4e0a\u4f20\u56fe\u7247***********picList={}", (Object)JSON.toJSONString((Object)picListJson));
        this.picService.saveBatch(picListJson);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"removeProductPic"})
    public BaseJsonVo removeProductPic(String picId) {
        this.picService.delete(picId);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"modifyProductPicSort"})
    public BaseJsonVo modifyProductPicSort(String picId, int sort, Integer picType, String proId) {
        Integer groupType = picType;
        this.log.info("*******MallProductPicController.modifyProductPicSort\u4fee\u6539\u56fe\u7247\u6392\u5e8f*********picId={},sort={},groupType={},proId={}", new Object[]{picId, sort, groupType, proId});
        this.picService.modifyProductPicSort(picId, sort, groupType, proId);
        List pics = this.picService.getProductPics(proId, groupType);
        return BaseJsonVo.success((Object)pics);
    }

    @RequestMapping(value={"clearProductPic"})
    public BaseJsonVo clearProductPic(Integer picType, String proId) {
        this.picService.clearProductPic(proId);
        List pics = this.picService.getProductPics(proId, picType);
        return BaseJsonVo.success((Object)pics);
    }
}

