/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.MallDeliverConfigDetailVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.EditPromotionVO;
import cc.lechun.mall.entity.sales.MallGroupProductEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigDetailInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/promotion"})
public class MallPromotionController
extends BaseController {
    @Autowired
    private MallPromotionProductInterface promotionProductService;
    @Autowired
    private MallPromotionBuyInterface promotionBuyService;
    @Autowired
    private MallPromotionTimeInterface promotionTimeService;
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallDeliverConfigDetailInterface configDetailInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    DistributorItemInterface distributorItemInterface;
    @Autowired
    MallGroupInterface groupInterface;
    @Autowired
    MallProductInterface productInterface;
    @Autowired
    DictionaryInterface dictionaryInterface;

    @RequestMapping(value={"setOnlineOrOffLine"})
    public BaseJsonVo setOnlineOrOffLine(String promotionId) throws AuthorizeException {
        BaseJsonVo js = this.promotionService.setOnlineOrOffLine(promotionId);
        if (js.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(promotionId, Integer.valueOf(1));
        }
        return js;
    }

    @RequestMapping(value={"promotionList"})
    public PageInfo promotionList(PageForm pageForm, MallPromotionEntity mallPromotionEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.promotionService.getPromotionList(pageForm.getCurrentPage(), pageForm.getPageSize(), mallPromotionEntity, user.getPlatformGroupId());
    }

    @RequestMapping(value={"getPromotion"})
    public BaseJsonVo getPromotion(String promotionId) throws AuthorizeException {
        Integer[] activeTypes = null;
        Object map = new HashedMap();
        List selectDataVos = this.activeInterface.getOptionActiveList(this.getUser().getPlatformGroupId(), activeTypes);
        if (StringUtils.isNotEmpty((String)promotionId)) {
            MallPromotionEntity entity = this.promotionService.getPromotion(promotionId);
            if (entity != null) {
                MallPromotionTimeEntity timeEntity = this.promotionTimeService.getSingleEntity(promotionId);
                map = ObjectConvert.objectConvertToObjectMap((Object)entity);
                if (timeEntity != null && timeEntity.getLimitCount() != null) {
                    map.put("limitCount", String.valueOf(timeEntity.getLimitCount()));
                } else {
                    map.put("limitCount", "0");
                }
                map.put("activeData", selectDataVos);
                return BaseJsonVo.success((Object)map);
            }
            return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        map.put("limitCount", "0");
        map.put("activeData", selectDataVos);
        return BaseJsonVo.success((Object)map);
    }

    @RequestMapping(value={"getPromotionDetail"})
    public BaseJsonVo getPromotionDetail(String promotionId) throws AuthorizeException {
        if (StringUtils.isEmpty((String)promotionId)) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        MallPromotionEntity promotion = this.promotionService.getPromotion(promotionId);
        MallPromotionProductEntity promotionProduct = this.promotionProductService.getPromotionProductEntity(promotionId);
        this.log.info("what:{}", (Object)JsonUtils.toJson((Object)promotionProduct, (boolean)false));
        ArrayList products = new ArrayList();
        if ("2".equals(promotionProduct.getProductType())) {
            List groupProductList = this.groupInterface.getGroupProductList(promotionProduct.getProductId());
            groupProductList.forEach(groupProduct -> {
                HashMap<String, Object> pro = new HashMap<String, Object>();
                MallProductEntity product = this.productInterface.getProduct(groupProduct.getProId());
                pro.put("proId", product.getProId());
                pro.put("barCode", product.getBarCode());
                pro.put("proCount", groupProduct.getProCount());
                pro.put("price", product.getProPrice());
                pro.put("originPrice", product.getProPrice1());
                products.add(pro);
            });
        } else if ("4".equals(promotionProduct.getProductType())) {
            HashMap<String, Object> pro = new HashMap<String, Object>();
            MallProductEntity product = this.productInterface.getProduct(promotionProduct.getProductId());
            pro.put("proId", product.getProId());
            pro.put("barCode", product.getBarCode());
            pro.put("proCount", 1);
            pro.put("price", product.getProPrice());
            pro.put("originPrice", StringUtils.isNotEmpty((String)product.getProPrice1()) ? product.getProPrice1() : product.getProPrice());
            products.add(pro);
        }
        Map map = ObjectConvert.objectConvertToObjectMap((Object)promotion);
        map.put("promotionProductId", promotionProduct.getPromotionProductId());
        map.put("promotionPrice", promotionProduct.getPromotionPrice());
        map.put("originPrice", promotionProduct.getOriginPrice());
        map.put("limitCount", promotionProduct.getLimitCount());
        map.put("isvip", promotionProduct.getIsvip());
        map.put("vipRightType", promotionProduct.getVipRightType());
        map.put("vipDayRight", promotionProduct.getVipDayRight());
        map.put("vipEverydayRight", promotionProduct.getVipEverydayRight());
        map.put("formProducts", products);
        String sign = MD5.sign((String)JsonUtils.toJson(products, (boolean)false));
        map.put("md5str", sign);
        this.log.info("old-str:{}", (Object)JsonUtils.toJson(products, (boolean)false));
        this.log.info("old-str:{}", (Object)sign);
        List selectDataVos = this.activeInterface.getOptionActiveList(this.getUser().getPlatformGroupId(), null);
        map.put("activeData", selectDataVos);
        DictionaryEntity search = new DictionaryEntity();
        search.setDictionaryName(promotionId);
        search.setDictionaryTypeId(Integer.valueOf(104));
        search.setStatus(Short.valueOf(Short.parseShort("1")));
        search = this.dictionaryInterface.getSingle(search);
        map.put("isFreeFreight", search != null ? "1" : "0");
        this.log.info("what2:{}", (Object)JsonUtils.toJson((Object)map, (boolean)false));
        return BaseJsonVo.success((Object)map);
    }

    @RequestMapping(value={"addPromotion"})
    @ResponseBody
    public BaseJsonVo addPromotion(MallPromotionEntity mallPromotionEntity, Integer limitCount) throws AuthorizeException {
        mallPromotionEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        BaseJsonVo sr = this.promotionService.addPromotion(mallPromotionEntity, limitCount.intValue());
        if (sr.isSuccess()) {
            MallPromotionEntity promotionEntity = (MallPromotionEntity)sr.getValue();
            if (promotionEntity != null) {
                this.distributorItemInterface.initDistributorItem(promotionEntity.getPromotionId(), Integer.valueOf(1));
            }
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"addPromotionDetail"})
    @ResponseBody
    public BaseJsonVo addPromotionDetail(String promotionStr, String md5Str) throws AuthorizeException, IOException {
        EditPromotionVO promotion = null;
        try {
            promotion = (EditPromotionVO)JsonUtils.fromJson((String)promotionStr, EditPromotionVO.class);
        }
        catch (Exception e) {
            this.log.error("Json", (Throwable)e);
            return BaseJsonVo.error((String)"\u5f02\u5e38");
        }
        if (promotion == null) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5f02\u5e38");
        }
        this.log.info("addPromotionDetail.EditPromotionVO:{}", (Object)JsonUtils.toJson((Object)promotion, (boolean)false));
        MallProductGroupEntity group = new MallProductGroupEntity();
        Integer[] proCountTotal = new Integer[]{0};
        promotion.getFormProducts().forEach(p -> {
            proCountTotal[0] = proCountTotal[0] + (Integer)p.get("proCount");
        });
        if (promotion.getPromotionPrice().doubleValue() <= 1.0 || promotion.getPromotionName().indexOf("\u79d2\u6740") >= 0) {
            if (promotion.getLimitCount() == null || promotion.getLimitCount() == 0) {
                return BaseJsonVo.error((String)"\u79d2\u6740\u5fc5\u987b\u8bbe\u7f6e\u9650\u91cf\u6570");
            }
            if (promotion.getUserLimitCount() == null || promotion.getUserLimitCount() == 0 || promotion.getUserLimitCount() > 1) {
                return BaseJsonVo.error((String)"\u79d2\u6740\u5fc5\u987b\u8bbe\u7f6e\u6bcf\u5355\u9650\u8d2d\u91cf,\u5e76\u4e14\u4e0d\u80fd\u5927\u4e8e5");
            }
        }
        if (proCountTotal[0] > 1) {
            String newSign = MD5.sign((String)JsonUtils.toJson((Object)promotion.getFormProducts(), (boolean)false));
            if (!newSign.equals(md5Str)) {
                group.setGroupName(promotion.getPromotionName() + "-\u5957\u88c5" + RandomUtils.generateNumString((int)6));
                group.setCreateTime(DateUtils.now());
                group.setSalePrice(promotion.getOriginPrice());
                group.setPrice(promotion.getOriginPrice());
                group.setSplitPriceMode(Integer.valueOf(0));
                group.setStatus(Integer.valueOf(1));
                group.setGroupUnit("\u5957");
                group.setLimitCount(Integer.valueOf(999999));
                group.setLimitBuyCount(Integer.valueOf(999999));
                group.setBalanceCount(Integer.valueOf(999999));
                group.setPlatformGroupId(this.getUser().getPlatformGroupId());
                this.log.info("addPromotionDetail.group:{}", (Object)JsonUtils.toJson((Object)group, (boolean)false));
                this.groupInterface.addGroup(group);
                promotion.getFormProducts().forEach(map -> {
                    MallGroupProductEntity groupProduct = new MallGroupProductEntity();
                    groupProduct.setGroupId(group.getGroupId());
                    groupProduct.setProId((String)map.get("proId"));
                    groupProduct.setProName(this.productInterface.getProduct((String)map.get("proId")).getProName());
                    groupProduct.setGroupName(group.getGroupName());
                    groupProduct.setProCount((Integer)map.get("proCount"));
                    groupProduct.setProPrice(new BigDecimal((String)map.get("price")));
                    this.log.info("addPromotionDetail.groupProduct:{}", (Object)JsonUtils.toJson((Object)groupProduct, (boolean)false));
                    this.groupInterface.addGroupProduct(groupProduct);
                });
            } else {
                MallPromotionProductEntity oldPromotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotion.getPromotionId());
                group.setGroupId(oldPromotionProduct.getProductId());
            }
        } else if (proCountTotal[0] == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5546\u54c1");
        }
        promotion.setPlatformGroupId(this.getUser().getPlatformGroupId());
        MallPromotionEntity promotionEntity1 = promotion.toPromotionEntity();
        this.log.info("addPromotionDetail.promotionEntity1:{}", (Object)JsonUtils.toJson((Object)promotionEntity1, (boolean)false));
        BaseJsonVo sr = this.promotionService.addPromotion(promotionEntity1, promotion.getLimitCount().intValue());
        if (sr.isSuccess()) {
            MallPromotionEntity promotionEntity = (MallPromotionEntity)sr.getValue();
            MallPromotionProductEntity promotionProduct = new MallPromotionProductEntity();
            promotionProduct.setPromotionProductId(StringUtils.isEmpty((String)promotion.getPromotionProductId()) ? IDGenerate.getUniqueIdStr() : promotion.getPromotionProductId());
            promotionProduct.setPromotionId(promotionEntity.getPromotionId());
            promotionProduct.setProductType(proCountTotal[0] > 1 ? "2" : "4");
            promotionProduct.setProductId(proCountTotal[0] > 1 ? group.getGroupId() : (String)((Map)promotion.getFormProducts().get(0)).get("proId"));
            promotionProduct.setPromotionPrice(promotion.getPromotionPrice());
            promotionProduct.setOriginPrice(promotion.getOriginPrice());
            promotionProduct.setLimitCount(promotion.getLimitCount());
            promotionProduct.setIsvip(promotion.getIsvip());
            promotionProduct.setVipDayRight(promotion.getVipDayRight());
            promotionProduct.setVipEverydayRight(promotion.getVipEverydayRight());
            promotion.setLimitCount(Integer.valueOf(99999));
            if (StringUtils.isEmpty((String)promotion.getPromotionProductId())) {
                this.log.info("addPromotionDetail.promotionProduct1:{}", (Object)JsonUtils.toJson((Object)promotionProduct, (boolean)false));
                this.promotionProductInterface.addPromotionProduct(promotionProduct);
            } else {
                this.log.info("addPromotionDetail.promotionProduct2:{}", (Object)JsonUtils.toJson((Object)promotionProduct, (boolean)false));
                this.promotionProductInterface.updatePromotionProduct(promotionProduct);
            }
            if (promotionEntity != null) {
                this.distributorItemInterface.initDistributorItem(promotionEntity.getPromotionId(), Integer.valueOf(1));
            }
            DictionaryEntity search = new DictionaryEntity();
            search.setDictionaryName(promotionEntity1.getPromotionId());
            search.setDictionaryTypeId(Integer.valueOf(104));
            search.setStatus(Short.valueOf(Short.parseShort("1")));
            search = this.dictionaryInterface.getSingle(search);
            if (Integer.valueOf("1").equals(promotion.getIsFreeFreight())) {
                if (search == null) {
                    this.dictionaryInterface.saveDictionary(promotionEntity1.getPlatformGroupId().intValue(), 104, promotionEntity1.getPromotionId(), promotionEntity1.getPromotionId(), 1, "\u4fc3\u9500\uff1a" + promotionEntity1.getPromotionName(), 1);
                } else {
                    this.dictionaryInterface.updateDictionary(search.getDictionaryId().intValue(), promotionEntity1.getPromotionId(), promotionEntity1.getPromotionId(), 1, "\u4fc3\u9500\uff1a" + promotionEntity1.getPromotionName(), 1);
                }
            } else if (search != null) {
                this.dictionaryInterface.deleteDictionary(search.getDictionaryId().intValue(), promotionEntity1.getPlatformGroupId().intValue());
            }
            return BaseJsonVo.success((Object)promotionEntity1.getPromotionId());
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"changePromotion"})
    public BaseJsonVo changePromotion(String promotionId) {
        if (this.prepayCardBatchInterface.promotionIsUsed(promotionId).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.changePromotion(promotionId);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(promotionId, Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delPromotion"})
    public BaseJsonVo delPromotion(MallPromotionEntity mallPromotionEntity) {
        if (this.prepayCardBatchInterface.promotionIsUsed(mallPromotionEntity.getPromotionId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.delPromotion(mallPromotionEntity.getPromotionId());
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallPromotionEntity.getPromotionId(), Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"clearPromotionBuy"})
    public BaseJsonVo clearPromotionBuy(String promotionId) {
        BaseJsonVo sr = this.promotionBuyService.clearPromotionBuy(promotionId);
        if (sr.isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getPromotionProduct"})
    public BaseJsonVo getPromotionProduct(String promotionId) {
        this.promotionProductService.removeCache(promotionId);
        MallPromotionProductEntity promotionProduct = this.promotionProductService.getPromotionProductEntity(promotionId);
        if (promotionProduct != null) {
            return BaseJsonVo.success((Object)promotionProduct);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"addPromotionProduct"})
    @ResponseBody
    public BaseJsonVo addPromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        MallPromotionProductEntity promotionProduct;
        if (mallPromotionProductEntity != null && StringUtils.isNotEmpty((String)mallPromotionProductEntity.getPromotionProductId()) && (promotionProduct = this.promotionProductInterface.getPromotionProduct(mallPromotionProductEntity.getPromotionProductId())).getPromotionPrice().compareTo(mallPromotionProductEntity.getPromotionPrice()) != 0 && this.prepayCardBatchInterface.promotionIsUsed(mallPromotionProductEntity.getPromotionId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u8be5\u4fc3\u9500\u5df2\u88ab\u6c34\u725b\u5976\u5361\u5173\u8054\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BaseJsonVo sr = this.promotionService.addPromotionProduct(mallPromotionProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallPromotionProductEntity.getPromotionId(), Integer.valueOf(1));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getDeliverConfig"})
    public BaseJsonVo getDeliverConfig(String promotionId) {
        List configDetailVos = this.configDetailInterface.getDeliverConfig(promotionId);
        int transportType = this.promotionProductService.getTransportType(promotionId);
        return BaseJsonVo.success((Object)configDetailVos);
    }

    @RequestMapping(value={"saveDeliverConfig"})
    public BaseJsonVo saveDeliverConfig(MallDeliverConfigDetailVo detailVo) throws AuthorizeException {
        return this.configDetailInterface.saveDeliverConfig(detailVo, this.getUser().getUserId());
    }

    @RequestMapping(value={"getPromotionTransportType"})
    public BaseJsonVo getTransportType(String promotionId) {
        int transportType = this.promotionProductService.getTransportType(promotionId);
        return BaseJsonVo.success((Object)transportType);
    }

    @RequestMapping(value={"getPromotionOrder"})
    public BaseJsonVo getPromotionOrder(String promotionId, String start, String end) {
        return BaseJsonVo.success((Object)this.promotionService.getPromotionOrder(promotionId, start, end));
    }

    @RequestMapping(value={"getActivePromotions"})
    public BaseJsonVo getActivePromotions(String bindCode) {
        return BaseJsonVo.success((Object)this.promotionService.getActivePromotions(bindCode));
    }

    @RequestMapping(value={"getActivePromotionsByActiveType"})
    public BaseJsonVo getActivePromotionsByActiveType(Integer activeType) {
        return BaseJsonVo.success((Object)this.promotionService.getActivePromotionsByActiveType(activeType));
    }
}

