/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.calendar.CalendarEntity;
import cc.lechun.scrm.iservice.calendar.CalendarInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrmCalendar"})
public class CalendarController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CalendarInterface calendarInterface;

    @RequestMapping(value={"builderCalendar"})
    public BaseJsonVo builderCalendar(Integer year, String weekend) {
        return this.calendarInterface.builderCalendar(year, weekend);
    }

    @RequestMapping(value={"getNextWorkDay"})
    public BaseJsonVo getNextWorkDay(String date, String qyWeixinUserId) {
        return BaseJsonVo.success((Object)this.calendarInterface.getNextWorkDay(DateUtils.StrToDate((String)date), qyWeixinUserId));
    }

    @RequestMapping(value={"saveEdit"})
    public BaseJsonVo saveEdit(CalendarEntity ca) {
        return this.calendarInterface.saveEdit(ca);
    }

    @RequestMapping(value={"getPageList"})
    public BaseJsonVo getPageList(Integer currentPage, Integer pageSize, CalendarEntity ca) {
        return BaseJsonVo.success((Object)this.calendarInterface.getPageList(currentPage.intValue(), pageSize.intValue(), (Object)ca));
    }

    @RequestMapping(value={"getQwUser"})
    public BaseJsonVo getQwUser() {
        return this.calendarInterface.getQwUser();
    }
}

