/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.active.vo.QueryVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.echelon.EchelonDetailedEntity;
import cc.lechun.scrm.entity.echelon.EchelonEntity;
import cc.lechun.scrm.entity.echelon.EchelonPeriodEntity;
import cc.lechun.scrm.entity.echelon.EchelonQueryVo;
import cc.lechun.scrm.iservice.echelon.ComputeAward;
import cc.lechun.scrm.iservice.echelon.EchelonDetailedInterface;
import cc.lechun.scrm.iservice.echelon.EchelonInterface;
import cc.lechun.scrm.iservice.echelon.EchelonPeriodInterface;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"echelon"})
public class EchelonController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ComputeAward computeAward;
    @Autowired
    EchelonPeriodInterface echelonPeriodInterface;
    @Autowired
    EchelonDetailedInterface echelonDetailedInterface;
    @Autowired
    EchelonInterface echelonInterface;

    @RequestMapping(value={"getDaily"})
    public BaseJsonVo getDaily(Integer currentPage, Integer pageSize, String start, String end, String qyWeixinUserid) {
        return BaseJsonVo.success((Object)this.computeAward.getGmv4Daily(currentPage, pageSize, start, end, qyWeixinUserid));
    }

    @RequestMapping(value={"getMonth"})
    public BaseJsonVo getMonth(EchelonQueryVo echelonQueryVo) {
        return BaseJsonVo.success((Object)this.computeAward.getMonth(echelonQueryVo));
    }

    @RequestMapping(value={"getEchelonMonth"})
    public BaseJsonVo getEchelonMonth(EchelonQueryVo echelonQueryVo) {
        return BaseJsonVo.success((Object)this.computeAward.getMonth(echelonQueryVo));
    }

    @RequestMapping(value={"initSeasonPeriod"})
    public BaseJsonVo initSeasonPeriod(Integer year, Integer month, boolean first) {
        this.echelonPeriodInterface.initSeasonPeriod(year, month, first);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"intiMonthPeriod"})
    public BaseJsonVo intiMonthPeriod(Integer year, Integer month, boolean first) {
        this.echelonPeriodInterface.intiMonthPeriod(year, month, first);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"setMaster"})
    public BaseJsonVo setMaster(Integer echelonDetailedId, String masterQyWeixinUserid) {
        return this.echelonDetailedInterface.setMaster(echelonDetailedId, masterQyWeixinUserid);
    }

    @RequestMapping(value={"saveEchelonDetailed"})
    public BaseJsonVo saveEchelonDetailed(EchelonDetailedEntity echelonDetailedEntity) {
        return this.echelonDetailedInterface.saveEchelonDetailed(echelonDetailedEntity);
    }

    @RequestMapping(value={"getDataList"})
    public BaseJsonVo getDataList(EchelonQueryVo echelonQueryVo) {
        return BaseJsonVo.success((Object)this.echelonInterface.getDataList(echelonQueryVo));
    }

    @RequestMapping(value={"getEchelon"})
    public BaseJsonVo getEchelon(EchelonEntity echelonEntity) {
        return BaseJsonVo.success((Object)this.echelonInterface.getSingle((Object)echelonEntity, 0L));
    }

    @RequestMapping(value={"initEchelon"})
    public BaseJsonVo initEchelon() {
        this.echelonInterface.initEchelon();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getPeriodList"})
    public BaseJsonVo getPeriodList(QueryVo queryVo) {
        return BaseJsonVo.success((Object)this.echelonPeriodInterface.getPageList(queryVo.getCurrentPage().intValue(), queryVo.getPageSize().intValue(), (Object)new EchelonPeriodEntity()));
    }

    @RequestMapping(value={"getEchelonMemberList"})
    public BaseJsonVo getEchelonMemberList(Integer echelonId) {
        return this.echelonDetailedInterface.getEchelonMemberList(echelonId);
    }

    @RequestMapping(value={"computeAwardByMonth"})
    public BaseJsonVo computeAwardByMonth(Integer echelonId) {
        EchelonEntity echelonEntity = (EchelonEntity)this.echelonInterface.selectByPrimaryKey((Serializable)echelonId);
        EchelonPeriodEntity echelonPeriodEntity = (EchelonPeriodEntity)this.echelonPeriodInterface.selectByPrimaryKey((Serializable)echelonEntity.getPeriodId());
        this.computeAward.computeAwardByMonth(echelonEntity, echelonPeriodEntity);
        return BaseJsonVo.success((Object)"");
    }
}

