/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.event.EventEntity;
import cc.lechun.scrm.entity.event.EventGroupEntity;
import cc.lechun.scrm.entity.event.EventGroupQueryVo;
import cc.lechun.scrm.entity.event.EventQuery;
import cc.lechun.scrm.entity.event.EventTypeEnum;
import cc.lechun.scrm.iservice.event.EventGroupInterface;
import cc.lechun.scrm.iservice.event.EventInterface;
import cc.lechun.scrm.iservice.scene.UserGroupInterface;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"event"})
public class EventController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    EventInterface eventInterface;
    @Autowired
    UserGroupInterface userGroupInterface;
    @Autowired
    private EventGroupInterface eventGroupInterface;

    @RequestMapping(value={"getEventList"})
    public BaseJsonVo getEventList(EventQuery eventQuery) {
        return BaseJsonVo.success((Object)this.eventInterface.getEventList(eventQuery));
    }

    @RequestMapping(value={"getEventTypeList"})
    public BaseJsonVo getEventTypeList() {
        return BaseJsonVo.success((Object)EventTypeEnum.getList());
    }

    @RequestMapping(value={"saveEvent"})
    public BaseJsonVo saveEvent(EventEntity eventEntity) {
        return this.eventInterface.saveEvent(eventEntity);
    }

    @RequestMapping(value={"getEvent"})
    public BaseJsonVo saveEvent(Integer eventId) {
        return BaseJsonVo.success((Object)this.eventInterface.selectByPrimaryKey((Serializable)eventId, 0L));
    }

    @RequestMapping(value={"changeEventStatus"})
    public BaseJsonVo changeEventStatus(EventEntity eventEntity) {
        return this.eventInterface.saveEvent(eventEntity);
    }

    @RequestMapping(value={"getEventGroupList"})
    public BaseJsonVo getEventGroupList(EventGroupQueryVo eventGroupQueryVo) {
        return BaseJsonVo.success((Object)this.eventGroupInterface.getEventGroupList(eventGroupQueryVo));
    }

    @RequestMapping(value={"saveEventGroup"})
    public BaseJsonVo getEventGroupList(EventGroupEntity eventGroupEntity) {
        return this.eventGroupInterface.saveEventGroup(eventGroupEntity);
    }

    @RequestMapping(value={"getEventCondtion"})
    public BaseJsonVo getEventCondtion() {
        return this.userGroupInterface.getUserGroupCondition();
    }
}

