/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.enums.common.StatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.scrm.entity.bonus.CaseStatusEnum;
import cc.lechun.scrm.entity.bonus.ExperienceEntity;
import cc.lechun.scrm.entity.bonus.ExperienceExportVo;
import cc.lechun.scrm.entity.bonus.ExperienceQueryVo;
import cc.lechun.scrm.entity.bonus.ExperienceTypeEnum;
import cc.lechun.scrm.entity.bonus.ExperienceVoteEntity;
import cc.lechun.scrm.iservice.bonus.ExperienceVoteInterface;
import cc.lechun.scrm.service.bonus.BonusServiceContext;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"experience"})
public class ExperienceController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    BonusServiceContext bonusServiceContext;
    @Autowired
    ExperienceVoteInterface experienceVoteService;

    @RequestMapping(value={"saveCase"})
    public BaseJsonVo saveCase(@RequestBody ExperienceEntity experienceEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (experienceEntity.getExperienceId() == null || experienceEntity.getExperienceId() == 0) {
            experienceEntity.setQwUserid(user.getUserId());
            experienceEntity.setQyWeixinUserid(user.getQyWeixinUserid());
            experienceEntity.setQwNickname(user.getUserNick());
            experienceEntity.setStatus(Integer.valueOf(StatusEnum.STATUS_OK.getValue()));
            experienceEntity.setCreateTime(DateUtils.now());
            experienceEntity.setCreateDate(DateUtils.currentDate());
            experienceEntity.setExperienceId(null);
        }
        if (StringUtils.isEmpty((String)experienceEntity.getExperienceContent())) {
            return BaseJsonVo.error((String)"\u6848\u4f8b\u5185\u5bb9\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return this.bonusServiceContext.saveExperience(experienceEntity);
    }

    @RequestMapping(value={"getCase"})
    public BaseJsonVo getCase(Integer experienceId, Integer operateType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.bonusServiceContext.getCase(experienceId, user.getUserId(), operateType));
    }

    @RequestMapping(value={"testGetCase"})
    public BaseJsonVo testGetCase(Integer experienceId, Integer operateType) {
        return BaseJsonVo.success((Object)this.bonusServiceContext.getCase(experienceId, "3039238394131487336", operateType));
    }

    @RequestMapping(value={"getExperienceList"})
    public BaseJsonVo getExperienceList(ExperienceQueryVo experienceQueryVo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getStart())) {
            experienceQueryVo.setStartDate(experienceQueryVo.getStart());
        }
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getEnd())) {
            experienceQueryVo.setEndDate(experienceQueryVo.getEnd());
        }
        if (StringUtils.isNotEmpty((String)user.getQyWeixinUserid())) {
            experienceQueryVo.setQyWeixinUserid(user.getQyWeixinUserid());
        }
        experienceQueryVo.setAuditing(Integer.valueOf(1));
        return BaseJsonVo.success((Object)this.bonusServiceContext.getExperienceList(experienceQueryVo, user.getUserId(), false));
    }

    @RequestMapping(value={"testgetExperienceList"})
    public BaseJsonVo testgetExperienceList(ExperienceQueryVo experienceQueryVo) throws AuthorizeException {
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getStart())) {
            experienceQueryVo.setStartDate(experienceQueryVo.getStart());
        }
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getEnd())) {
            experienceQueryVo.setEndDate(experienceQueryVo.getEnd());
        }
        return BaseJsonVo.success((Object)this.bonusServiceContext.getExperienceList(experienceQueryVo, "3082133806849985211", false));
    }

    @RequestMapping(value={"initGmv"})
    public BaseJsonVo initGmv(Integer day) throws AuthorizeException {
        this.bonusServiceContext.initGmv(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(-day.intValue())), Integer.valueOf(1));
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"exportCase"})
    public void exportCase(ExperienceQueryVo experienceQueryVo, HttpServletResponse response) throws AuthorizeException, IOException {
        MallUserEntity user = this.getUser();
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getStart())) {
            experienceQueryVo.setStartDate(experienceQueryVo.getStart());
        }
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getEnd())) {
            experienceQueryVo.setEndDate(experienceQueryVo.getEnd());
        }
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(DateUtils.date() + "\u7ecf\u9a8c\u6848\u4f8b", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), ExperienceExportVo.class).autoCloseStream(Boolean.FALSE).sheet("\u4f01\u5fae\u7ecf\u9a8c\u6848\u4f8b").doWrite(this.bonusServiceContext.getExperienceExportVoList(experienceQueryVo, user.getUserId()));
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"testexportCase"})
    public void testexportCase(ExperienceQueryVo experienceQueryVo, HttpServletResponse response) throws AuthorizeException, IOException {
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getStart())) {
            experienceQueryVo.setStartDate(experienceQueryVo.getStart());
        }
        if (StringUtils.isNotEmpty((String)experienceQueryVo.getEnd())) {
            experienceQueryVo.setEndDate(experienceQueryVo.getEnd());
        }
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(DateUtils.date() + "\u7ecf\u9a8c\u6848\u4f8b", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), ExperienceExportVo.class).autoCloseStream(Boolean.FALSE).sheet("\u4f01\u5fae\u7ecf\u9a8c\u6848\u4f8b").doWrite(this.bonusServiceContext.getExperienceExportVoList(experienceQueryVo, "3082133806849985211"));
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"getAuditingExperienceList"})
    public BaseJsonVo getAuditingExperienceList(ExperienceQueryVo experienceQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.bonusServiceContext.getExperienceList(experienceQueryVo));
    }

    @RequestMapping(value={"auditingCase"})
    public BaseJsonVo auditingCase(Integer experienceId, Integer operateType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (!Objects.equals(operateType, 1)) {
            return BaseJsonVo.error((String)"\u65e0\u6743\u64cd\u4f5c,\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        return this.bonusServiceContext.auditingExperience(experienceId, user.getUserId());
    }

    @RequestMapping(value={"/saveVote"})
    public BaseJsonVo saveVote(ExperienceVoteEntity experienceVoteEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        experienceVoteEntity.setVoteUserId(user.getUserId());
        List userEntityList = this.bonusServiceContext.getQiWeiUserList();
        if (!userEntityList.stream().anyMatch(u -> Objects.equals(u.getOrDefault("id", ""), user.getQyWeixinUserid()))) {
            this.log.error("\u6295\u7968\u7528\u6237:{} \u65e0\u6743\u9650", (Object)user.getUserName());
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6295\u7968\u6743\u9650");
        }
        return this.experienceVoteService.saveVote(experienceVoteEntity);
    }

    @RequestMapping(value={"/testsaveVote"})
    public BaseJsonVo testsaveVote(ExperienceVoteEntity experienceVoteEntity) throws AuthorizeException {
        experienceVoteEntity.setVoteUserId("3082133806849985211");
        List userEntityList = this.bonusServiceContext.getQiWeiUserList();
        if (!userEntityList.stream().anyMatch(u -> Objects.equals(u.getOrDefault("id", ""), "LangHua"))) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6295\u7968\u6743\u9650");
        }
        return this.experienceVoteService.saveVote(experienceVoteEntity);
    }

    @RequestMapping(value={"getCaseTypeList"})
    public BaseJsonVo getCaseTypeList() throws AuthorizeException {
        return BaseJsonVo.success((Object)ExperienceTypeEnum.getList());
    }

    @RequestMapping(value={"getCaseStatusList"})
    public BaseJsonVo getCaseStatusList() throws AuthorizeException {
        return BaseJsonVo.success((Object)CaseStatusEnum.getList());
    }
}

