/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.object.BeanUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.scrm.entity.group.SceneRouteGroupRefEntity;
import cc.lechun.scrm.entity.material.MaterialEntity;
import cc.lechun.scrm.entity.material.MaterialTextEntity;
import cc.lechun.scrm.entity.material.MaterialTraceEntity;
import cc.lechun.scrm.entity.material.MaterialVo;
import cc.lechun.scrm.entity.material.PushTypeEnum;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import cc.lechun.scrm.iservice.material.MaterialInterface;
import cc.lechun.scrm.iservice.material.MaterialLogInterface;
import cc.lechun.scrm.iservice.material.MaterialTraceInterface;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.util.JsonUtil;

@RestController
@RequestMapping(value={"scrmMaterial"})
public class MaterialController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SceneRouteGroupRefInterface sceneRouteGroupRefInterface;
    @Autowired
    MaterialInterface materialInterface;
    @Autowired
    MaterialTraceInterface materialTraceInterface;
    @Autowired
    SysUserInterface sysUserInterface;
    @Autowired
    MaterialLogInterface materialLogInterface;
    @Autowired
    DingdingUtils dingdingUtils;

    @RequestMapping(value={"saveTextMaterial"})
    public BaseJsonVo saveTextMaterial(@RequestBody MaterialVo materialVo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        MaterialEntity entity = new MaterialEntity();
        MaterialTextEntity txtEntity = new MaterialTextEntity();
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)materialVo.getPushText())) {
            materialVo.setPushText(materialVo.getPushText());
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)materialVo.getPushTextPre())) {
            materialVo.setPushTextPre(materialVo.getPushTextPre());
        }
        org.springframework.beans.BeanUtils.copyProperties((Object)materialVo, (Object)entity);
        org.springframework.beans.BeanUtils.copyProperties((Object)materialVo, (Object)txtEntity);
        if (Objects.equals(entity.getPushType(), PushTypeEnum.AUTO_PUSH.getValue()) && (txtEntity.getPushText().contains("${") || txtEntity.getPushTextPre().contains("${"))) {
            return BaseJsonVo.error((String)"\u81ea\u52a8\u63a8\u9001 \u4e0d\u80fd\u5305\u542b\u53d8\u91cf\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5");
        }
        if (Integer.valueOf(1).equals(materialVo.getCheckStatus())) {
            if (!this.sysUserInterface.valideRole(user.getUserId(), "\u7d20\u6750\u5ba1\u6838")) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u5ba1\u6838\u6743\u9650");
            }
            txtEntity.setCheckTime(new Date());
            txtEntity.setCheker(user.getUserName());
            txtEntity.setPushText(txtEntity.getPushTextPre());
            entity.setStatus(Integer.valueOf(1));
        }
        if (Integer.valueOf(2).equals(materialVo.getCheckStatus())) {
            if (!this.sysUserInterface.valideRole(user.getUserId(), "\u7d20\u6750\u5ba1\u6838")) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u5ba1\u6838\u6743\u9650");
            }
            txtEntity.setCheckTime(new Date());
            txtEntity.setCheker(user.getUserName());
            entity.setStatus(Integer.valueOf(3));
        }
        if (Integer.valueOf(0).equals(materialVo.getCheckStatus())) {
            if (StringUtils.isNotEmpty((String)materialVo.getPushTextPre()) && !materialVo.getPushTextPre().equals(materialVo.getPushText()) || entity.getId() == null) {
                entity.setStatus(Integer.valueOf(2));
            }
            txtEntity.setUpdateTime(new Date());
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)entity.getCreator())) {
            entity.setCreator(user.getUserId());
        }
        if (entity.getGroupId() != null && entity.getId() != null) {
            this.sceneRouteGroupRefInterface.removeGroup(null, entity.getId(), Integer.valueOf(3), user.getUserId());
            SceneRouteGroupRefEntity refEntity = new SceneRouteGroupRefEntity();
            refEntity.setGroupId(entity.getGroupId());
            refEntity.setSceneRoute(Integer.valueOf(3));
            refEntity.setSceneRouteId(entity.getId());
            refEntity.setCreater(user.getUserId());
            this.sceneRouteGroupRefInterface.saveGroupRef(refEntity);
        }
        entity.setMaterialName(entity.getMaterialCode());
        entity.setUpdateTime(new Date());
        this.log.info("entity:" + JsonUtil.toJSONString((Object)entity));
        Map map = BeanUtils.beanToMap((Object)txtEntity);
        map.put("recordLog", materialVo.getRecordLog());
        this.log.info("map:" + map);
        BaseJsonVo jsonVo = this.materialInterface.saveMaterial(entity, map);
        if (jsonVo.isSuccess() && Integer.valueOf(2).equals(entity.getStatus())) {
            this.dingdingUtils.sendOAMessage("03305417391844802807", "\u6709\u5f85\u5ba1\u6838\u7684SOP\u7d20\u6750", materialVo.getPushTextPre());
        }
        return jsonVo;
    }

    @RequestMapping(value={"getOptionMaterialList"})
    public BaseJsonVo getOptionMaterialList(Integer materialClass) throws AuthorizeException {
        if (materialClass == null) {
            materialClass = 1;
        }
        return this.materialInterface.getOptionList(materialClass);
    }

    @RequestMapping(value={"getMaterialWithType"})
    public BaseJsonVo getMaterialWithType(Integer id) throws AuthorizeException {
        if (id == null) {
            return BaseJsonVo.error((String)"Id\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.materialInterface.getMaterialWithType(id));
    }

    @RequestMapping(value={"deleteMaterial"})
    public BaseJsonVo deleteMaterial(Integer id) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (id == null) {
            return BaseJsonVo.error((String)"Id\u4e3a\u7a7a");
        }
        return this.materialInterface.deleteMaterial(id);
    }

    @RequestMapping(value={"materialPageList"})
    public BaseJsonVo materialPageList(Integer currentPage, Integer pageSize, MaterialEntity materialEntity) throws AuthorizeException {
        if (materialEntity == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)materialEntity.getMaterialName())) {
            materialEntity.setMaterialName(null);
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)materialEntity.getMaterialCode())) {
            materialEntity.setMaterialCode(null);
        }
        if (Integer.valueOf(-1).equals(materialEntity.getStatus())) {
            materialEntity.setStatus(null);
        }
        return this.materialInterface.getMaterialPageList(currentPage.intValue(), pageSize.intValue(), materialEntity, "seq,update_time desc,create_time desc");
    }

    @RequestMapping(value={"changeStatus"})
    public BaseJsonVo changeStatus(Integer materialId, Integer status) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.materialInterface.changeStatus(materialId, status);
    }

    @RequestMapping(value={"statistics"})
    public BaseJsonVo statistics(Date date) {
        this.materialInterface.statistics(date);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"statisticsMaterial"})
    public BaseJsonVo statisticsMaterial(Integer materialId) {
        MaterialEntity materialEntity = (MaterialEntity)this.materialInterface.selectByPrimaryKey((Serializable)materialId);
        this.materialInterface.statistics(materialEntity);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getHrefLongUrlChanId"})
    public BaseJsonVo getHrefLongUrlChanId(String pushText) {
        try {
            pushText = URLDecoder.decode(pushText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)this.materialInterface.getHrefLongUrlChanId(pushText));
    }

    @RequestMapping(value={"saveMaterialSort"})
    public BaseJsonVo saveMaterialSort(Integer materialId, Integer sort) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (materialId == null) {
            return BaseJsonVo.error((String)"\u7d20\u6750Id\u4e3a\u7a7a");
        }
        MaterialEntity material = new MaterialEntity();
        material.setId(materialId);
        material.setSeq(Integer.valueOf(sort == null ? 0 : sort));
        this.materialInterface.updateByPrimaryKeySelective((Object)material);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"saveMaterialTrace"})
    public BaseJsonVo saveMaterialTrace(@RequestBody List<MaterialTraceEntity> lst) throws AuthorizeException {
        if (lst == null || lst.size() == 0) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u6570\u636e\u4e3a\u7a7a");
        }
        return this.materialTraceInterface.saveMaterialTrace(lst);
    }

    @RequestMapping(value={"getMaterialTraceList"})
    public BaseJsonVo getMaterialTraceList(MaterialTraceEntity search) {
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)search.getContent())) {
            search.setContent(null);
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)search.getTag())) {
            search.setTag(null);
        }
        return BaseJsonVo.success((Object)this.materialTraceInterface.getMaterialTraceList(search));
    }

    @RequestMapping(value={"deleteMaterialTrace"})
    public BaseJsonVo deleteMaterialTrace(Integer traceId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (traceId == null) {
            return BaseJsonVo.error((String)"Id\u4e3a\u7a7a");
        }
        return this.materialTraceInterface.deleteMaterialTrace(traceId);
    }

    @RequestMapping(value={"getWaittingCheckMaterials"})
    public BaseJsonVo getWaittingCheckMaterials() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (!this.sysUserInterface.valideRole(user.getUserId(), "\u7d20\u6750\u5ba1\u6838")) {
            return BaseJsonVo.success(new ArrayList());
        }
        MaterialEntity search = new MaterialEntity();
        search.setStatus(Integer.valueOf(2));
        BaseJsonVo vo = this.materialInterface.getMaterialPageList(1, 500, search, "update_time desc");
        if (vo.isSuccess()) {
            return BaseJsonVo.success((Object)((PageInfo)vo.getValue()).getList());
        }
        return BaseJsonVo.success(new ArrayList());
    }

    @RequestMapping(value={"getMaterialLogList"})
    public BaseJsonVo getMaterialLogList(Integer materialId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (materialId == null) {
            return BaseJsonVo.error((String)"Id\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.materialLogInterface.getMaterialLogList(materialId));
    }

    @RequestMapping(value={"saveMaterialCode"})
    public BaseJsonVo saveMaterialCode(MaterialEntity scene) {
        return this.materialInterface.saveMaterialCode(scene);
    }
}

