/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.option.DicKeyTypeEnum;
import cc.lechun.scrm.entity.option.DicTypeEnum;
import cc.lechun.scrm.entity.option.DictionaryDetailEntity;
import cc.lechun.scrm.entity.option.OptionDictionaryEntity;
import cc.lechun.scrm.entity.option.OptionDictionaryItem;
import cc.lechun.scrm.iservice.option.DictionaryDetailInterface;
import cc.lechun.scrm.iservice.option.OptionDictionaryInterface;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrmOption"})
public class OptionController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OptionDictionaryInterface dictionaryInterface;
    @Autowired
    DictionaryDetailInterface dictionaryDetailInterface;

    @RequestMapping(value={"buildDictionary"})
    public BaseJsonVo buildDictionary(Integer eventPropertyId) {
        return this.dictionaryInterface.buildDictionary(eventPropertyId);
    }

    @RequestMapping(value={"getDicKeyTypeList"})
    public BaseJsonVo getDicKeyTypeList() {
        return BaseJsonVo.success((Object)DicKeyTypeEnum.getList());
    }

    @RequestMapping(value={"getDicTypeList"})
    public BaseJsonVo getDicTypeList() {
        return BaseJsonVo.success((Object)DicTypeEnum.getList());
    }

    @RequestMapping(value={"saveDic"})
    public BaseJsonVo saveDic(@RequestBody OptionDictionaryEntity optionDictionaryEntity) {
        return this.dictionaryInterface.save(optionDictionaryEntity);
    }

    @RequestMapping(value={"saveDicDetail"})
    public BaseJsonVo saveDicDetail(DictionaryDetailEntity dictionaryDetailEntity) {
        return this.dictionaryDetailInterface.save(dictionaryDetailEntity);
    }

    @RequestMapping(value={"getDicDetail"})
    public BaseJsonVo getDicDetail(Integer id) {
        return BaseJsonVo.success((Object)this.dictionaryDetailInterface.selectByPrimaryKey((Serializable)id, 0L));
    }

    @RequestMapping(value={"deleteDetail"})
    public BaseJsonVo deleteDetail(Integer id) {
        return this.dictionaryDetailInterface.deleteByPrimaryKey((Serializable)id) > 0 ? BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f") : BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"getDic"})
    public BaseJsonVo getDic(Integer id) {
        OptionDictionaryEntity optionDictionaryEntity = (OptionDictionaryEntity)this.dictionaryInterface.selectByPrimaryKey((Serializable)id, 0L);
        if (optionDictionaryEntity != null) {
            OptionDictionaryItem optionDictionaryItem = new OptionDictionaryItem();
            BeanUtils.copyProperties((Object)optionDictionaryEntity, (Object)optionDictionaryItem);
            optionDictionaryItem.setDicKeyTypeName(DicKeyTypeEnum.getName((Integer)optionDictionaryEntity.getDicKeyType()));
            optionDictionaryItem.setDicTypeName(DicTypeEnum.getName((Integer)optionDictionaryEntity.getDicType()));
            DictionaryDetailEntity queryVo = new DictionaryDetailEntity();
            queryVo.setDicId(id);
            optionDictionaryItem.setDicOptionList(this.dictionaryDetailInterface.getList((Object)queryVo, 0L));
            return BaseJsonVo.success((Object)optionDictionaryItem);
        }
        OptionDictionaryItem optionDictionaryItem = new OptionDictionaryItem();
        optionDictionaryItem.setId(id);
        return BaseJsonVo.success((Object)optionDictionaryItem);
    }
}

