/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.user.MallUserInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.scrm.entity.route.RouteEntity;
import cc.lechun.scrm.entity.route.RouteEntityVo;
import cc.lechun.scrm.entity.route.RouteLinkEntity;
import cc.lechun.scrm.iservice.route.RouteCustomerInterface;
import cc.lechun.scrm.iservice.route.RouteInterface;
import cc.lechun.scrm.iservice.route.RouteLinkInterface;
import cc.lechun.scrm.iservice.run.RunRecordInterface;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import weixin.popular.api.qy.WxApiUtils;
import weixin.popular.bean.qy.appMessage.MessageResult;

@RestController
@RequestMapping(value={"scrmRoute"})
public class RouteController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RouteCustomerInterface routeCustomerInterface;
    @Autowired
    RouteInterface routeInterface;
    @Autowired
    RouteLinkInterface routeLinkInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private RunRecordInterface runRecordInterface;
    @Autowired
    private MallUserInterface mallUserInterface;

    @RequestMapping(value={"getQwServiceList"})
    public BaseJsonVo getQwServiceList(String searchText, Integer currentPage, Integer pageSize, Integer routeId, String qwUserId, String createDate, Integer all, Integer status, Integer groupId, Integer pushType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)qwUserId)) {
            qwUserId = user.getUserId();
        } else {
            MallUserEntity search = new MallUserEntity();
            search.setQyWeixinUserid(qwUserId);
            search = (MallUserEntity)this.mallUserInterface.getSingle((Object)search);
            qwUserId = search != null ? search.getUserId() : null;
            all = 0;
        }
        if (Integer.valueOf("1").equals(all)) {
            qwUserId = null;
        }
        return this.routeCustomerInterface.getQwServiceList(searchText, currentPage, pageSize, routeId, qwUserId, createDate, null, status, groupId, pushType);
    }

    @RequestMapping(value={"getQwServiceSop"})
    public BaseJsonVo getQwServiceSop(String customerId, String date) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)date)) {
            date = DateUtils.now((String)"yyyy-MM-dd");
        }
        BaseJsonVo jsonVo = this.routeCustomerInterface.getQwServiceList("", Integer.valueOf(1), Integer.valueOf(50), null, null, date, customerId, null, null);
        List lst = new LinkedList();
        if (jsonVo.isSuccess()) {
            PageInfo pageInfo = (PageInfo)jsonVo.getValue();
            lst = pageInfo.getList();
        }
        return BaseJsonVo.success(lst);
    }

    @RequestMapping(value={"testAutoPushMessage"})
    public BaseJsonVo getQwServiceSop() throws AuthorizeException {
        return this.routeCustomerInterface.pushAutoMessage(new Date());
    }

    @RequestMapping(value={"testAddCustomerRoute"})
    public BaseJsonVo testAddCustomerRoute() {
        this.routeCustomerInterface.saveRouteCustomer("wmEgf2CQAAu22uryWa7jWuiZagUOUIOQ", "3071631527888182716", "202303011652585594089950001_1", "", "AiLinlrene");
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"pushMessageWithMaterialId"})
    public BaseJsonVo pushMessageWithMaterialId(Integer materialId) throws AuthorizeException {
        if (materialId == null || materialId == 0) {
            return BaseJsonVo.error((String)"\u7d20\u6750ID\u9519\u8bef");
        }
        return this.routeCustomerInterface.pushMessageWithMaterialId(materialId);
    }

    @RequestMapping(value={"setProcessStatus"})
    public BaseJsonVo setProcessStatus(Integer id) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (id == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9");
        }
        return this.routeCustomerInterface.setProcessStatus(user.getUserId(), id.intValue());
    }

    @RequestMapping(value={"saveRoute"})
    public BaseJsonVo saveRoute(RouteEntity routeEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (routeEntity.getId() == null) {
            if (routeEntity.getCreateTime() == null) {
                routeEntity.setCreateTime(new Date());
            }
            routeEntity.setCreateUserId(user.getUserId());
            if (routeEntity.getStatus() == null) {
                routeEntity.setStatus(Integer.valueOf(0));
            }
        }
        return this.routeInterface.saveRoute(routeEntity);
    }

    @RequestMapping(value={"changeRouteStatus"})
    public BaseJsonVo changeRouteStatus(Integer routeId, Integer status) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.routeInterface.changeRouteStatus(routeId, status);
    }

    @RequestMapping(value={"deleteRoute"})
    public BaseJsonVo deleteRoute(Integer routeId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.routeInterface.deleteRoute(routeId);
    }

    @RequestMapping(value={"getRouteLinks"})
    public BaseJsonVo getRouteLinks(Integer routeId) {
        return this.routeLinkInterface.getRouteLinksMap(routeId);
    }

    @RequestMapping(value={"saveRouteLinks"})
    public BaseJsonVo saveRouteLinks(@RequestBody List<RouteLinkEntity> routeLinkEntities) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (routeLinkEntities == null) {
            return BaseJsonVo.error((String)"\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.routeLinkInterface.saveRouteLinks(routeLinkEntities);
    }

    @RequestMapping(value={"saveRouteLink"})
    public BaseJsonVo saveRouteLink(RouteLinkEntity routeLinkEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.routeLinkInterface.saveRouteLink(routeLinkEntity);
    }

    @RequestMapping(value={"deleteRouteLink"})
    public BaseJsonVo deleteRouteLink(String id) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        int i = this.routeLinkInterface.deleteByPrimaryKey((Serializable)((Object)id));
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"getRoutePageList"})
    public BaseJsonVo getRoutePageList(Integer currentPage, Integer pageSize, RouteEntityVo routeEntity, Boolean onlySelf) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (onlySelf.booleanValue()) {
            routeEntity.setCreateUserId(user.getUserId());
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)routeEntity.getRouteName())) {
            routeEntity.setRouteName(null);
        }
        if (routeEntity.getStatus() == null || routeEntity.getStatus() == -1) {
            routeEntity.setStatus(null);
        }
        if (routeEntity.getRouteRun() == null || routeEntity.getRouteRun() == -1) {
            routeEntity.setRouteRun(null);
        }
        if (Integer.valueOf(0).equals(routeEntity.getGroupId())) {
            routeEntity.setGroupId(null);
        }
        return this.routeInterface.getRoutePageList(currentPage, pageSize, routeEntity);
    }

    @RequestMapping(value={"getServiceOption"})
    public BaseJsonVo getServiceOption() {
        return BaseJsonVo.success((Object)this.routeInterface.getServiceOption());
    }

    @RequestMapping(value={"execRouteLik"})
    public BaseJsonVo execRouteLik(Integer routeId) {
        return this.routeInterface.execRoute(routeId);
    }

    @RequestMapping(value={"deployRoute"})
    public BaseJsonVo deployRoute(Integer routeId) {
        return this.routeInterface.startRoute(routeId);
    }

    @RequestMapping(value={"sendService"})
    public BaseJsonVo sendService(String qyuser) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.selectByPrimaryKey(Integer.valueOf(10));
        MessageResult ma = new MessageResult();
        if (weiXinBaseEntity != null) {
            ma = WxApiUtils.sendAppTextMessage((String)weiXinBaseEntity.getAccessToken(), (Integer)Integer.valueOf(weiXinBaseEntity.getMchId()), (String)qyuser, (String)("\u81ea\u5b9a\u4e49\u6587\u672c" + new Date()));
        }
        return BaseJsonVo.success((Object)ma);
    }

    @RequestMapping(value={"recursionSort"})
    public BaseJsonVo recursionSort(Integer routeId) {
        List ls = this.routeLinkInterface.getRouteLinks(routeId);
        this.routeLinkInterface.recursionSort(ls, null, Integer.valueOf(1));
        return BaseJsonVo.success((Object)ls);
    }

    @RequestMapping(value={"execMaterialRule"})
    public BaseJsonVo execMaterialRule(String date, String customerId) throws AuthorizeException {
        this.routeCustomerInterface.execMaterialRule(DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd"), customerId);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"copyRoute"})
    public BaseJsonVo copyRoute(Integer routeId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        this.routeInterface.copyRoute(routeId, user.getUserId());
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"noWorkSopTransfer"})
    public BaseJsonVo noWorkSopTransfer() throws AuthorizeException {
        this.routeCustomerInterface.noWorkSopTransfer();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getRunRecord"})
    public BaseJsonVo getRunRecord(String date) {
        return this.runRecordInterface.getRunRecord(DateUtils.StrToDate((String)date));
    }

    @RequestMapping(value={"getQwIsSendTest"})
    public BaseJsonVo getQwIsSend(String date) {
        return this.routeCustomerInterface.getQwIsSend(DateUtils.StrToDate((String)date));
    }

    @RequestMapping(value={"getUserIsRepeatTest"})
    public BaseJsonVo getUserIsRepeat(String date, Integer pageNum) {
        Integer pageSize = 500;
        if (pageNum == null) {
            pageNum = 1;
            pageSize = 100000;
        }
        return this.routeCustomerInterface.getUserIsRepeat(DateUtils.StrToDate((String)date), pageNum, pageSize);
    }

    @RequestMapping(value={"getTodaySopCount"})
    public BaseJsonVo getTodaySopCount() {
        return BaseJsonVo.success((Object)this.routeCustomerInterface.getTodaySopCount(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd")));
    }

    @RequestMapping(value={"testPushVideo"})
    public BaseJsonVo testPushVideo(String qyWeixinUserid, String externalCustomerId, String mediaId) {
        HashSet<String> s = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)externalCustomerId)) {
            s.add(externalCustomerId);
        }
        return this.routeCustomerInterface.testPushVideo(qyWeixinUserid, s, mediaId);
    }
}

