/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.scrm.entity.scene.PredictDayEnum;
import cc.lechun.scrm.entity.scene.SceneEntity;
import cc.lechun.scrm.entity.scene.SceneEntityVo;
import cc.lechun.scrm.entity.scene.UserGroup;
import cc.lechun.scrm.entity.scene.UserGroupQuery;
import cc.lechun.scrm.iservice.scene.SceneInterface;
import cc.lechun.scrm.iservice.scene.UserGroupInterface;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scene"})
public class SceneController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserGroupInterface userGroupInterface;
    @Autowired
    private SceneInterface sceneInterface;

    @RequestMapping(value={"getUserGroupDetail"})
    public BaseJsonVo getUserGroupDetail(Integer groupId) {
        return this.userGroupInterface.getUserGroup(groupId);
    }

    @RequestMapping(value={"getUserGroupList"})
    public BaseJsonVo getPropertyList(UserGroupQuery userGroupVo) {
        return BaseJsonVo.success((Object)this.userGroupInterface.getUserGroupList(userGroupVo));
    }

    @RequestMapping(value={"saveUserGroup"})
    public BaseJsonVo saveUserGroup(HttpServletRequest request, @RequestBody UserGroup userGroup, BindingResult bindingResult) throws AuthorizeException, IOException {
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)JsonUtils.toJson((Object)userGroup, (boolean)false));
        if (StringUtils.isEmpty((String)userGroup.getGroupName())) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u7fa4\u7ec4\u540d\u79f0");
        }
        MallUserEntity user = this.getUser();
        userGroup.setUserId(user.getUserId());
        userGroup.setUserName(user.getUserName());
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)userGroup.toString());
        return this.userGroupInterface.saveUserGroup(userGroup);
    }

    @RequestMapping(value={"getUserCount"})
    public BaseJsonVo getUserCount(HttpServletRequest request, @RequestBody UserGroup userGroup, BindingResult bindingResult) throws AuthorizeException, IOException {
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)JsonUtils.toJson((Object)userGroup, (boolean)false));
        if (StringUtils.isEmpty((String)userGroup.getGroupName())) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u7fa4\u7ec4\u540d\u79f0");
        }
        MallUserEntity user = this.getUser();
        userGroup.setUserId(user.getUserId());
        userGroup.setUserName(user.getUserName());
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)userGroup.toString());
        return this.userGroupInterface.getUserCount(userGroup);
    }

    @RequestMapping(value={"getUserCountByDay"})
    public BaseJsonVo getUserCountByDay(Integer groupId, Integer day) throws AuthorizeException, IOException {
        this.log.info("\u67e5\u8be2\u7fa4\u7ec4{},\u7b2c:{}\u5929 \u9884\u4f30\u53bb\u91cd\u4eba\u6570", (Object)groupId, (Object)day);
        return this.userGroupInterface.getUserCount(groupId, day);
    }

    @RequestMapping(value={"getDateList"})
    public BaseJsonVo getDateList() {
        return BaseJsonVo.success((Object)PredictDayEnum.getList());
    }

    @RequestMapping(value={"getUserCountTest"})
    public BaseJsonVo getUserCountTest(HttpServletRequest request, Integer groupId) throws AuthorizeException, IOException {
        return this.userGroupInterface.getUserGroupSql(groupId);
    }

    @RequestMapping(value={"copyUserGroup"})
    public BaseJsonVo copyUserGroup(HttpServletRequest request, Integer groupId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.userGroupInterface.copyUserGroup(user.getUserId(), user.getUserName(), groupId);
    }

    @RequestMapping(value={"saveSceneEntity"})
    public BaseJsonVo saveSceneEntity(@RequestBody SceneEntity sceneEntity) throws AuthorizeException, IOException {
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)JsonUtils.toJson((Object)sceneEntity, (boolean)false));
        return this.sceneInterface.updateByPrimaryKeySelective((Object)sceneEntity) > 0 ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"getSceneEntity"})
    public BaseJsonVo getSceneEntity(Integer id) throws AuthorizeException, IOException {
        return BaseJsonVo.success((Object)this.sceneInterface.selectByPrimaryKey((Serializable)id));
    }

    @RequestMapping(value={"testSaveUserGroup"})
    public BaseJsonVo testSaveUserGroup() throws AuthorizeException, IOException {
        String userGroupStr = "%7B%22groupName%22%3A%22%E7%94%A8%E6%88%B7%E6%B5%8B%E8%AF%952222%22%2C%22groupId%22%3A1%2C%22userId%22%3Anull%2C%22userName%22%3Anull%2C%22createTime%22%3A%222022-07-18%2013%3A32%3A57%22%2C%22updateTime%22%3Anull%2C%22remark%22%3Anull%2C%22userGroupRule%22%3A%7B%22ruleType%22%3A%22event_rule%22%2C%22relation%22%3A%22and%22%2C%22ruleList%22%3A%5B%7B%22type%22%3A%22property_rule%22%2C%22eventId%22%3A1%2C%22eventName%22%3A%22%E7%94%A8%E6%88%B7%E8%AE%A2%E5%8D%95%22%2C%22icon%22%3Anull%2C%22measure%22%3A%7B%22field%22%3A%22TOTAL_AMOUNT%22%2C%22eventPropertyId%22%3A3%2C%22type%22%3A%22property_rule%22%2C%22eventName%22%3A%22%E7%94%A8%E6%88%B7%E8%AE%A2%E5%8D%95%22%2C%22aggregator%22%3A%22%E6%B1%82%E5%92%8C%22%2C%22funId%22%3A1%2C%22operateId%22%3A1%2C%22params%22%3A%2250%22%7D%2C%22relation%22%3A%22and%22%2C%22filtersRuleList%22%3A%5B%7B%22type%22%3A%22property_rule%22%2C%22relation%22%3A%22and%22%2C%22field%22%3A%22ORDER_SOURCE%22%2C%22eventPropertyId%22%3A1%2C%22operateId%22%3A10%2C%22timeTypeId%22%3Anull%2C%22params%22%3A%22%E5%A5%B6%E5%8D%A1%2C%E6%BB%A1%E5%87%8F%22%7D%5D%7D%5D%7D%2C%22userEvent%22%3A%7B%22eventId%22%3A2%2C%22relation%22%3A%22and%22%2C%22eventName%22%3A%22%E7%94%A8%E6%88%B7%22%2C%22filtersRuleList%22%3A%5B%7B%22type%22%3A%22property_rule%22%2C%22relation%22%3A%22and%22%2C%22field%22%3A%22MOBILE%22%2C%22eventPropertyId%22%3A5%2C%22operateId%22%3A10%2C%22timeTypeId%22%3Anull%2C%22params%22%3A%2218518882222%22%7D%5D%7D%2C%22status%22%3A1%2C%22statusName%22%3Anull%7D";
        userGroupStr = "%7B%22groupName%22%3A%22%E7%94%A8%E6%88%B7%E6%B5%8B%E8%AF%95%22%2C%22groupId%22%3A%221%22%2C%22userGroupRule%22%3A%7B%22relation%22%3A%22and%22%2C%22ruleType%22%3A%22event_rule%22%2C%22ruleList%22%3A%5B%5D%7D%2C%22userEvent%22%3A%7B%22eventId%22%3A%222%22%2C%22filtersRuleList%22%3A%5B%7B%22relation%22%3A%22and%22%2C%22type%22%3A%22property_rule%22%2C%22eventPropertyId%22%3A5%2C%22operateId%22%3A10%2C%22timeTypeId%22%3A%22%22%2C%22params%22%3A%2218518882222%22%7D%5D%2C%22relation%22%3A%22and%22%7D%7D";
        try {
            userGroupStr = URLDecoder.decode(userGroupStr, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.log.info("\u7528\u6237\u89c4\u5219={}", (Object)userGroupStr);
        UserGroup userGroup = null;
        this.log.info("josn={}", userGroup);
        userGroup = (UserGroup)JSON.parseObject((String)userGroupStr, UserGroup.class);
        userGroup.setUserId("123");
        userGroup.setUserName("123");
        return BaseJsonVo.success((Object)this.userGroupInterface.saveUserGroup(userGroup));
    }

    @RequestMapping(value={"testGetSql"})
    public BaseJsonVo testGetSql(Integer groupId) {
        return this.userGroupInterface.generateSql(groupId);
    }

    @RequestMapping(value={"getScenePageList"})
    public BaseJsonVo getScenePageList(Integer currentPage, Integer pageSize, SceneEntityVo sceneEntity, Boolean onlySelf) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (onlySelf.booleanValue()) {
            sceneEntity.setCreateUserId(user.getUserId());
        }
        if (com.alibaba.excel.util.StringUtils.isEmpty((Object)sceneEntity.getSceneName())) {
            sceneEntity.setSceneName(null);
        }
        if (sceneEntity.getStatus() == null || sceneEntity.getStatus() == -1) {
            sceneEntity.setStatus(null);
        }
        if (Integer.valueOf(0).equals(sceneEntity.getGroupId())) {
            sceneEntity.setGroupId(null);
        }
        return this.sceneInterface.getScenePageList(currentPage, pageSize, sceneEntity);
    }

    @RequestMapping(value={"changeStatus"})
    public BaseJsonVo changeStatus(Integer sceneId, Integer status) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.sceneInterface.changeStatus(sceneId, status);
    }

    @RequestMapping(value={"deleteScene"})
    public BaseJsonVo deleteScene(Integer sceneId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.sceneInterface.deleteScene(sceneId);
    }

    @RequestMapping(value={"getSceneOption"})
    public BaseJsonVo getSceneOption() {
        SceneEntity sceneEntity = new SceneEntity();
        sceneEntity.setStatus(Integer.valueOf(1));
        List lst = this.sceneInterface.getList((Object)sceneEntity);
        ArrayList results = new ArrayList();
        for (SceneEntity m : lst) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", m.getId());
            map.put("label", m.getSceneName());
            results.add(map);
        }
        return BaseJsonVo.success(results);
    }

    @RequestMapping(value={"execInsertScene"})
    public BaseJsonVo execInsertScene(Integer scene) {
        return this.sceneInterface.buildSceneCustomers(scene);
    }

    @RequestMapping(value={"execCountScene"})
    public BaseJsonVo execCountScene(Integer scene) {
        return BaseJsonVo.success((Object)this.sceneInterface.execCountScene(scene));
    }

    @RequestMapping(value={"saveSceneName"})
    public BaseJsonVo saveSceneName(SceneEntity scene) {
        return this.sceneInterface.saveSceneName(scene);
    }
}

