/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.scrm.entity.group.SceneRouteGroupEntity;
import cc.lechun.scrm.entity.group.SceneRouteGroupRefEntity;
import cc.lechun.scrm.entity.group.SceneRouteGroupRuleEntity;
import cc.lechun.scrm.iservice.group.SceneRouteGroupInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRefInterface;
import cc.lechun.scrm.iservice.group.SceneRouteGroupRuleInterface;
import com.alibaba.excel.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sceneRouteGroup"})
public class SceneRouteGroupController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SceneRouteGroupInterface sceneRouteGroupInterface;
    @Autowired
    private SceneRouteGroupRefInterface sceneRouteGroupRefInterface;
    @Autowired
    private SceneRouteGroupRuleInterface groupRuleInterface;

    @RequestMapping(value={"getGroupList"})
    public BaseJsonVo getGroupList(Integer currentPage, Integer pageSize, SceneRouteGroupEntity routeGroupEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        routeGroupEntity.setCreateUserId(user.getUserId());
        return BaseJsonVo.success((Object)this.sceneRouteGroupInterface.getGroupPageList(currentPage, pageSize, routeGroupEntity));
    }

    @RequestMapping(value={"getGroupEntity"})
    public BaseJsonVo getGroupEntity(Integer id) {
        if (id == null) {
            return BaseJsonVo.error((String)"ID\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.sceneRouteGroupInterface.selectByPrimaryKey((Serializable)id));
    }

    @RequestMapping(value={"saveGroup"})
    public BaseJsonVo saveGroup(SceneRouteGroupEntity routeGroupEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (routeGroupEntity == null) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u5185\u5bb9\u4e3a\u7a7a");
        }
        routeGroupEntity.setCreateUserId(user.getUserId());
        return this.sceneRouteGroupInterface.saveGroup(routeGroupEntity);
    }

    @RequestMapping(value={"delGroup"})
    public BaseJsonVo delGroup(Integer id) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (id == null) {
            return BaseJsonVo.error((String)"ID\u4e3a\u7a7a");
        }
        SceneRouteGroupRefEntity routeGroupRefEntity = new SceneRouteGroupRefEntity();
        routeGroupRefEntity.setGroupId(id);
        if (this.sceneRouteGroupRefInterface.existsByEntity((Object)routeGroupRefEntity) > 0) {
            return BaseJsonVo.error((String)"\u5df2\u7ecf\u5b58\u5728\u7ec4\u5173\u7cfb\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.sceneRouteGroupInterface.deleteByPrimaryKey((Serializable)id);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"saveSceneGroupRef"})
    public BaseJsonVo saveSceneGroupRef(String groupId, Integer sceneId) throws AuthorizeException {
        String[] groupIds;
        MallUserEntity user = this.getUser();
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4Id\u4e3a\u7a7a");
        }
        this.sceneRouteGroupRefInterface.removeGroup(null, sceneId, Integer.valueOf(1), user.getUserId());
        if (StringUtils.isEmpty((Object)groupId)) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        for (String g : groupIds = groupId.split(",")) {
            SceneRouteGroupRefEntity routeGroupRefEntity = new SceneRouteGroupRefEntity();
            routeGroupRefEntity.setGroupId(Integer.valueOf(g));
            routeGroupRefEntity.setSceneRouteId(sceneId);
            routeGroupRefEntity.setSceneRoute(Integer.valueOf(1));
            routeGroupRefEntity.setCreater(user.getUserId());
            this.sceneRouteGroupRefInterface.saveGroupRef(routeGroupRefEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"saveRoueGroupRef"})
    public BaseJsonVo saveGroupRef(String groupId, Integer routeId) throws AuthorizeException {
        String[] groupIds;
        MallUserEntity user = this.getUser();
        if (routeId == null) {
            return BaseJsonVo.error((String)"\u65c5\u7a0bId\u4e3a\u7a7a");
        }
        this.sceneRouteGroupRefInterface.removeGroup(null, routeId, Integer.valueOf(2), user.getUserId());
        if (StringUtils.isEmpty((Object)groupId)) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        for (String g : groupIds = groupId.split(",")) {
            SceneRouteGroupRefEntity routeGroupRefEntity = new SceneRouteGroupRefEntity();
            routeGroupRefEntity.setGroupId(Integer.valueOf(g));
            routeGroupRefEntity.setSceneRouteId(routeId);
            routeGroupRefEntity.setSceneRoute(Integer.valueOf(2));
            routeGroupRefEntity.setCreater(user.getUserId());
            this.sceneRouteGroupRefInterface.saveGroupRef(routeGroupRefEntity);
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"removeGroupScene"})
    public BaseJsonVo removeGroupScene(Integer groupId, Integer sceneId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (groupId == null) {
            return BaseJsonVo.error((String)"\u7ec4Id\u4e3a\u7a7a");
        }
        if (sceneId == null) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4Id\u4e3a\u7a7a");
        }
        return this.sceneRouteGroupRefInterface.removeGroup(groupId, sceneId, Integer.valueOf(1), user.getUserId());
    }

    @RequestMapping(value={"removeGroupRoute"})
    public BaseJsonVo removeGroupRoute(Integer groupId, Integer routeId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (groupId == null) {
            return BaseJsonVo.error((String)"\u7ec4Id\u4e3a\u7a7a");
        }
        if (routeId == null) {
            return BaseJsonVo.error((String)"\u7fa4\u7ec4Id\u4e3a\u7a7a");
        }
        return this.sceneRouteGroupRefInterface.removeGroup(groupId, routeId, Integer.valueOf(2), user.getUserId());
    }

    @RequestMapping(value={"saveGroupSort"})
    public BaseJsonVo saveGroupSort(Integer groupId, Integer sort) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (groupId == null) {
            return BaseJsonVo.error((String)"\u7ec4Id\u4e3a\u7a7a");
        }
        ArrayList<SceneRouteGroupEntity> lst = new ArrayList<SceneRouteGroupEntity>();
        SceneRouteGroupEntity g = new SceneRouteGroupEntity();
        g.setId(groupId);
        g.setSeq(sort);
        lst.add(g);
        return this.sceneRouteGroupInterface.saveGroupSort(lst);
    }

    @RequestMapping(value={"getGroupRuleList"})
    public BaseJsonVo groupRuleInterface(Integer groupId) throws AuthorizeException {
        if (groupId == null) {
            return BaseJsonVo.error((String)"\u76ee\u5f55Id\u4e3a\u7a7a");
        }
        if (this.sceneRouteGroupInterface.exists((Serializable)groupId) == 0) {
            return BaseJsonVo.error((String)"\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)this.groupRuleInterface.getGroupRuleList(groupId));
    }

    @RequestMapping(value={"saveGroupRuleList"})
    public BaseJsonVo saveGroupRuleList(@RequestBody List<SceneRouteGroupRuleEntity> lst) throws AuthorizeException {
        if (lst == null || lst.size() == 0) {
            return BaseJsonVo.error((String)"\u76ee\u5f55\u5217\u8868\u4e3a\u7a7a");
        }
        return BaseJsonVo.success((Object)this.groupRuleInterface.saveGroupRuleList(lst));
    }
}

