/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrm;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.scrm.entity.option.DictionaryDetailQueryVo;
import cc.lechun.scrm.entity.property.DicTypeEnum;
import cc.lechun.scrm.entity.property.EventPropertyEntity;
import cc.lechun.scrm.entity.property.EventPropertyTypeEnum;
import cc.lechun.scrm.entity.property.PropertyClassEnum;
import cc.lechun.scrm.entity.property.PropertyDataTypeEnum;
import cc.lechun.scrm.entity.property.PropertyEntity;
import cc.lechun.scrm.entity.property.PropertyQueryVo;
import cc.lechun.scrm.entity.property.PropertyTypeEnum;
import cc.lechun.scrm.iservice.option.DictionaryDetailInterface;
import cc.lechun.scrm.iservice.property.EventPropertyInterface;
import cc.lechun.scrm.iservice.property.PropertyInterface;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scrmproperty"})
public class ScrmPropertyController
extends BaseController {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    PropertyInterface propertyInterface;
    @Autowired
    EventPropertyInterface eventPropertyInterface;
    @Autowired
    DictionaryDetailInterface dictionaryDetailInterface;

    @RequestMapping(value={"getPropertyList"})
    public BaseJsonVo getPropertyList(PropertyEntity propertyEntity) {
        return BaseJsonVo.success((Object)this.propertyInterface.getList((Object)propertyEntity, 0L));
    }

    @RequestMapping(value={"getPagePropertyList"})
    public BaseJsonVo getPagePropertyList(PropertyQueryVo propertyQueryVo) {
        return BaseJsonVo.success((Object)this.propertyInterface.getPropertyList(propertyQueryVo));
    }

    @RequestMapping(value={"getPropertyTypeList"})
    public BaseJsonVo getPropertyTypeList() {
        return BaseJsonVo.success((Object)PropertyTypeEnum.getList());
    }

    @RequestMapping(value={"getPropertyClassList"})
    public BaseJsonVo getPropertyClassList() {
        return BaseJsonVo.success((Object)PropertyClassEnum.getList());
    }

    @RequestMapping(value={"getPropertyDataTypeList"})
    public BaseJsonVo getPropertyDataTypeList() {
        return BaseJsonVo.success((Object)PropertyDataTypeEnum.getList());
    }

    @RequestMapping(value={"getEventPropertyTypeList"})
    public BaseJsonVo getEventPropertyTypeList() {
        return BaseJsonVo.success((Object)EventPropertyTypeEnum.getList());
    }

    @RequestMapping(value={"getDicTypeList"})
    public BaseJsonVo getDicTypeList() {
        return BaseJsonVo.success((Object)DicTypeEnum.getList());
    }

    @RequestMapping(value={"getProperty"})
    public BaseJsonVo getProperty(Integer propertyId) {
        return BaseJsonVo.success((Object)this.propertyInterface.selectByPrimaryKey((Serializable)propertyId, 0L));
    }

    @RequestMapping(value={"saveProperty"})
    public BaseJsonVo saveProperty(PropertyEntity propertyEntity) {
        return this.propertyInterface.saveProperty(propertyEntity);
    }

    @RequestMapping(value={"deleteProperty"})
    public BaseJsonVo deleteProperty(Integer propertyId) {
        return this.propertyInterface.deleteProperty(propertyId);
    }

    @RequestMapping(value={"getEventPropertyList"})
    public BaseJsonVo getEventPropertyList(EventPropertyEntity eventPropertyEntity) {
        return this.eventPropertyInterface.getEventPropertyList(eventPropertyEntity);
    }

    @RequestMapping(value={"saveEventProperty"})
    public BaseJsonVo saveEventProperty(EventPropertyEntity eventPropertyEntity) {
        return this.eventPropertyInterface.saveEventProperty(eventPropertyEntity);
    }

    @RequestMapping(value={"getEventProperty"})
    public BaseJsonVo getEventProperty(Integer eventPropertyId) {
        return BaseJsonVo.success((Object)this.eventPropertyInterface.selectByPrimaryKey((Serializable)eventPropertyId, 0L));
    }

    @RequestMapping(value={"getEventPropertyItemList"})
    public BaseJsonVo getEventPropertyItemList(DictionaryDetailQueryVo dictionaryDetailQueryVo) {
        return BaseJsonVo.success((Object)this.dictionaryDetailInterface.getList(dictionaryDetailQueryVo));
    }

    @RequestMapping(value={"changeEventPropertyStatus"})
    public BaseJsonVo changeEventPropertyStatus(EventPropertyEntity eventPropertyEntity) {
        return this.eventPropertyInterface.changeStatus(eventPropertyEntity);
    }

    @RequestMapping(value={"deleteEventProperty"})
    public BaseJsonVo changeEventPropertyStatus(Integer eventPropertyId) {
        return BaseJsonVo.success((Object)this.eventPropertyInterface.deleteByPrimaryKey((Serializable)eventPropertyId));
    }
}

