/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.scrollpic;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.scrollpic.ScrollPicTypeEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.scrollpic.MallScrollPicDetailEntity;
import cc.lechun.mall.entity.scrollpic.MallScrollPicEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicDetailInterface;
import cc.lechun.mall.iservice.scrollpic.MallScrollPicInterface;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/scrollpic"})
public class ScrollPicController
extends BaseController {
    @Autowired
    private MallScrollPicDetailInterface mallScrollPicDetailInterface;
    @Autowired
    private MallScrollPicInterface mallScrollPicInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @RequestMapping(value={"/getScrollPicType"})
    @ResponseBody
    public BaseJsonVo getScrollPicType() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)ScrollPicTypeEnum.getList());
    }

    @RequestMapping(value={"/getPlatFormList"})
    @ResponseBody
    public BaseJsonVo getPlatFormList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.getUserPlatFormList());
    }

    @RequestMapping(value={"/getMallScrollPicList"})
    @ResponseBody
    public BaseJsonVo getMallScrollPicList(PageForm pageForm, MallScrollPicEntity scrollPicEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        PageInfo ls = this.mallScrollPicInterface.getMallScrollPicList(pageForm.getCurrentPage(), pageForm.getPageSize(), user.getPlatformId(), scrollPicEntity);
        ls.getList().forEach(mallScrollPicVo -> {
            mallScrollPicVo.setStatusName(mallScrollPicVo.getStatus() == 1 ? "\u542f\u7528" : "\u7981\u7528");
            mallScrollPicVo.setPlatformIdName(this.platFormInterface.getPlatForm(mallScrollPicVo.getPlatformId().intValue()).getPlatformName());
            mallScrollPicVo.setPicTypeName(ScrollPicTypeEnum.getName((int)mallScrollPicVo.getPicType()));
            mallScrollPicVo.setDateFormat(DateUtils.formatDate((Date)mallScrollPicVo.getCreateTime(), (String)""));
        });
        return BaseJsonVo.success((Object)ls);
    }

    @RequestMapping(value={"/updateOrSaveScrollPic"})
    @ResponseBody
    public BaseJsonVo updateOrSaveScrollPic(MallScrollPicEntity mallScrollPicEntity) throws AuthorizeException {
        if (mallScrollPicEntity.getScrollId() != null && mallScrollPicEntity.getScrollId() != 0) {
            MallUserEntity user = this.getUser();
            return this.mallScrollPicInterface.updateMallScrollPic(mallScrollPicEntity);
        }
        return this.mallScrollPicInterface.saveMallScrollPic(mallScrollPicEntity);
    }

    @RequestMapping(value={"/getMallScrollPicDetailList"})
    @ResponseBody
    public BaseJsonVo getMallScrollPicDetailList(PageForm pageForm, int scrollId, Integer enabled) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallScrollPicDetailInterface.getMallScrollPicDetailList(pageForm.getCurrentPage(), pageForm.getPageSize(), scrollId, enabled.intValue()));
    }

    @RequestMapping(value={"/updateOrSaveScrollPicDetail"})
    @ResponseBody
    public BaseJsonVo updateOrSaveScrollPicDetail(MallScrollPicDetailEntity mallScrollPicDetailEntity) throws AuthorizeException {
        if (mallScrollPicDetailEntity.getScrollDetailid() != null && mallScrollPicDetailEntity.getScrollDetailid() != 0) {
            MallUserEntity user = this.getUser();
            return this.mallScrollPicDetailInterface.updateMallScrollPicDetail(mallScrollPicDetailEntity);
        }
        return this.mallScrollPicDetailInterface.saveMallScrollPicDetail(mallScrollPicDetailEntity);
    }
}

