/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sys;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.utils.LocationUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/comm"})
public class CommonController
extends BaseController {
    @Autowired
    private SysUserInterface sysUserInterface;

    @RequestMapping(value={"/platFormGroupList"})
    @ResponseBody
    public List<PlatFormGroupEntity> getPlatFormGroupList() throws AuthorizeException {
        return this.getUserValidPlatFormGroupList();
    }

    @RequestMapping(value={"/allPlatFormGroupList"})
    @ResponseBody
    public List<PlatFormGroupEntity> getAllPlatFormGroupList() throws AuthorizeException {
        List ls = this.getUserValidPlatFormGroupList();
        PlatFormGroupEntity platFormGroupEntity = new PlatFormGroupEntity();
        platFormGroupEntity.setPlatformGroupId(Integer.valueOf(0));
        platFormGroupEntity.setPlatformGroupName("\u5168\u90e8");
        ls.add(0, platFormGroupEntity);
        return ls;
    }

    @RequestMapping(value={"/allMyPlatFormGroupList"})
    @ResponseBody
    public List<PlatFormGroupEntity> allMyPlatFormGroupList() throws AuthorizeException {
        List ls = this.getUserValidPlatFormGroupList();
        if (this.getUser().getPlatformGroupId().equals("0")) {
            PlatFormGroupEntity platFormGroupEntity = new PlatFormGroupEntity();
            platFormGroupEntity.setPlatformGroupId(Integer.valueOf(0));
            platFormGroupEntity.setPlatformGroupName("\u5168\u90e8");
            ls.add(0, platFormGroupEntity);
        }
        return ls;
    }

    @RequestMapping(value={"/platFormList"})
    @ResponseBody
    public List<PlatFormEntity> gePlatFormList() throws AuthorizeException {
        return this.getUserPlatFormList();
    }

    @RequestMapping(value={"/login"})
    @ResponseBody
    public BaseJsonVo login(String userName, String passWord, HttpServletResponse response) {
        UsernamePasswordToken token = new UsernamePasswordToken(userName, passWord);
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException ex) {
            return BaseJsonVo.paramError((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        catch (IncorrectCredentialsException ex) {
            return BaseJsonVo.paramError((String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            this.log.error("\u5176\u4ed6\u7684\u767b\u5f55\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.paramError((String)("\u5176\u4ed6\u7684\u767b\u5f55\u9519\u8bef" + e.getMessage()));
        }
        if (subject.isAuthenticated()) {
            MallUserEntity user = (MallUserEntity)subject.getPrincipal();
            try {
                CookieUtils.addCookie((HttpServletResponse)response, (String)"", (String)"user", (String)URLEncoder.encode(user.getUserNick(), "utf-8"), (int)86400);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userNick", user.getUserNick());
            map.put("groupName", this.getUserValidPlatFormGroupName(user.getPlatformGroupId()));
            return BaseJsonVo.success(map);
        }
        return BaseJsonVo.error((String)"\u767b\u5f55\u9519\u8bef");
    }

    @RequestMapping(value={"/loginBySobot"})
    @ResponseBody
    public BaseJsonVo loginBySobot(String userName, String sign) {
        MallUserEntity mallUserEntity = this.sysUserInterface.getSysUser4name(userName);
        if (mallUserEntity == null) {
            return BaseJsonVo.paramError((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(userName, mallUserEntity.getPassword());
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException ex) {
            return BaseJsonVo.paramError((String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        }
        catch (IncorrectCredentialsException ex) {
            return BaseJsonVo.paramError((String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            this.log.error("\u5176\u4ed6\u7684\u767b\u5f55\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.paramError((String)("\u5176\u4ed6\u7684\u767b\u5f55\u9519\u8bef" + e.getMessage()));
        }
        if (subject.isAuthenticated()) {
            MallUserEntity user = (MallUserEntity)subject.getPrincipal();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userNick", user.getUserNick());
            map.put("groupName", this.getUserValidPlatFormGroupName(user.getPlatformGroupId()));
            return BaseJsonVo.success(map);
        }
        return BaseJsonVo.error((String)"\u767b\u5f55\u9519\u8bef");
    }

    @RequestMapping(value={"/getUserDetail"})
    @ResponseBody
    public BaseJsonVo getUserDetail() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userNick", user.getUserNick());
        map.put("groupName", this.getUserValidPlatFormGroupName(user.getPlatformGroupId()));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/logout"})
    @ResponseBody
    public BaseJsonVo logout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getSysUserMenu"})
    @ResponseBody
    public BaseJsonVo getSysUserMenu() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.sysUserInterface.getSysUserMenu(user.getUserId()));
    }

    @RequestMapping(value={"/getLocationFormatterAddress"})
    @ResponseBody
    public BaseJsonVo getLocationFormatterAddress(String city, String address, Integer choose) {
        if (choose == null) {
            choose = 2;
        }
        Map map = LocationUtils.getLocationFormatterAddress((String)address, (String)city, (int)choose);
        return BaseJsonVo.success((Object)map);
    }

    @RequestMapping(value={"/getDistance"})
    @ResponseBody
    public BaseJsonVo getDistance(String address1, String address2) {
        double d = LocationUtils.getDistance((String)address1, (String)address2);
        return BaseJsonVo.success((Object)d);
    }
}

