/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.vip;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.vip.MallVipConditionEntity;
import cc.lechun.mall.entity.vip.MallVipRewardsEntity;
import cc.lechun.mall.entity.vip.MallVipRightsEntity;
import cc.lechun.mall.entity.vip.MallVipTasksEntity;
import cc.lechun.mall.entity.vip.MallVipTasksRewardsEntity;
import cc.lechun.mall.iservice.vip.MallVipDayInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"vip"})
public class VipController
extends BaseController {
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private MallVipDayInterface vipDayService;

    @RequestMapping(value={"getVipDayInfo"})
    public BaseJsonVo getVipDayInfo() {
        Map vipDay = this.vipService.getMallVipDay();
        return BaseJsonVo.success((Object)vipDay);
    }

    @RequestMapping(value={"testRedisExpire"})
    public BaseJsonVo testRedisExpire() throws AuthorizeException {
        this.vipDayService.testRedisExpire();
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"setVipDayInfo"})
    public BaseJsonVo setVipDayInfo(String isEffective, Long startTime, Long endTime, String weekIndex) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isEffective", isEffective);
        map.put("weekIndex", weekIndex);
        this.vipService.setVipDay(map);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getVipCount"})
    public BaseJsonVo getVipCount(int level, int isTest) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        BaseJsonVo result = this.vipService.getVipCount(platformGroupId);
        return result;
    }

    @RequestMapping(value={"getVipDaySendRecord"})
    public BaseJsonVo getVipDaySendRecord(String sendDate) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (StringUtils.isEmpty((String)sendDate)) {
            sendDate = DateUtils.date();
        }
        List logs = this.vipDayService.getVipSendCount(sendDate);
        return BaseJsonVo.success((Object)logs);
    }

    @RequestMapping(value={"sendVipDayNotice"})
    public BaseJsonVo sendVipDayNotice(String levels, String sendTime) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (StringUtils.isEmpty((String)levels) || StringUtils.isEmpty((String)sendTime)) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        System.out.println(levels);
        System.out.println(sendTime);
        String[] levesInt = levels.split(",");
        ArrayList<Integer> levelList = new ArrayList<Integer>();
        for (String level : levesInt) {
            levelList.add(Integer.valueOf(level));
        }
        Date sendTimeDate = DateUtils.StrToDate((String)sendTime, (String)"");
        System.out.println(JsonUtils.toJson(levelList, (boolean)true));
        System.out.println(DateUtils.formatDate((Date)sendTimeDate, (String)""));
        Boolean b = this.vipDayService.pushNoticeMQ(levelList, sendTimeDate);
        if (b.booleanValue()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u53d1\u9001\u5931\u8d25");
    }

    @RequestMapping(value={"conditionList"})
    public PageInfo conditionList(PageForm pageForm) throws AuthorizeException {
        PageInfo list = this.vipService.conditionList(this.getUser().getPlatformGroupId(), pageForm.getCurrentPage(), pageForm.getPageSize());
        return list;
    }

    @RequestMapping(value={"getOptionConditionList"})
    public BaseJsonVo getOptionConditionList() throws AuthorizeException {
        List list = this.vipService.getOptionConditionList(this.getUser().getPlatformGroupId());
        return BaseJsonVo.success((Object)list);
    }

    @RequestMapping(value={"getVipQrcodesDropList"})
    public BaseJsonVo getVipQrcodesDropList() throws AuthorizeException {
        List list = this.vipService.getOptionVipQrcodesList(this.getUser().getPlatformGroupId());
        return BaseJsonVo.success((Object)list);
    }

    @RequestMapping(value={"saveCondition"})
    public BaseJsonVo saveCondition(MallVipConditionEntity conditionEntity) throws AuthorizeException {
        BaseJsonVo sr;
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (conditionEntity == null) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (conditionEntity.getLevel() == null || conditionEntity.getLevel() < 0) {
            return BaseJsonVo.error((String)"\u7b49\u7ea7\u9519\u8bef");
        }
        if (conditionEntity.getOrderNum() == null || conditionEntity.getOrderNum() < 0) {
            return BaseJsonVo.error((String)"\u8981\u6c42\u8ba2\u5355\u6570\u9519\u8bef");
        }
        if (conditionEntity.getPlatformGroupId() == null || conditionEntity.getPlatformGroupId() < 0) {
            conditionEntity.setPlatformGroupId(platformGroupId);
        }
        if ((sr = this.vipService.saveVipCondition(conditionEntity)).isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delCondition"})
    public BaseJsonVo delCondition(String id) throws AuthorizeException {
        this.vipService.deleteVipCondition(id);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"rewardList"})
    public PageInfo rewardList(PageForm pageForm) throws AuthorizeException {
        PageInfo list = this.vipService.rewardsList(this.getUser().getPlatformGroupId(), pageForm.getCurrentPage(), this.getUser().getPlatformGroupId().intValue());
        return list;
    }

    @RequestMapping(value={"saveReward"})
    public BaseJsonVo saveReward(MallVipRewardsEntity rewardsEntity) throws AuthorizeException {
        BaseJsonVo sr;
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (rewardsEntity == null) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (rewardsEntity.getLevel() == null || rewardsEntity.getLevel() < 0) {
            return BaseJsonVo.error((String)"\u7b49\u7ea7\u9519\u8bef");
        }
        if (rewardsEntity.getPlatformGroupId() == null || rewardsEntity.getPlatformGroupId() < 0) {
            rewardsEntity.setPlatformGroupId(platformGroupId);
        }
        if ((sr = this.vipService.saveVipRewards(rewardsEntity)).isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delReward"})
    public BaseJsonVo delReward(String id) throws AuthorizeException {
        this.vipService.deleteVipRewards(id);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"rightsList"})
    public PageInfo rightsList(PageForm pageForm, MallVipRightsEntity mallVipRightsEntity) throws AuthorizeException {
        PageInfo list = this.vipService.rightsList(this.getUser().getPlatformGroupId(), pageForm.getCurrentPage(), pageForm.getPageSize());
        return list;
    }

    @RequestMapping(value={"saveVipRights"})
    public BaseJsonVo saveVipRights(MallVipRightsEntity mallVipRightsEntity) throws AuthorizeException {
        BaseJsonVo sr;
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (mallVipRightsEntity.getPlatformGroupId() == null || mallVipRightsEntity.getPlatformGroupId() < 0) {
            mallVipRightsEntity.setPlatformGroupId(platformGroupId);
        }
        if ((sr = this.vipService.saveVipRights(mallVipRightsEntity)).isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"deleteVipRights"})
    public BaseJsonVo delRights(String rightId) throws AuthorizeException {
        this.vipService.deleteVipRights(rightId);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"rightsChangeStatus"})
    public BaseJsonVo rightsChangeStatus(String id, String hasRight) {
        this.vipService.rightsChangeStatus(id, hasRight);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"updateByIdLevel"})
    public BaseJsonVo updateByIdLevel(MallVipRightsEntity mallVipRightsEntity) {
        this.vipService.updateByIdLevel(mallVipRightsEntity);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"taskList"})
    public PageInfo taskList(PageForm pageForm) throws AuthorizeException {
        PageInfo list = this.vipService.tasksList(this.getUser().getPlatformGroupId(), pageForm.getCurrentPage(), this.getUser().getPlatformGroupId().intValue());
        return list;
    }

    @RequestMapping(value={"saveTask"})
    public BaseJsonVo saveTask(MallVipTasksEntity tasksEntity) throws AuthorizeException {
        BaseJsonVo sr;
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (tasksEntity == null) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (tasksEntity.getLevel() == null || tasksEntity.getLevel() < 0) {
            return BaseJsonVo.error((String)"\u7b49\u7ea7\u9519\u8bef");
        }
        if (tasksEntity.getPlatformGroupId() == null || tasksEntity.getPlatformGroupId() < 0) {
            tasksEntity.setPlatformGroupId(platformGroupId);
        }
        if ((sr = this.vipService.saveVipTasks(tasksEntity)).isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delTask"})
    public BaseJsonVo delTask(String id) {
        this.vipService.deleteVipTasks(id);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getOptionTaskList"})
    public BaseJsonVo getOptionTaskList() throws AuthorizeException {
        List list = this.vipService.getOptionTaskList(this.getUser().getPlatformGroupId());
        return BaseJsonVo.success((Object)list);
    }

    @RequestMapping(value={"taskRewardList"})
    public PageInfo taskRewardList(PageForm pageForm) throws AuthorizeException {
        PageInfo list = this.vipService.tasksRewardsList(this.getUser().getPlatformGroupId(), pageForm.getCurrentPage(), this.getUser().getPlatformGroupId().intValue());
        return list;
    }

    @RequestMapping(value={"saveTaskReward"})
    public BaseJsonVo saveTaskReward(MallVipTasksRewardsEntity tasksRewardsEntity) throws AuthorizeException {
        BaseJsonVo sr;
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (tasksRewardsEntity == null) {
            return BaseJsonVo.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        if (StringUtils.isEmpty((String)tasksRewardsEntity.getTaskId())) {
            return BaseJsonVo.error((String)"\u4efb\u52a1\u4e3a\u7a7a");
        }
        if (tasksRewardsEntity.getPlatformGroupId() == null || tasksRewardsEntity.getPlatformGroupId() < 0) {
            tasksRewardsEntity.setPlatformGroupId(platformGroupId);
        }
        if ((sr = this.vipService.saveVipTasksRewards(tasksRewardsEntity)).isSuccess()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"delTaskReward"})
    public BaseJsonVo delTaskReward(String id) {
        this.vipService.deleteVipTasksRewards(id);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"finishTask"})
    public BaseJsonVo finishTask(String customerId, String taskId) {
        this.vipService.finishTask(customerId, taskId);
        return BaseJsonVo.success((Object)"");
    }
}

