/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.weixin;

import cc.lechun.active.vo.ActiveBaseVo;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.oss.AliyunOSSDir;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.distribution.ShareEntity;
import cc.lechun.mall.entity.weixin.MiniCardDo;
import cc.lechun.mall.entity.weixin.MiniCardQueryVo;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaOptionVo;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.MiniCardInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/mediaManage"})
public class WeiXinMediaController
extends BaseController {
    @Autowired
    private WeiXinMediaInterface weiXinMediaService;
    @Autowired
    private OssService ossService;
    @Autowired
    private PlatFormInterface platFormService;
    @Autowired
    private ShareInterface shareInterface;
    @Autowired
    private MiniCardInterface miniCardInterface;

    @RequestMapping(value={"/saveMiniCard"})
    public BaseJsonVo saveMiniCard(MiniCardDo miniCardDo) {
        return this.miniCardInterface.saveMiniCard(1, miniCardDo);
    }

    @RequestMapping(value={"/deleteMiniCard"})
    public BaseJsonVo deleteMiniCard(int miniCardId) {
        this.miniCardInterface.deleteByPrimaryKey((Serializable)Integer.valueOf(miniCardId));
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getMediaforOptions"})
    public BaseJsonVo getMediaListByStatus(Integer status, Integer platformId) {
        List list = this.weiXinMediaService.getMediaListByStatus(status, platformId);
        if (list != null && list.size() >= 1) {
            return BaseJsonVo.success(list.stream().map(m -> {
                WeiXinMediaOptionVo vo = new WeiXinMediaOptionVo();
                vo.setMediaId(m.getMediaId());
                vo.setTitle(m.getTitle());
                return vo;
            }).collect(Collectors.toList()));
        }
        return BaseJsonVo.success((Object)list);
    }

    @RequestMapping(value={"/getMediaforList"})
    public BaseJsonVo getMediaforList(Integer status, Integer platformId) {
        ShareEntity shareEntity = new ShareEntity();
        shareEntity.setPlatformId(platformId);
        return BaseJsonVo.success((Object)this.shareInterface.getSharePageList(Integer.valueOf(1), Integer.valueOf(9999999), shareEntity).getList());
    }

    @RequestMapping(value={"/getMiniCardList"})
    public BaseJsonVo getMiniCardList(MiniCardQueryVo miniCardQueryVo) {
        return BaseJsonVo.success((Object)this.miniCardInterface.getMiniCardList(miniCardQueryVo));
    }

    @RequestMapping(value={"/getMedia"})
    public ActiveBaseVo<WeiXinMediaEntity> getMedia(Integer id) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        activeBaseVo.setStatus(1);
        activeBaseVo.setData((Object)this.weiXinMediaService.getWeiXinMediaById(id));
        return activeBaseVo;
    }

    @RequestMapping(value={"/saveMedia"})
    public BaseJsonVo saveMedia(WeiXinMediaEntity weiXinMedia) throws AuthorizeException {
        if (weiXinMedia.getId() == null || weiXinMedia.getId() == 0) {
            weiXinMedia.setPlatformGroupId(this.getUser().getPlatformGroupId());
            weiXinMedia.setMediaId(RandomUtils.generateStrId());
        }
        weiXinMedia.setUpdateTime(DateUtils.now());
        return this.weiXinMediaService.saveMedia(weiXinMedia) ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"/uploadImg"}, method={RequestMethod.POST})
    public ActiveBaseVo<String> uploadImg(HttpServletRequest req, MultipartFile image) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        StringBuffer url = new StringBuffer();
        String fileName = UUID.randomUUID() + "_" + image.getOriginalFilename().replaceAll(" ", "");
        String imageUrl = AliyunOSSDir.IMG_STORAGE.getPath() + fileName;
        try {
            this.ossService.uploadFile(fileName, image.getInputStream());
            activeBaseVo.setMsg("\u4e0a\u4f20\u5b8c\u6210");
            activeBaseVo.setStatus(1);
            activeBaseVo.setMsg(this.ossService.getImageResoure(imageUrl));
            return activeBaseVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            activeBaseVo.setStatus(0);
            this.log.error("\u4e0a\u4f20\u7d20\u6750\u5931\u8d25," + e.getMessage());
            activeBaseVo.setMsg("\u4e0a\u4f20\u5931\u8d25");
            return activeBaseVo;
        }
    }

    @RequestMapping(value={"/deleteMedia"})
    public BaseJsonVo deleteMedia(Integer id) {
        boolean b = this.weiXinMediaService.deleteMedia(id.intValue());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/getMediaList"})
    public Map<String, Object> getMediaList(PageForm pageForm, WeiXinMediaEntity mediaEntity) throws AuthorizeException {
        if (StringUtils.isEmpty((String)mediaEntity.getTitle())) {
            mediaEntity.setTitle(null);
        }
        if (StringUtils.isEmpty((String)mediaEntity.getDigest())) {
            mediaEntity.setDigest(null);
        }
        mediaEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("platFormList", this.platFormService.getPlatFormList(this.getUser().getPlatformGroupId().intValue()));
        map.put("weiXinMediaList", this.weiXinMediaService.queryPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), mediaEntity).getValue());
        return map;
    }

    @RequestMapping(value={"/getMediaDataList"})
    public BaseJsonVo getMediaDataList(PageForm pageForm, WeiXinMediaEntity mediaEntity) throws AuthorizeException {
        if (StringUtils.isEmpty((String)mediaEntity.getTitle())) {
            mediaEntity.setTitle(null);
        }
        if (StringUtils.isEmpty((String)mediaEntity.getDigest())) {
            mediaEntity.setDigest(null);
        }
        mediaEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        return this.weiXinMediaService.queryPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), mediaEntity);
    }

    @RequestMapping(value={"/updateMediaStatus"})
    public ActiveBaseVo<String> updateMediaStatus(WeiXinMediaEntity weiXinMediaEntity) {
        ActiveBaseVo activeBaseVo = new ActiveBaseVo();
        activeBaseVo.setStatus(this.weiXinMediaService.updateSelectMedia(weiXinMediaEntity) ? 1 : 0);
        activeBaseVo.setData((Object)(activeBaseVo.getStatus() >= 1 ? "\u4fee\u6539\u6210\u529f" : "\u4fee\u6539\u5931\u8d25"));
        return activeBaseVo;
    }

    @RequestMapping(value={"/pullMediaList"})
    public BaseJsonVo pullMediaList(Integer platformId) throws AuthorizeException {
        boolean b = this.weiXinMediaService.pullDraftList(platformId.intValue(), this.getUser().getPlatformGroupId().intValue());
        b = this.weiXinMediaService.pullDraftSuccessList(platformId.intValue(), this.getUser().getPlatformGroupId().intValue());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u62c9\u53d6\u5931\u8d25");
    }

    @RequestMapping(value={"/pullDraftList"})
    public BaseJsonVo pullDraftList(Integer platformId) throws AuthorizeException {
        boolean b = this.weiXinMediaService.pullDraftList(platformId.intValue(), this.getUser().getPlatformGroupId().intValue());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u62c9\u53d6\u5931\u8d25");
    }

    @RequestMapping(value={"/getMediaListOption"})
    public BaseJsonVo getMediaListOption(Integer platformId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.weiXinMediaService.getMediaListForOption(platformId));
    }
}

