/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.api.order;

import cc.lechun.csmsapi.api.order.OrderApi;
import cc.lechun.csmsapi.apiinvoke.order.MallOrderInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderProductInvoke;
import cc.lechun.csmsapi.dto.order.OrderDetailInfoDto;
import cc.lechun.csmsapi.dto.order.OrderEditParamDto;
import cc.lechun.csmsapi.dto.order.OrderQueryParamDto;
import cc.lechun.csmsapi.iservice.order.OrderInterface;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mallapi.dto.EditOrderAddressDTO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OrderApiImpl
implements OrderApi {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OrderInterface orderInterface;
    @Autowired
    private OrderProductInvoke orderProductInvoke;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    private MallOrderInvoke mallOrderInvoke;
    @Value(value="${erp.orderDeliver.url}")
    private String orderDeliverUrl;

    public BaseJsonVo createOrder(HttpServletRequest request, String orderParam) {
        return this.orderInterface.createOrder(orderParam);
    }

    public BaseJsonVo getOrderInfoByPage(OrderQueryParamDto orderQueryParamDto) {
        this.logger.info("+++++++++OrderQueryParamDto+++={}", (Object)JSON.toJSONString((Object)orderQueryParamDto));
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setPage(orderQueryParamDto.getCurrentPage());
        wxOrderRequest.setRows(orderQueryParamDto.getPageSize());
        wxOrderRequest.setExternalOrderNo(orderQueryParamDto.getExternalOrderNo());
        wxOrderRequest.setExternalMainOrderNo(orderQueryParamDto.getExternalMainOrderNo());
        wxOrderRequest.setSourceOrderMainNo(orderQueryParamDto.getSourceOrderMainNo());
        wxOrderRequest.setConsigneeMobile(orderQueryParamDto.getConsigneeMobile());
        wxOrderRequest.setConsigneeName(orderQueryParamDto.getConsigneeName());
        wxOrderRequest.setShopName(orderQueryParamDto.getShopName());
        wxOrderRequest.setBuyerId(orderQueryParamDto.getBuyerId());
        this.logger.info("+++++++++wxOrderRequest+++={}", (Object)JSON.toJSONString((Object)wxOrderRequest));
        BaseJsonVo jsonVo = this.orderEcInvoke.getOrderList(wxOrderRequest);
        this.logger.info("===============getOrderInfoByPage======jsonVo={}", (Object)JSON.toJSONString((Object)jsonVo));
        return jsonVo;
    }

    public BaseJsonVo<List<OrderDetailInfoDto>> getOrderDetailInfo(OrderQueryParamDto orderQueryParamDto) {
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(orderQueryParamDto.getExternalOrderNo());
        return this.orderEcInvoke.getOrderDetailList(wxOrderRequest);
    }

    public BaseJsonVo getOrderProductInfo(OrderQueryParamDto orderQueryParamDto) {
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(orderQueryParamDto.getExternalOrderNo());
        return this.orderEcInvoke.getOrderProductList(wxOrderRequest);
    }

    public BaseJsonVo getProductsAll(String productType) {
        return this.orderProductInvoke.getProductsAll(productType);
    }

    public BaseJsonVo checkOrder(String externalOrderNo) {
        return this.orderInterface.checkOrder(externalOrderNo);
    }

    public BaseJsonVo editOrder(HttpServletRequest request, String editOrderParam) {
        this.logger.info("+++++++++editOrder+++editOrderParam={}", (Object)editOrderParam);
        OrderEditParamDto orderEditParamDto = (OrderEditParamDto)JSONObject.parseObject((String)editOrderParam, OrderEditParamDto.class);
        this.logger.info("+++++++++editOrder+++orderEditParamDto={}", (Object)JsonUtils.toJson((Object)orderEditParamDto, (boolean)false));
        EditOrderAddressDTO editOrderAddressDTO = new EditOrderAddressDTO();
        editOrderAddressDTO.setCustomerId(orderEditParamDto.getCustomerId());
        editOrderAddressDTO.setOrderNo(orderEditParamDto.getExternalOrderNo());
        editOrderAddressDTO.setAreaId(orderEditParamDto.getConsigneeAreaid());
        editOrderAddressDTO.setAddress(orderEditParamDto.getConsigneeAddress());
        return this.mallOrderInvoke.editOrderAddress(editOrderAddressDTO);
    }

    public BaseJsonVo editOrderDeliveryTime(HttpServletRequest request, String editOrderDeliveryTimeParam) {
        this.logger.info("+++++++++editOrderDeliveryTimeParam+++editOrderDeliveryTimeParam={}", (Object)editOrderDeliveryTimeParam);
        OrderEditParamDto orderDeliveryTimeParamDto = (OrderEditParamDto)JSONObject.parseObject((String)editOrderDeliveryTimeParam, OrderEditParamDto.class);
        this.logger.info("+++++++++editOrderDeliveryTimeParam+++orderDeliveryTimeParamDto={}", (Object)JsonUtils.toJson((Object)orderDeliveryTimeParamDto, (boolean)false));
        EditOrderAddressDTO editOrderDeliverDTO = new EditOrderAddressDTO();
        editOrderDeliverDTO.setOrderNo(orderDeliveryTimeParamDto.getExternalOrderNo());
        editOrderDeliverDTO.setCustomerId(orderDeliveryTimeParamDto.getCustomerId());
        editOrderDeliverDTO.setDeliverDate(orderDeliveryTimeParamDto.getDeliverDate());
        return this.mallOrderInvoke.editOrderDeliverDate(editOrderDeliverDTO);
    }

    public BaseJsonVo editOrderProducts(String orderNo, String oldValue, String newValue) {
        String[] newStrs;
        String[] oldStrs;
        this.logger.info("+++++++++editOrderProducts+++orderNo={},oldValue={},newValue={}", new Object[]{orderNo, oldValue, newValue});
        StringBuilder lastProduct = new StringBuilder();
        if (StringUtils.isNotEmpty((String)oldValue) && (oldStrs = oldValue.split("\\|")) != null && oldStrs.length > 0) {
            for (String oldStr : oldStrs) {
                if (!StringUtils.isNotEmpty((String)oldStr)) continue;
                String[] olds = oldStr.split(",");
                lastProduct.append(olds[0]).append(":").append(olds[2]).append(";");
            }
        }
        if (StringUtils.isNotEmpty((String)newValue) && (newStrs = newValue.split("\\|")) != null && newStrs.length > 0) {
            for (String newStr : newStrs) {
                if (!StringUtils.isNotEmpty((String)newStr)) continue;
                String[] news = newStr.split(",");
                lastProduct.append(news[0]).append(":").append(news[2]).append(";");
            }
        }
        EditOrderAddressDTO editOrderProductDeliverDTO = new EditOrderAddressDTO();
        editOrderProductDeliverDTO.setOrderNo(orderNo);
        editOrderProductDeliverDTO.setNewProductsStr(lastProduct.toString());
        this.logger.info("+++++++++editOrderProducts+++editOrderProductDeliverDTO={}", (Object)JsonUtils.toJson((Object)editOrderProductDeliverDTO, (boolean)false));
        return this.mallOrderInvoke.editOrderProducts(editOrderProductDeliverDTO);
    }
}

