/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.controller;

import cc.lechun.csmsapi.entity.user.UserInfo;
import cc.lechun.csmsapi.iservice.order.ApplyFormInterface;
import cc.lechun.csmsapi.iservice.user.UserInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/apply"})
public class ApplyFormController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ApplyFormInterface applyFormInterface;
    @Autowired
    UserInterface userInterface;

    @RequestMapping(value={"createOrderOperation"})
    @ResponseBody
    public BaseJsonVo createOrderOperation(HttpServletRequest request, String orderNo, Integer optType, String oldValue, String newValue, String deliverDateExpect) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u8ba2\u5355");
        }
        if (optType == null || optType != 1 && optType != 2 && optType != 3) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u7c7b\u578b");
        }
        if (StringUtils.isEmpty((String)newValue)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65b0\u5546\u54c1");
        }
        Date deliver = DateUtils.getDateFromString((String)deliverDateExpect, (String)"yyyy-MM-dd");
        BaseJsonVo userInfo = this.userInterface.getUserInfo(request);
        this.logger.info(JsonUtils.toJson((Object)userInfo, (boolean)false));
        if (!userInfo.isSuccess()) {
            return userInfo;
        }
        this.logger.info(JsonUtils.toJson((Object)userInfo.getValue(), (boolean)false));
        String userEmail = ((UserInfo)userInfo.getValue()).getUserName();
        this.logger.info(userEmail);
        return this.applyFormInterface.createOrderOperation(orderNo, optType, oldValue, newValue, deliver, userEmail);
    }

    @RequestMapping(value={"withdrawApply"})
    @ResponseBody
    public BaseJsonVo withdrawApply(Integer applyId) {
        if (applyId == null || applyId < 1) {
            return BaseJsonVo.error((String)"\u7533\u8bf7ID\u9519\u8bef");
        }
        return this.applyFormInterface.withdrawApply(applyId);
    }

    @RequestMapping(value={"myApplyList"})
    @ResponseBody
    public BaseJsonVo myApplyList(HttpServletRequest request, String orderNo, Integer optType, Integer pageSize, Integer currentPage) {
        if (optType == null) {
            return BaseJsonVo.error((String)"\u7c7b\u578b\u9519\u8bef");
        }
        BaseJsonVo userInfo = this.userInterface.getUserInfo(request);
        this.logger.info(JsonUtils.toJson((Object)userInfo, (boolean)false));
        if (!userInfo.isSuccess()) {
            return userInfo;
        }
        this.logger.info(JsonUtils.toJson((Object)userInfo.getValue(), (boolean)false));
        String userName = ((UserInfo)userInfo.getValue()).getUserName();
        this.logger.info(userName);
        return BaseJsonVo.success((Object)this.applyFormInterface.myApplyList(orderNo, optType, userName, pageSize, currentPage));
    }

    @RequestMapping(value={"applyList"})
    @ResponseBody
    public BaseJsonVo applyList(String orderNo, Integer optType, Integer pageSize, Integer currentPage) {
        if (optType == null) {
            return BaseJsonVo.error((String)"\u7c7b\u578b\u9519\u8bef");
        }
        return BaseJsonVo.success((Object)this.applyFormInterface.applyList(orderNo, optType, pageSize, currentPage));
    }

    @RequestMapping(value={"modifyDeliverDate"})
    @ResponseBody
    public BaseJsonVo modifyDeliverDate(Integer applyId, String deliverDate) {
        Date deliver = DateUtils.getDateFromString((String)deliverDate, (String)"yyyy-MM-dd");
        return this.applyFormInterface.modifyDeliverDate(applyId, deliver);
    }

    @RequestMapping(value={"viewApply"})
    @ResponseBody
    public BaseJsonVo viewApply(Integer applyId) {
        if (applyId == null || applyId < 1) {
            return BaseJsonVo.error((String)"\u7533\u8bf7ID\u9519\u8bef");
        }
        return this.applyFormInterface.getApply(applyId);
    }

    @RequestMapping(value={"audit"})
    @ResponseBody
    public BaseJsonVo audit(HttpServletRequest request, Integer applyId, Integer auditRst, String auditText) {
        if (applyId == null || applyId < 1) {
            return BaseJsonVo.error((String)"\u7533\u8bf7ID\u9519\u8bef");
        }
        if (auditRst == null || auditRst != 1 && auditRst != 0) {
            return BaseJsonVo.error((String)"\u5ba1\u6838\u7ed3\u679c\u9519\u8bef");
        }
        BaseJsonVo userInfo = this.userInterface.getUserInfo(request);
        this.logger.info(JsonUtils.toJson((Object)userInfo, (boolean)false));
        if (!userInfo.isSuccess()) {
            return userInfo;
        }
        String userName = ((UserInfo)userInfo.getValue()).getUserName();
        return this.applyFormInterface.audit(applyId, auditRst, auditText, userName);
    }

    @RequestMapping(value={"finishChange"})
    @ResponseBody
    public BaseJsonVo finishChange(Integer applyId) {
        if (applyId == null || applyId < 1) {
            return BaseJsonVo.error((String)"\u7533\u8bf7ID\u9519\u8bef");
        }
        return this.applyFormInterface.finishChange(applyId);
    }
}

