/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.order;

import cc.lechun.csmsapi.apiinvoke.customer.CustomerInfoInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.config.OperateTypeEnum;
import cc.lechun.csmsapi.dao.order.ApplyFormMapper;
import cc.lechun.csmsapi.dto.order.OrderAddParamDto;
import cc.lechun.csmsapi.dto.order.OrderProductParamDto;
import cc.lechun.csmsapi.entity.order.ApplyFormEntity;
import cc.lechun.csmsapi.entity.order.OperationEntity;
import cc.lechun.csmsapi.iservice.order.ApplyFormInterface;
import cc.lechun.csmsapi.iservice.order.OperationInterface;
import cc.lechun.csmsapi.iservice.order.OrderInterface;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.cache.RedisLock;
import cc.lechun.framework.common.utils.cache.RedisLockParameter;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mallapi.dto.CustomerInfoDTO;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderEntityVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplyFormService
extends BaseService<ApplyFormEntity, Integer>
implements ApplyFormInterface {
    @Resource
    private ApplyFormMapper applyFormMapper;
    @Autowired
    OperationInterface operationInterface;
    @Autowired
    OrderInterface orderInterface;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    CustomerInfoInvoke customerInfoInvoke;

    @Transactional
    public BaseJsonVo createOrderOperation(String orderNo, Integer optType, String oldValue, String newValue, Date deliverDateExpect, String userName) {
        ApplyFormEntity param = new ApplyFormEntity();
        param.setOriginOrderNo(orderNo);
        param.setOptType(optType);
        param.setFormStatus(Integer.valueOf(1));
        int exists = this.applyFormMapper.existsByEntity((Object)param);
        if (exists > 0) {
            return BaseJsonVo.error((String)("\u8be5\u8ba2\u5355\u5df2\u6709" + (optType == 1 ? "\u8865\u53d1" : (optType == 2 ? "\u6362\u8d27" : "\u6539\u5546\u54c1")) + "\u7533\u8bf7\uff0c\u987b\u5148\u64a4\u56de\u624d\u80fd\u91cd\u65b0\u7533\u8bf7"));
        }
        ApplyFormEntity apply = new ApplyFormEntity();
        apply.setOptType(optType);
        apply.setOriginOrderNo(orderNo);
        apply.setFormStatus(Integer.valueOf(1));
        apply.setCreateTime(DateUtils.now());
        apply.setCreateUserName(userName);
        this.applyFormMapper.insert((Object)apply);
        BaseJsonVo rlt = this.operationInterface.record(apply.getId(), orderNo, optType == 1 ? OperateTypeEnum.ADD_PRODUCTS : (optType == 2 ? OperateTypeEnum.CHANGE_PRODUCTS : OperateTypeEnum.EDIT_PRODUCTS), oldValue, newValue, deliverDateExpect, userName);
        if (!rlt.isSuccess()) {
            throw new RuntimeException(rlt.getError_msg());
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    public BaseJsonVo withdrawApply(Integer applyId) {
        ApplyFormEntity apply = new ApplyFormEntity();
        apply.setId(applyId);
        apply.setFormStatus(Integer.valueOf(0));
        int rst = this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
        return rst > 0 ? BaseJsonVo.success((Object)"\u64a4\u56de\u6210\u529f") : BaseJsonVo.error((String)"\u64a4\u56de\u5931\u8d25");
    }

    public PageInfo<Map<String, Object>> myApplyList(String orderNo, Integer optType, String userName, Integer pageSize, Integer currentPage) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.applyFormMapper.findApplyList(userName, optType, null, orderNo);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(apply -> {
            String[] newStrs;
            String newValue;
            String[] oldStrs;
            String oldValue;
            apply.put("id", apply.get("ID"));
            apply.put("optType", apply.get("OPT_TYPE"));
            apply.put("optType1", apply.get("OPT_TYPE"));
            apply.put("originOrderNo", apply.get("ORIGIN_ORDER_NO"));
            apply.put("newOrderNo", apply.get("NEW_ORDER_NO"));
            apply.put("formStatus", apply.get("FORM_STATUS"));
            apply.put("createUserName", apply.get("CREATE_USER_NAME"));
            apply.put("createTime", apply.get("CREATE_TIME"));
            apply.put("auditTime", apply.get("AUDIT_TIME"));
            apply.put("auditUser", apply.get("AUDIT_USER"));
            apply.put("deliverDate", apply.get("DELIVER_DATE"));
            String string = oldValue = apply.get("OLD_VALUE") == null ? "" : (String)apply.get("OLD_VALUE");
            if (StringUtils.isNotEmpty((String)oldValue) && (oldStrs = oldValue.split("\\|")) != null && oldStrs.length > 0) {
                StringBuilder lastOld = new StringBuilder();
                for (String oldStr : oldStrs) {
                    if (!StringUtils.isNotEmpty((String)oldStr)) continue;
                    String[] olds = oldStr.split(",");
                    lastOld.append(olds[1]).append(" * ").append(olds[2]).append(",");
                }
                apply.put("oldValue", lastOld.toString());
            }
            String string2 = newValue = apply.get("NEW_VALUE") == null ? "" : (String)apply.get("NEW_VALUE");
            if (StringUtils.isNotEmpty((String)newValue) && (newStrs = newValue.split("\\|")) != null && newStrs.length > 0) {
                StringBuilder lastNew = new StringBuilder();
                for (String newStr : newStrs) {
                    if (!StringUtils.isNotEmpty((String)newStr)) continue;
                    String[] news = newStr.split(",");
                    lastNew.append(news[1]).append(" * ").append(news[2]).append(",");
                }
                apply.put("newValue", lastNew.toString());
            }
        });
        return pg;
    }

    public PageInfo<Map<String, Object>> applyList(String orderNo, Integer optType, Integer pageSize, Integer currentPage) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        this.applyFormMapper.findApplyList(null, optType, Integer.valueOf(1), orderNo);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(apply -> {
            String[] newStrs;
            String newValue;
            String[] oldStrs;
            String oldValue;
            apply.put("id", apply.get("ID"));
            apply.put("optType", apply.get("OPT_TYPE"));
            apply.put("originOrderNo", apply.get("ORIGIN_ORDER_NO"));
            apply.put("newOrderNo", apply.get("NEW_ORDER_NO"));
            apply.put("formStatus", apply.get("FORM_STATUS"));
            apply.put("createUserName", apply.get("CREATE_USER_NAME"));
            apply.put("createTime", apply.get("CREATE_TIME"));
            apply.put("auditTime", apply.get("AUDIT_TIME"));
            apply.put("auditUser", apply.get("AUDIT_USER"));
            apply.put("deliverDate", apply.get("DELIVER_DATE"));
            String string = oldValue = apply.get("OLD_VALUE") == null ? "" : (String)apply.get("OLD_VALUE");
            if (StringUtils.isNotEmpty((String)oldValue) && (oldStrs = oldValue.split("\\|")) != null && oldStrs.length > 0) {
                StringBuilder lastOld = new StringBuilder();
                for (String oldStr : oldStrs) {
                    if (!StringUtils.isNotEmpty((String)oldStr)) continue;
                    String[] olds = oldStr.split(",");
                    lastOld.append(olds[1]).append(" * ").append(olds[2]).append(",");
                }
                apply.put("oldValue", lastOld.toString());
            }
            String string2 = newValue = apply.get("NEW_VALUE") == null ? "" : (String)apply.get("NEW_VALUE");
            if (StringUtils.isNotEmpty((String)newValue) && (newStrs = newValue.split("\\|")) != null && newStrs.length > 0) {
                StringBuilder lastNew = new StringBuilder();
                for (String newStr : newStrs) {
                    if (!StringUtils.isNotEmpty((String)newStr)) continue;
                    String[] news = newStr.split(",");
                    lastNew.append(news[1]).append(" * ").append(news[2]).append(",");
                }
                apply.put("newValue", lastNew.toString());
            }
        });
        return pg;
    }

    public BaseJsonVo getApply(Integer applyId) {
        return BaseJsonVo.success((Object)this.applyFormMapper.selectByPrimaryKey((Serializable)applyId));
    }

    @RedisLock(key="APPLY_HANDLE", expire=7L, waitTime=60L)
    public BaseJsonVo audit(@RedisLockParameter Integer applyId, Integer auditRst, String auditText, String userName) {
        ApplyFormEntity apply = (ApplyFormEntity)this.applyFormMapper.selectByPrimaryKey((Serializable)applyId);
        if (apply.getFormStatus() != 1) {
            return BaseJsonVo.error((String)"\u7533\u8bf7\u5355\u5f53\u524d\u72b6\u6001\u9519\u8bef");
        }
        apply.setFormStatus(Integer.valueOf(auditRst == 0 ? 3 : 2));
        apply.setAuditTime(DateUtils.now());
        apply.setAuditUser(userName);
        apply.setAuditText(auditText);
        if (apply.getFormStatus() == 3) {
            this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
            return BaseJsonVo.success((Object)"\u9a73\u56de\u6210\u529f");
        }
        if (apply.getOptType() == 1) {
            BaseJsonVo createOrderRst = this.buildOrder(applyId);
            if (createOrderRst.isSuccess()) {
                this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
            }
            return createOrderRst;
        }
        this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
        return BaseJsonVo.success((Object)"\u5ba1\u6279\u6210\u529f");
    }

    public BaseJsonVo finishChange(Integer applyId) {
        ApplyFormEntity apply = (ApplyFormEntity)this.applyFormMapper.selectByPrimaryKey((Serializable)applyId);
        OperationEntity param = new OperationEntity();
        param.setExtraId(applyId);
        List ops = this.operationInterface.getList((Object)param);
        if (ops == null || ops.size() == 0) {
            return BaseJsonVo.error((String)"\u8865\u6362\u8d27\u64cd\u4f5c\u8bb0\u5f55\u4e22\u5931");
        }
        BaseJsonVo refundRst = this.buildRefund(applyId);
        if (!refundRst.isSuccess()) {
            return refundRst;
        }
        BaseJsonVo buildRst = this.buildOrder(applyId);
        if (!buildRst.isSuccess()) {
            return buildRst;
        }
        WxOrderEntityVO newOrder = (WxOrderEntityVO)buildRst.getValue();
        String orderNo = newOrder.getExternalOrderNo();
        apply.setNewOrderNo(orderNo);
        int rst = this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
        return rst > 0 ? BaseJsonVo.success((Object)"\u64cd\u4f5c\u6210\u529f") : BaseJsonVo.error((String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private BaseJsonVo buildOrder(Integer applyId) {
        ApplyFormEntity apply = (ApplyFormEntity)this.applyFormMapper.selectByPrimaryKey((Serializable)applyId);
        OperationEntity param = new OperationEntity();
        param.setExtraId(applyId);
        List opts = this.operationInterface.getList((Object)param);
        if (opts == null || opts.size() == 0) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u8be2\u5230\u8865\u53d1\u8d27\u64cd\u4f5c\u8bb0\u5f55");
        }
        String newValue = ((OperationEntity)opts.get(0)).getNewValue();
        if (StringUtils.isEmpty((String)newValue)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u8be2\u5230\u8865\u53d1\u8d27\u5546\u54c1");
        }
        String[] proStrs = newValue.split("\\|");
        ArrayList<OrderProductParamDto> proList = new ArrayList<OrderProductParamDto>();
        for (String proStr : proStrs) {
            if (StringUtils.isEmpty((String)proStr)) continue;
            String[] pros = proStr.split(",");
            this.logger.info("pros:" + JsonUtils.toJson((Object)pros, (boolean)false));
            if (pros == null || pros.length != 4) continue;
            OrderProductParamDto dto = new OrderProductParamDto();
            dto.setProductId(pros[0]);
            dto.setProductName(pros[1]);
            dto.setProductNum(new BigDecimal(pros[2]));
            dto.setIsPromotion(Integer.valueOf(pros[3]) - 1);
            proList.add(dto);
        }
        OrderAddParamDto dto = new OrderAddParamDto();
        dto.setDeliveryTime(((OperationEntity)opts.get(0)).getDeliverDate() == null ? DateUtils.getAddDateByDay((Date)new Date(), (int)7) : ((OperationEntity)opts.get(0)).getDeliverDate());
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setPage(Integer.valueOf(1));
        wxOrderRequest.setRows(Integer.valueOf(15));
        wxOrderRequest.setExternalOrderNo(apply.getOriginOrderNo());
        BaseJsonVo orderRst = this.orderEcInvoke.getOrderList(wxOrderRequest);
        if (!orderRst.isSuccess()) {
            return orderRst;
        }
        this.logger.info("orderRst : " + JsonUtils.toJson((Object)orderRst, (boolean)false));
        JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderRst.getValue()), JqGridData.class);
        List objs = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
        if (objs == null || objs.isEmpty()) {
            return BaseJsonVo.error((String)"\u539f\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OriginOrderVO obj = (OriginOrderVO)objs.get(0);
        this.logger.info("\u539f\u8ba2\u5355\u6570\u636e\uff1a" + JsonUtils.toJson((Object)obj, (boolean)false));
        dto.setConsigneeName(obj.getConsigneeName());
        dto.setConsigneeMobile(obj.getConsigneeMobile());
        dto.setConsigneeAddress(obj.getConsigneeAddress());
        dto.setConsigneeProvince(obj.getConsigneeProvince());
        dto.setConsigneeCity(obj.getConsigneeCity());
        dto.setConsigneeArea(obj.getConsigneeArea());
        dto.setConsigneeAreaid(obj.getConsigneeAreaid());
        dto.setBuyerId(obj.getBuyerId());
        if (apply.getOptType().intValue() == OperateTypeEnum.ADD_PRODUCTS.getValue()) {
            dto.setOrderSonType(Integer.valueOf(3));
        } else if (apply.getOptType().intValue() == OperateTypeEnum.CHANGE_PRODUCTS.getValue()) {
            dto.setOrderSonType(Integer.valueOf(4));
        }
        BaseJsonVo customerInfo = this.customerInfoInvoke.getCustomerInfoByID(obj.getBuyerId());
        this.logger.info("customerInfo:" + JsonUtils.toJson((Object)customerInfo, (boolean)false));
        if (customerInfo.isSuccess()) {
            dto.setBuyerNickName(((CustomerInfoDTO)customerInfo.getValue()).getNickName());
        }
        dto.setConsigneeRemark(obj.getConsigneeRemark());
        dto.setRemark(apply.getReason());
        dto.setOrderProductParamDtoList(proList);
        dto.setOrderCreateMethod(Integer.valueOf(2));
        dto.setOrderStatus(Integer.valueOf(OrderStatusEnum.PAYCONFIRM.getValue()));
        this.logger.info("\u4e0b\u5355\u53c2\u6570\uff1a" + JsonUtils.toJson((Object)dto, (boolean)false));
        BaseJsonVo createRst = this.orderInterface.createOrder(dto);
        this.logger.info("\u521b\u5efa\u8ba2\u5355\u7684\u8fd4\u56de\u503c\uff1a" + JsonUtils.toJson((Object)createRst, (boolean)false));
        if (createRst.isSuccess()) {
            apply.setNewOrderNo(((WxOrderEntityVO)createRst.getValue()).getExternalOrderNo());
            this.applyFormMapper.updateByPrimaryKeySelective((Object)apply);
        }
        return createRst;
    }

    private BaseJsonVo buildRefund(Integer applyId) {
        return BaseJsonVo.success(null);
    }

    public BaseJsonVo modifyDeliverDate(Integer applyId, Date deliverDate) {
        ApplyFormEntity apply = (ApplyFormEntity)this.applyFormMapper.selectByPrimaryKey((Serializable)applyId);
        OperationEntity param = new OperationEntity();
        param.setExtraId(applyId);
        List opts = this.operationInterface.getList((Object)param);
        if (opts == null || opts.size() == 0) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u67e5\u8be2\u5230\u8865\u53d1\u8d27\u64cd\u4f5c\u8bb0\u5f55");
        }
        ((OperationEntity)opts.get(0)).setDeliverDate(deliverDate);
        int i = this.operationInterface.updateByPrimaryKey(opts.get(0));
        return i > 0 ? BaseJsonVo.success(null) : BaseJsonVo.error((String)"\u4fee\u6539\u5931\u8d25");
    }
}

