/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.order;

import cc.lechun.cms.dto.MallProductResInfoDto;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderProductInvoke;
import cc.lechun.csmsapi.iservice.order.OrderSaleInventoryErpInterface;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.omsv2.entity.order.origin.OriginOrderProductEntity;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderSaleInventoryErpService
extends BaseService
implements OrderSaleInventoryErpInterface {
    @Autowired
    private OrderProductInvoke orderProductInvoke;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Value(value="${erp.addInventory.url}")
    private String addInventoryUrl;

    public String checkOrderSaleCold(List<OriginOrderVO> originOrderVOList) {
        String message = null;
        if (originOrderVOList != null && originOrderVOList.size() > 0) {
            ArrayList object = new ArrayList();
            boolean cold = false;
            for (OriginOrderVO originOrderVO : originOrderVOList) {
                WxOrderRequest wxOrderRequestProduct = new WxOrderRequest();
                wxOrderRequestProduct.setExternalOrderNo(originOrderVO.getExternalOrderNo());
                BaseJsonVo orderProductListJson = this.orderEcInvoke.getOrderProductList(wxOrderRequestProduct);
                if (!orderProductListJson.isSuccess()) continue;
                List omsEcOrderProductEntityList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderProductListJson.getValue())).toJavaList(OriginOrderProductEntity.class);
                for (OriginOrderProductEntity ordereProductVo : omsEcOrderProductEntityList) {
                    HashMap<String, Object> mapCold = new HashMap<String, Object>();
                    int transportType = originOrderVO.getOrderIsCw();
                    if (transportType != 1) continue;
                    cold = true;
                    mapCold.put("orderid", originOrderVO.getExternalOrderNo());
                    mapCold.put("cbarcode", ordereProductVo.getProductCbarcode());
                    mapCold.put("proId", ordereProductVo.getProductId());
                    mapCold.put("storeid", ordereProductVo.getStoreId());
                    mapCold.put("bctid", "");
                    mapCold.put("pickupdate", ordereProductVo.getPickupTime());
                    mapCold.put("occupynum", ordereProductVo.getProductNum());
                    int deliverSequence = originOrderVO.getPsTims();
                    if (deliverSequence == 1) {
                        mapCold.put("ifCheckStore", "1");
                    } else {
                        mapCold.put("ifCheckStore", "0");
                    }
                    if (!mapCold.containsKey("ifCheckStore")) {
                        mapCold.put("ifCheckStore", "0");
                    }
                    object.add(mapCold);
                }
            }
            boolean success = true;
            int status = 200;
            JSONObject jsonObjectCold = null;
            if (cold) {
                String resultCold = "";
                resultCold = HttpRequest.httpsPostByDeliver((String)this.addInventoryUrl, (String)JsonUtils.toJson(object, (boolean)false));
                this.logger.info("*************************orderSaleCold\u51b7\u94fe\u8c03\u7528erp******\u8c03\u7528ERP3.0\u6263\u51cf\u5e93\u5b58\u8bf7\u6c42\u548c\u8fd4\u56de\u7684\u6570\u636e*************object={},resultCold={}", (Object)JSON.toJSONString(object), (Object)JSON.toJSONString((Object)resultCold));
                jsonObjectCold = JSON.parseObject((String)resultCold);
                this.logger.info("*************************orderSaleCold***********jsonObjectCold************jsonObjectCold={}", (Object)jsonObjectCold);
                status = (Integer)jsonObjectCold.get((Object)"status");
                TreeSet<String> proNameSet = new TreeSet<String>();
                if (status == 200) {
                    success = (Boolean)jsonObjectCold.get((Object)"success");
                    if (success) {
                        StringBuffer sb = new StringBuffer();
                        JSONArray jsonArrayColdResult = (JSONArray)jsonObjectCold.get((Object)"value");
                        Iterator itCold = jsonArrayColdResult.iterator();
                        boolean canIfSellCold = true;
                        int m = 0;
                        while (itCold.hasNext()) {
                            JSONObject ob = (JSONObject)itCold.next();
                            canIfSellCold = ob.getBoolean("canIfSell");
                            this.logger.info("-----------------------buildOrder----canIfSellCold-------------canIfSellCold={}", (Object)canIfSellCold);
                            if (canIfSellCold) continue;
                            ++m;
                            String cbarcode = ob.getString("cbarcode");
                            String proId = ob.getString("proId");
                            BaseJsonVo orderProductJson = this.orderProductInvoke.getProductInfoById(proId);
                            this.logger.info("=========checkOrderSaleCold orderProductJson============orderProductJson={}", (Object)JSON.toJSONString((Object)orderProductJson));
                            if (orderProductJson.isSuccess()) {
                                MallProductResInfoDto mallProductResInfoDto = (MallProductResInfoDto)orderProductJson.getValue();
                                String proName = mallProductResInfoDto.getProName();
                                sb.append(proName).append(",");
                                proNameSet.add(proName);
                                continue;
                            }
                            message = "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3";
                            return message;
                        }
                        if (m > 0) {
                            canIfSellCold = false;
                        }
                        StringBuffer sbProName = new StringBuffer();
                        for (String value : proNameSet) {
                            sbProName.append(value).append(",");
                        }
                        String proNameStr = sbProName.toString();
                        if (!canIfSellCold) {
                            message = "\u5546\u54c1 " + proNameStr.substring(0, proNameStr.length() - 1) + " \u5e93\u5b58\u4e0d\u8db3";
                            return message;
                        }
                    }
                } else {
                    message = status == 405 ? "\u5546\u54c1\u5df2\u552e\u7f44" : "\u5546\u54c1\u5df2\u552e\u7f44\uff0c\u8bf7\u7a0d\u540e";
                }
            }
        }
        return message;
    }

    public String checkOrderSaleNomal(List<OriginOrderVO> originOrderVOList) {
        String message = null;
        if (originOrderVOList != null && originOrderVOList.size() > 0) {
            List omsEcOrderProductEntityList = null;
            ArrayList object = new ArrayList();
            boolean nomal = false;
            for (OriginOrderVO originOrderVO : originOrderVOList) {
                WxOrderRequest wxOrderRequestProduct = new WxOrderRequest();
                wxOrderRequestProduct.setExternalOrderNo(originOrderVO.getExternalOrderNo());
                BaseJsonVo orderProductListJson = this.orderEcInvoke.getOrderProductList(wxOrderRequestProduct);
                if (!orderProductListJson.isSuccess()) continue;
                omsEcOrderProductEntityList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderProductListJson.getValue())).toJavaList(OriginOrderProductEntity.class);
                for (OriginOrderProductEntity ordereProductVo : omsEcOrderProductEntityList) {
                    HashMap<String, Object> mapNomal = new HashMap<String, Object>();
                    int transportType = originOrderVO.getOrderIsCw();
                    if (transportType != 2) continue;
                    nomal = true;
                    mapNomal.put("orderid", originOrderVO.getExternalOrderNo());
                    mapNomal.put("cbarcode", ordereProductVo.getProductCbarcode());
                    mapNomal.put("proId", ordereProductVo.getProductId());
                    mapNomal.put("storeid", originOrderVO.getStoreId());
                    mapNomal.put("bctid", "");
                    mapNomal.put("pickupdate", originOrderVO.getPickupTime());
                    mapNomal.put("occupynum", ordereProductVo.getProductNum());
                    int deliverSequence = originOrderVO.getPsTims();
                    if (deliverSequence == 1) {
                        mapNomal.put("ifCheckStore", "1");
                    } else {
                        mapNomal.put("ifCheckStore", "0");
                    }
                    if (!mapNomal.containsKey("ifCheckStore")) {
                        mapNomal.put("ifCheckStore", "0");
                    }
                    object.add(mapNomal);
                }
            }
            boolean success = true;
            int status = 200;
            JSONObject jsonObjectNomal = null;
            if (nomal) {
                String resultNomal = "";
                resultNomal = HttpRequest.httpsPostByDeliver((String)this.addInventoryUrl, (String)JsonUtils.toJson(object, (boolean)false));
                this.logger.info("*************************buildOrder\u5e38\u6e29\u8c03\u7528erp********************\u8c03\u7528ERP3.0\u6263\u51cf\u5e93\u5b58\u8bf7\u6c42\u548c\u8fd4\u56de\u7684\u6570\u636e************object={},resultNom={}", (Object)JSON.toJSONString(object), (Object)JSON.toJSONString((Object)resultNomal));
                jsonObjectNomal = JSON.parseObject((String)resultNomal);
                this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObjectNomal);
                status = (Integer)jsonObjectNomal.get((Object)"status");
                TreeSet<String> proNameSet = new TreeSet<String>();
                if (status == 200) {
                    success = (Boolean)jsonObjectNomal.get((Object)"success");
                    if (success) {
                        StringBuffer sb = new StringBuffer();
                        JSONArray jsonArrayNomalResult = (JSONArray)jsonObjectNomal.get((Object)"value");
                        Iterator itNomal = jsonArrayNomalResult.iterator();
                        boolean canIfSellNomal = true;
                        int m = 0;
                        while (itNomal.hasNext()) {
                            JSONObject ob = (JSONObject)itNomal.next();
                            canIfSellNomal = ob.getBoolean("canIfSell");
                            this.logger.info("-----------------------buildOrder----canIfSellNomal-------------canIfSellNomal={}", (Object)canIfSellNomal);
                            if (canIfSellNomal) continue;
                            ++m;
                            String cbarcode = ob.getString("cbarcode");
                            String proId = ob.getString("proId");
                            BaseJsonVo orderProductJson = this.orderProductInvoke.getProductInfoById(proId);
                            this.logger.info("=========checkOrderSaleCold orderProductJson============orderProductJson={}", (Object)JSON.toJSONString((Object)orderProductJson));
                            if (orderProductJson.isSuccess()) {
                                MallProductResInfoDto mallProductResInfoDto = (MallProductResInfoDto)orderProductJson.getValue();
                                String proName = mallProductResInfoDto.getProName();
                                sb.append(proName).append(",");
                                proNameSet.add(proName);
                                continue;
                            }
                            message = "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3";
                            return message;
                        }
                        if (m > 0) {
                            canIfSellNomal = false;
                        }
                        StringBuffer sbProName = new StringBuffer();
                        for (String value : proNameSet) {
                            sbProName.append(value).append(",");
                        }
                        String proNameStr = sbProName.toString();
                        if (!canIfSellNomal) {
                            message = "\u5546\u54c1 " + proNameStr.substring(0, proNameStr.length() - 1) + " \u5e93\u5b58\u4e0d\u8db3";
                            return message;
                        }
                    }
                } else {
                    message = status == 405 ? "\u5546\u54c1\u5df2\u552e\u7f44" : "\u5546\u54c1\u5df2\u552e\u7f44\uff0c\u8bf7\u7a0d\u540e";
                }
            }
        }
        return message;
    }
}

