/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.order;

import cc.lechun.cms.dto.MallProductResInfoDto;
import cc.lechun.csmsapi.apiinvoke.customer.CustomerInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderProductInvoke;
import cc.lechun.csmsapi.dto.order.OrderAddParamDto;
import cc.lechun.csmsapi.dto.order.OrderProductParamDto;
import cc.lechun.csmsapi.dto.refund.RefundParamDto;
import cc.lechun.csmsapi.dto.refund.RefundProductParamDto;
import cc.lechun.csmsapi.entity.order.OrderResEntity;
import cc.lechun.csmsapi.enums.order.OrderSourceEnum;
import cc.lechun.csmsapi.iservice.order.OrderInterface;
import cc.lechun.csmsapi.iservice.order.OrderSaleInventoryErpInterface;
import cc.lechun.csmsapi.vo.order.CustomerAddressVo;
import cc.lechun.csmsapi.vo.order.DeliverDateVo;
import cc.lechun.csmsapi.vo.order.DeliverEntity;
import cc.lechun.csmsapi.vo.order.DeliverProductVo;
import cc.lechun.csmsapi.vo.order.DeliverSoldProductVo;
import cc.lechun.csmsapi.vo.order.DeliverVo;
import cc.lechun.csmsapi.vo.order.GroupProductEntity;
import cc.lechun.csmsapi.vo.order.MallProductVO;
import cc.lechun.csmsapi.vo.order.MallShoppingcartVO;
import cc.lechun.csmsapi.vo.order.ProductFormVo;
import cc.lechun.customers.dto.customer.AreaCityProvinceResVo;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.OrderNoUtils;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.omsv2.entity.order.origin.OriginOrderProductEntity;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderDetailVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderEntityVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderProductVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderService
extends BaseService<OrderResEntity, String>
implements OrderInterface {
    @Autowired
    private OrderProductInvoke orderProductInvoke;
    @Autowired
    private CustomerInvoke customerInvoke;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    private OrderSaleInventoryErpInterface orderSaleInventoryErpInterface;
    @Value(value="${erp.orderDeliver.url}")
    private String orderDeliverUrl;
    @Value(value="${erp.addInventory.url}")
    private String addInventoryUrl;

    public BaseJsonVo createOrder(String orderParam) {
        OrderAddParamDto orderAddParamDto = (OrderAddParamDto)JSONObject.parseObject((String)orderParam, OrderAddParamDto.class);
        return this.createOrder(orderAddParamDto);
    }

    public BaseJsonVo createOrder(OrderAddParamDto orderAddParamDto) {
        WxOrderEntityVO wxOrderEntityVO = new WxOrderEntityVO();
        BaseJsonVo baseJsonVo = this.customerInvoke.getAddressByParam(orderAddParamDto.getConsigneeAreaid());
        if (baseJsonVo.isSuccess()) {
            AreaCityProvinceResVo areaCityProvinceResVo = (AreaCityProvinceResVo)baseJsonVo.getValue();
            wxOrderEntityVO.setExternalOrderNo(OrderNoUtils.getInstance().create());
            wxOrderEntityVO.setOrderMainNo(OrderNoUtils.getInstance().create());
            wxOrderEntityVO.setExternalMainOrderNo(OrderNoUtils.getInstance().create());
            wxOrderEntityVO.setBuyerId(orderAddParamDto.getBuyerId());
            wxOrderEntityVO.setConsigneeName(orderAddParamDto.getConsigneeName());
            wxOrderEntityVO.setConsigneeArea(areaCityProvinceResVo.getAreaName());
            wxOrderEntityVO.setConsigneeCity(areaCityProvinceResVo.getCityName());
            wxOrderEntityVO.setConsigneeProvince(areaCityProvinceResVo.getProvinceName());
            wxOrderEntityVO.setConsigneeMobile(orderAddParamDto.getConsigneeMobile());
            wxOrderEntityVO.setConsigneeAddress(orderAddParamDto.getConsigneeAddress());
            wxOrderEntityVO.setCreatedTime(new Date());
            wxOrderEntityVO.setConsigneeAreaid(orderAddParamDto.getConsigneeAreaid());
            wxOrderEntityVO.setDeliveryTime(orderAddParamDto.getDeliveryTime());
            wxOrderEntityVO.setConsigneeRemark(orderAddParamDto.getConsigneeRemark());
            wxOrderEntityVO.setRemark(orderAddParamDto.getRemark());
            wxOrderEntityVO.setAddressType(Integer.valueOf(1));
            wxOrderEntityVO.setOrderSource(Integer.valueOf(0));
            wxOrderEntityVO.setPsTims(Integer.valueOf(1));
            wxOrderEntityVO.setExternalOrderStatus(orderAddParamDto.getOrderStatus() == null ? "1" : String.valueOf(orderAddParamDto.getOrderStatus()));
            wxOrderEntityVO.setShopId("1325743461067264000");
            wxOrderEntityVO.setOrderCreateMethod(orderAddParamDto.getOrderCreateMethod());
            ArrayList<WxOrderDetailVO> wxOrderDetailVOList = new ArrayList<WxOrderDetailVO>();
            ArrayList<WxOrderProductVO> wxOrderProductVOList = new ArrayList<WxOrderProductVO>();
            int transportType = 2;
            MallShoppingcartVO shoppingcartVO = new MallShoppingcartVO();
            ArrayList<MallProductVO> productsPool = new ArrayList<MallProductVO>();
            BigDecimal totalAmount = new BigDecimal("0");
            BigDecimal payAmount = new BigDecimal("0");
            BigDecimal cashAmount = new BigDecimal("0");
            for (OrderProductParamDto orderProductParamDto : orderAddParamDto.getOrderProductParamDtoList()) {
                List mallProductResInfoDtoList;
                MallProductVO mallProductVO = new MallProductVO();
                if (orderProductParamDto.getIsPromotion() == 0) {
                    BaseJsonVo orderProductJson = this.orderProductInvoke.getProductInfoById(orderProductParamDto.getProductId());
                    this.logger.info("=========orderProductJson============orderProductJson={}", (Object)JSON.toJSONString((Object)orderProductJson));
                    if (!orderProductJson.isSuccess()) continue;
                    String uuId = IDGenerate.getUniqueIdStr();
                    MallProductResInfoDto mallProductResInfoDto = (MallProductResInfoDto)orderProductJson.getValue();
                    WxOrderProductVO wxOrderProductVO2 = new WxOrderProductVO();
                    wxOrderProductVO2.setDetailId(uuId);
                    wxOrderProductVO2.setExternalOrderNo(wxOrderEntityVO.getExternalOrderNo());
                    wxOrderProductVO2.setExternalMainOrderNo(wxOrderEntityVO.getExternalMainOrderNo());
                    wxOrderProductVO2.setExternalMainOrderStatus(wxOrderEntityVO.getExternalOrderStatus());
                    wxOrderProductVO2.setProductId(orderProductParamDto.getProductId());
                    wxOrderProductVO2.setProductName(mallProductResInfoDto.getProName());
                    wxOrderProductVO2.setProductNum(orderProductParamDto.getProductNum());
                    if (mallProductResInfoDto.getTransportType() == 3) {
                        wxOrderProductVO2.setProductType(Integer.valueOf(2));
                    } else {
                        wxOrderProductVO2.setProductType(Integer.valueOf(3));
                    }
                    wxOrderProductVO2.setDeliveryTime(orderAddParamDto.getDeliveryTime());
                    wxOrderProductVO2.setProductIsGift(Integer.valueOf(1));
                    wxOrderProductVO2.setProductCode(mallProductResInfoDto.getProId());
                    wxOrderProductVO2.setProductCbarcode(mallProductResInfoDto.getBarCode());
                    wxOrderProductVO2.setProductPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderProductVO2.setProductAmount(wxOrderProductVO2.getProductPrice().multiply(wxOrderProductVO2.getProductNum()).setScale(6));
                    wxOrderProductVO2.setProductSellPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderProductVO2.setProductSellAmount(wxOrderProductVO2.getProductPrice().multiply(wxOrderProductVO2.getProductNum()).setScale(6));
                    wxOrderProductVO2.setPayBalancePerAmount(new BigDecimal("0"));
                    wxOrderProductVO2.setCashAmount(wxOrderProductVO2.getProductSellAmount());
                    wxOrderProductVO2.setPayType(Integer.valueOf(-1));
                    totalAmount = totalAmount.add(wxOrderProductVO2.getProductSellAmount());
                    payAmount = payAmount.add(wxOrderProductVO2.getProductSellAmount());
                    cashAmount = cashAmount.add(wxOrderProductVO2.getProductSellAmount());
                    wxOrderProductVO2.setCustomerId(orderAddParamDto.getBuyerId());
                    wxOrderProductVO2.setPickupTime(new Date());
                    wxOrderProductVO2.setIsPromotion(Integer.valueOf(2));
                    if (mallProductResInfoDto.getProTypeId() != 10) {
                        wxOrderProductVO2.setProductIsGift(Integer.valueOf(2));
                    }
                    wxOrderProductVOList.add(wxOrderProductVO2);
                    WxOrderDetailVO wxOrderDetailVO2 = new WxOrderDetailVO();
                    wxOrderDetailVO2.setCguid(uuId);
                    wxOrderDetailVO2.setExternalOrderNo(wxOrderEntityVO.getExternalOrderNo());
                    wxOrderDetailVO2.setExternalMainOrderNo(wxOrderEntityVO.getExternalMainOrderNo());
                    wxOrderDetailVO2.setExternalMainOrderStatus(wxOrderEntityVO.getExternalOrderStatus());
                    wxOrderDetailVO2.setProductId(orderProductParamDto.getProductId());
                    wxOrderDetailVO2.setProductName(mallProductResInfoDto.getProName());
                    wxOrderDetailVO2.setProductNum(orderProductParamDto.getProductNum());
                    if (mallProductResInfoDto.getTransportType() == 3) {
                        wxOrderDetailVO2.setProductType(Integer.valueOf(2));
                    } else {
                        wxOrderDetailVO2.setProductType(Integer.valueOf(3));
                    }
                    wxOrderDetailVO2.setDeliveryTime(orderAddParamDto.getDeliveryTime());
                    wxOrderDetailVO2.setProductIsGift(Integer.valueOf(1));
                    wxOrderDetailVO2.setProductCode(mallProductResInfoDto.getProId());
                    wxOrderDetailVO2.setProductCbarcode(mallProductResInfoDto.getBarCode());
                    wxOrderDetailVO2.setProductPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderDetailVO2.setProductAmount(wxOrderProductVO2.getProductPrice().multiply(wxOrderProductVO2.getProductNum()).setScale(6));
                    wxOrderDetailVO2.setProductSellPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderDetailVO2.setProductSellAmount(wxOrderProductVO2.getProductPrice().multiply(wxOrderProductVO2.getProductNum()).setScale(6));
                    wxOrderDetailVO2.setPayBalancePerAmount(new BigDecimal("0"));
                    wxOrderDetailVO2.setCashAmount(wxOrderDetailVO2.getProductSellAmount());
                    wxOrderDetailVO2.setPayType(Integer.valueOf(-1));
                    wxOrderDetailVO2.setCustomerId(orderAddParamDto.getBuyerId());
                    wxOrderDetailVO2.setPickupTime(new Date());
                    wxOrderDetailVO2.setIsPromotion(Integer.valueOf(2));
                    if (mallProductResInfoDto.getProTypeId() != 10) {
                        wxOrderDetailVO2.setProductIsGift(Integer.valueOf(2));
                    }
                    wxOrderDetailVOList.add(wxOrderDetailVO2);
                    if (mallProductResInfoDto.getTransportType() == 1) {
                        transportType = 1;
                    }
                    mallProductVO.setBarCode(mallProductResInfoDto.getBarCode());
                    mallProductVO.setCount(Integer.valueOf(wxOrderProductVO2.getProductNum().intValue()));
                    mallProductVO.setProId(mallProductResInfoDto.getProId());
                    mallProductVO.setProName(mallProductResInfoDto.getProName());
                    mallProductVO.setPromotionId("");
                    mallProductVO.setPromotionName("");
                    productsPool.add(mallProductVO);
                    continue;
                }
                BaseJsonVo orderProductListJson = this.orderProductInvoke.getPromotionInfoById(orderProductParamDto.getProductId(), orderProductParamDto.getProductNum().intValue());
                this.logger.info("=========orderProductListJson============orderProductListJson={}", (Object)JSON.toJSONString((Object)orderProductListJson));
                if (!orderProductListJson.isSuccess() || (mallProductResInfoDtoList = (List)orderProductListJson.getValue()) == null || mallProductResInfoDtoList.size() <= 0) continue;
                for (MallProductResInfoDto mallProductResInfoDto : mallProductResInfoDtoList) {
                    WxOrderProductVO wxOrderProductVO3 = new WxOrderProductVO();
                    wxOrderProductVO3.setExternalOrderNo(wxOrderEntityVO.getExternalOrderNo());
                    wxOrderProductVO3.setExternalMainOrderNo(wxOrderEntityVO.getExternalMainOrderNo());
                    wxOrderProductVO3.setExternalMainOrderStatus(wxOrderEntityVO.getExternalOrderStatus());
                    wxOrderProductVO3.setProductId(mallProductResInfoDto.getProId());
                    wxOrderProductVO3.setProductName(mallProductResInfoDto.getProName());
                    wxOrderProductVO3.setProductNum(new BigDecimal(mallProductResInfoDto.getProNum()));
                    wxOrderProductVO3.setProductType(Integer.valueOf(1));
                    wxOrderProductVO3.setDeliveryTime(orderAddParamDto.getDeliveryTime());
                    wxOrderProductVO3.setProductIsGift(Integer.valueOf(1));
                    wxOrderProductVO3.setProductCbarcode(mallProductResInfoDto.getGroupId());
                    wxOrderProductVO3.setProductPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderProductVO3.setProductAmount(wxOrderProductVO3.getProductPrice().multiply(wxOrderProductVO3.getProductNum()).setScale(6));
                    wxOrderProductVO3.setProductSellPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderProductVO3.setProductSellAmount(wxOrderProductVO3.getProductPrice().multiply(wxOrderProductVO3.getProductNum()).setScale(6));
                    wxOrderProductVO3.setPayBalancePerAmount(new BigDecimal("0"));
                    wxOrderProductVO3.setCashAmount(wxOrderProductVO3.getProductSellAmount());
                    wxOrderProductVO3.setPayType(Integer.valueOf(-1));
                    totalAmount = totalAmount.add(wxOrderProductVO3.getProductSellAmount());
                    payAmount = payAmount.add(wxOrderProductVO3.getProductSellAmount());
                    cashAmount = cashAmount.add(wxOrderProductVO3.getProductSellAmount());
                    wxOrderProductVO3.setCustomerId(orderAddParamDto.getBuyerId());
                    wxOrderProductVO3.setPickupTime(new Date());
                    wxOrderProductVO3.setIsPromotion(Integer.valueOf(1));
                    if (mallProductResInfoDto.getProTypeId() != 10) {
                        wxOrderProductVO3.setProductIsGift(Integer.valueOf(2));
                    }
                    wxOrderProductVOList.add(wxOrderProductVO3);
                    WxOrderDetailVO wxOrderDetailVO3 = new WxOrderDetailVO();
                    wxOrderDetailVO3.setCguid(IDGenerate.getUniqueIdStr());
                    wxOrderDetailVO3.setExternalOrderNo(wxOrderEntityVO.getExternalOrderNo());
                    wxOrderDetailVO3.setExternalMainOrderNo(wxOrderEntityVO.getExternalMainOrderNo());
                    wxOrderDetailVO3.setExternalMainOrderStatus(wxOrderEntityVO.getExternalOrderStatus());
                    wxOrderDetailVO3.setProductId(mallProductResInfoDto.getProId());
                    wxOrderDetailVO3.setProductName(mallProductResInfoDto.getProName());
                    wxOrderDetailVO3.setProductNum(new BigDecimal(mallProductResInfoDto.getProNum()));
                    wxOrderDetailVO3.setProductType(Integer.valueOf(1));
                    wxOrderDetailVO3.setDeliveryTime(orderAddParamDto.getDeliveryTime());
                    wxOrderDetailVO3.setProductIsGift(Integer.valueOf(1));
                    wxOrderDetailVO3.setProductCbarcode(mallProductResInfoDto.getGroupId());
                    wxOrderDetailVO3.setProductPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderDetailVO3.setProductAmount(wxOrderProductVO3.getProductPrice().multiply(wxOrderProductVO3.getProductNum()).setScale(6));
                    wxOrderDetailVO3.setProductSellPrice(new BigDecimal(mallProductResInfoDto.getProPrice()));
                    wxOrderDetailVO3.setProductSellAmount(wxOrderProductVO3.getProductPrice().multiply(wxOrderProductVO3.getProductNum()).setScale(6));
                    wxOrderDetailVO3.setPayBalancePerAmount(new BigDecimal("0"));
                    wxOrderDetailVO3.setCashAmount(wxOrderDetailVO3.getProductSellAmount());
                    wxOrderDetailVO3.setPayType(Integer.valueOf(-1));
                    wxOrderDetailVO3.setCustomerId(orderAddParamDto.getBuyerId());
                    wxOrderDetailVO3.setPickupTime(new Date());
                    wxOrderDetailVO3.setIsPromotion(Integer.valueOf(1));
                    if (mallProductResInfoDto.getProTypeId() != 10) {
                        wxOrderDetailVO3.setProductIsGift(Integer.valueOf(2));
                    }
                    wxOrderDetailVOList.add(wxOrderDetailVO3);
                    if (mallProductResInfoDto.getTransportType() == 1) {
                        transportType = 1;
                    }
                    mallProductVO.setBarCode(mallProductResInfoDto.getBarCode());
                    mallProductVO.setCount(Integer.valueOf(wxOrderProductVO3.getProductNum().intValue()));
                    mallProductVO.setProId(mallProductResInfoDto.getProId());
                    mallProductVO.setProName(mallProductResInfoDto.getProName());
                    mallProductVO.setPromotionId(orderProductParamDto.getProductId());
                    mallProductVO.setPromotionName(mallProductResInfoDto.getPromotionName());
                    productsPool.add(mallProductVO);
                }
            }
            shoppingcartVO.setProductsPool(productsPool);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            CustomerAddressVo customerAddressVo = new CustomerAddressVo();
            customerAddressVo.setProvinceName(areaCityProvinceResVo.getProvinceName());
            customerAddressVo.setCityName(areaCityProvinceResVo.getCityName());
            customerAddressVo.setAreaName(areaCityProvinceResVo.getAreaName());
            customerAddressVo.setAddress(orderAddParamDto.getConsigneeAddress());
            String deliverByErpThrResultStr = this.getDeliverByErpThr(shoppingcartVO, customerAddressVo, sdf.format(orderAddParamDto.getDeliveryTime()), 2, transportType);
            DeliverVo deliverVo = new DeliverVo();
            if (StringUtils.isNotEmpty((CharSequence)deliverByErpThrResultStr)) {
                this.getNoSeepUpProductDeliverByErp(deliverVo, shoppingcartVO, customerAddressVo, DateUtils.formatDate((Date)orderAddParamDto.getDeliveryTime(), (String)"yyyy-MM-dd"), deliverByErpThrResultStr, 2);
                if (!deliverVo.isBaseSuccess()) {
                    this.logger.info("******\u8fd4\u56de\u5931\u8d25getNoSeepUpProductDeliverByErp******");
                    return BaseJsonVo.error((String)"\u83b7\u53d6\u914d\u9001\u4fe1\u606f\u5931\u8d25");
                }
                if (deliverVo.getInventory() != 1) {
                    this.logger.info("******\u8fd4\u56de\u5931\u8d25getNoSeepUpProductDeliverByErp******");
                    return BaseJsonVo.error((String)"\u5546\u54c1\u65e0\u5e93\u5b58");
                }
            } else {
                return BaseJsonVo.error((String)"\u57ce\u5e02\u5173\u95ed");
            }
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)deliverByErpThrResultStr, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            JSONObject jsonObject = new JSONObject(true);
            jsonObject.putAll((Map)jsonMap);
            this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObject);
            this.logger.info("*************************getNoSeepUpProductDeliverByErp***********deliverVo************deliverVo={}", (Object)JSON.toJSONString((Object)deliverVo));
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    JSONObject objectResult = (JSONObject)jsonObject.get((Object)"result");
                    JSONObject deliverDates = null;
                    JSONArray jsonArrayProduct = null;
                    deliverDates = (JSONObject)objectResult.get((Object)"dates");
                    jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
                    String earliestPickupDate = (String)objectResult.get((Object)"earliestPickupDate");
                    String earliestDeliverDate = (String)objectResult.get((Object)"earliestDeliverDate");
                    String finishTime = (String)objectResult.get((Object)"finishTime");
                    String weekSetPickup = (String)objectResult.get((Object)"weekSetPickup");
                    String deliverId = (String)objectResult.get((Object)"deliverId");
                    String deliverName = (String)objectResult.get((Object)"deliverName");
                    String kwId = (String)objectResult.get((Object)"kwId");
                    String kwName = (String)objectResult.get((Object)"kwName");
                    String edbStoreId = (String)objectResult.get((Object)"edbStoreId");
                    int agingDays = (Integer)objectResult.get((Object)"days");
                    int buildDays = (Integer)objectResult.get((Object)"buildDays");
                    String kwAndEdbStoreId = kwId + "|" + edbStoreId;
                    int deliverType = (Integer)objectResult.get((Object)"deliverType");
                    int ifLongTime = (Integer)objectResult.get((Object)"ifLongTime");
                    wxOrderEntityVO.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd"));
                    wxOrderEntityVO.setLogisticsId(deliverId);
                    wxOrderEntityVO.setStoreId(kwId);
                    wxOrderProductVOList.forEach(wxOrderProductVO -> {
                        wxOrderProductVO.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd"));
                        wxOrderProductVO.setLogisticsId(deliverId);
                        wxOrderProductVO.setStoreId(kwId);
                    });
                    wxOrderDetailVOList.forEach(wxOrderDetailVO -> {
                        wxOrderDetailVO.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd"));
                        wxOrderDetailVO.setLogisticsId(deliverId);
                        wxOrderDetailVO.setStoreId(kwId);
                    });
                } else {
                    this.logger.info("*********************createOrder.getNoSeepUpProductDeliverByErp************\u8c03\u7528erp3\u30020\u83b7\u53d6\u914d\u9001\u65e5\u671f\u5931\u8d25****success={},status={}", (Object)success, (Object)status);
                }
            } else {
                this.logger.info("************************createOrder.getNoSeepUpProductDeliverByErp************\u8c03\u7528erp3\u30020\u83b7\u53d6\u914d\u9001\u65e5\u671f\u5931\u8d25****status={}", (Object)status);
            }
            wxOrderEntityVO.setOrderType(Integer.valueOf(1));
            wxOrderEntityVO.setOrderSonType(Integer.valueOf(orderAddParamDto.getOrderSonType() == null ? 1 : orderAddParamDto.getOrderSonType()));
            wxOrderEntityVO.setEvaluateStatus(Integer.valueOf(0));
            wxOrderEntityVO.setPayType(Integer.valueOf(-1));
            wxOrderEntityVO.setOrderIsCw(Integer.valueOf(transportType));
            wxOrderEntityVO.setOrderAmount(totalAmount);
            wxOrderEntityVO.setPayAmount(BigDecimal.ZERO);
            wxOrderEntityVO.setPayCouponPerAmount(totalAmount);
            wxOrderEntityVO.setWxOrderDetailVOList(wxOrderDetailVOList);
            wxOrderEntityVO.setWxOrderProductVOList(wxOrderProductVOList);
        }
        this.logger.info("+++++++++++++++++++wxOrderEntityVO>>>>>>>>>>>>>>wxOrderEntityVO={}", (Object)JSON.toJSONString((Object)wxOrderEntityVO));
        BaseJsonVo rst = this.orderEcInvoke.addOrder(wxOrderEntityVO);
        rst.setValue((Object)wxOrderEntityVO);
        return rst;
    }

    public BaseJsonVo checkOrder(String externalOrderNo) {
        WxOrderRequest wxOrderRequestOrder = new WxOrderRequest();
        wxOrderRequestOrder.setExternalOrderNo(externalOrderNo);
        wxOrderRequestOrder.setRows(Integer.valueOf(15));
        wxOrderRequestOrder.setPage(Integer.valueOf(1));
        BaseJsonVo orderInfoJson = this.orderEcInvoke.getOrderList(wxOrderRequestOrder);
        if (orderInfoJson.isSuccess()) {
            this.logger.info("============checkOrder=========orderInfoJson={}", (Object)JSON.toJSONString((Object)orderInfoJson));
            JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJson.getValue()), JqGridData.class);
            List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
            if (originOrderVOList != null && originOrderVOList.size() > 0) {
                String message = null;
                message = ((OriginOrderVO)originOrderVOList.get(0)).getOrderIsCw() == 1 ? this.orderSaleInventoryErpInterface.checkOrderSaleCold(originOrderVOList) : this.orderSaleInventoryErpInterface.checkOrderSaleNomal(originOrderVOList);
                if (message != null) {
                    this.logger.info("========checkOrder==checkOrderSale===message={}", (Object)message);
                    throw new RuntimeException(message);
                }
            }
        }
        WxOrderEntityVO wxOrderEntityVO = new WxOrderEntityVO();
        wxOrderEntityVO.setExternalOrderNo(externalOrderNo);
        wxOrderEntityVO.setExternalOrderStatus("3");
        wxOrderEntityVO.setPayTime(new Date());
        this.orderEcInvoke.upstatusByOrderMainNo(wxOrderEntityVO);
        return BaseJsonVo.success((Object)"");
    }

    public String getDeliverByErpThr(MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, int cacheType, int transportType) {
        this.logger.info("++++++++cc.lechun.csmsapi.api.order.OrderApiImpl.getDeliverByErpThr++++++++cacheType={}", (Object)cacheType);
        if (cacheType == 1) {
            deliverDate = null;
        }
        Date dateTime = new Date();
        String buildDays = "7";
        HashMap<String, Object> mapParam = new HashMap<String, Object>();
        mapParam.put("buildStartTime", DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        mapParam.put("buildDays", Integer.valueOf(buildDays));
        mapParam.put("privinceName", addressVo.getProvinceName());
        mapParam.put("cityName", addressVo.getCityName());
        mapParam.put("areaName", addressVo.getAreaName());
        mapParam.put("address", addressVo.getAddress());
        if (StringUtils.isEmpty((CharSequence)deliverDate)) {
            mapParam.put("earliestDeliverDate", null);
        } else {
            mapParam.put("earliestDeliverDate", deliverDate);
        }
        if (transportType == 1) {
            transportType = 13;
        }
        mapParam.put("ifLongTime", 0);
        this.logger.info("<><><><><>><><><><><><><cc.lechun.csmsapi.api.order.OrderApiImpl.getDeliverByErpThr<><><><><><><><><><><><><>transportType={}", (Object)transportType);
        mapParam.put("deliverType", String.valueOf(transportType));
        JSONArray jsonArrayProduct = new JSONArray();
        String result = "";
        if (shoppingcartVO.getProductsPool() != null && shoppingcartVO.getProductsPool().size() > 0) {
            for (MallProductVO productVO : shoppingcartVO.getProductsPool()) {
                if (!productVO.getValid().booleanValue()) continue;
                HashMap<String, String> productMap = new HashMap<String, String>();
                productMap.put("barCode", productVO.getBarCode());
                if (StringUtils.isEmpty((CharSequence)productVO.getBarCode())) {
                    return result;
                }
                productMap.put("proId", String.valueOf(productVO.getProId()));
                productMap.put("productName", productVO.getProName());
                if (StringUtils.isEmpty((CharSequence)productVO.getPromotionId()) && StringUtils.isEmpty((CharSequence)productVO.getPromotionName())) {
                    productMap.put("productCount", String.valueOf(productVO.getCount()));
                }
                productMap.put("promotionId", productVO.getPromotionId());
                productMap.put("promotionName", productVO.getPromotionName());
                jsonArrayProduct.add(productMap);
            }
            mapParam.put("wxProductForms", jsonArrayProduct);
        }
        this.logger.info("*************************cc.lechun.csmsapi.api.order.OrderApiImpl.getDeliverByErpThr********************\u8c03\u7528ERP3.0\u4f20\u9012\u7684\u53c2\u6570*************mapParam={}\uff0corderDeliverUrl={}", (Object)JSON.toJSONString(mapParam), (Object)this.orderDeliverUrl);
        result = HttpRequest.httpsPostByDeliver((String)this.orderDeliverUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************cc.lechun.csmsapi.api.order.OrderApiImpl.getDeliverByErpThr********************\u8c03\u7528ERP3.0\u8fd4\u56de\u7684\u6570\u636e*************result={}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public DeliverVo getNoSeepUpProductDeliverByErp(DeliverVo deliverVo, MallShoppingcartVO shoppingcartVO, CustomerAddressVo addressVo, String deliverDate, String result, int cacheType) {
        LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)result, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.putAll((Map)jsonMap);
        this.logger.info("*************************getNoSeepUpProductDeliverByErp***********jsonObject************jsonObject={}", (Object)jsonObject);
        int status = (Integer)jsonObject.get((Object)"status");
        if (status == 200) {
            boolean success = (Boolean)jsonObject.get((Object)"success");
            if (success) {
                JSONObject objectResult = (JSONObject)jsonObject.get((Object)"result");
                JSONObject deliverDates = null;
                JSONArray jsonArrayProduct = null;
                deliverDates = (JSONObject)objectResult.get((Object)"dates");
                jsonArrayProduct = (JSONArray)objectResult.get((Object)"wxProductForms");
                if (objectResult.get((Object)"deliverDates") != null || objectResult.get((Object)"deliverDates") != "") {
                    deliverVo.setDeliverDates(JSONArray.parseArray((String)objectResult.get((Object)"deliverDates").toString(), DeliverSoldProductVo.class));
                    this.bulidSoldProduct(deliverVo.getDeliverDates());
                } else {
                    deliverVo.setDeliverDates(null);
                }
                String earliestPickupDate = (String)objectResult.get((Object)"earliestPickupDate");
                String earliestDeliverDate = (String)objectResult.get((Object)"earliestDeliverDate");
                String finishTime = (String)objectResult.get((Object)"finishTime");
                String weekSetPickup = (String)objectResult.get((Object)"weekSetPickup");
                String deliverId = (String)objectResult.get((Object)"deliverId");
                String deliverName = (String)objectResult.get((Object)"deliverName");
                String kwId = (String)objectResult.get((Object)"kwId");
                String kwName = (String)objectResult.get((Object)"kwName");
                String edbStoreId = (String)objectResult.get((Object)"edbStoreId");
                int agingDays = (Integer)objectResult.get((Object)"days");
                int buildDays = (Integer)objectResult.get((Object)"buildDays");
                String kwAndEdbStoreId = kwId + "|" + edbStoreId;
                int deliverType = (Integer)objectResult.get((Object)"deliverType");
                int ifLongTime = (Integer)objectResult.get((Object)"ifLongTime");
                if (deliverVo != null && deliverVo.getInventory() == 0) {
                    deliverVo.setDeliverId(deliverId);
                    deliverVo.setDeliverName(deliverName);
                    deliverVo.setDcId(kwAndEdbStoreId);
                }
                if (deliverVo.getDeliverDateVos() == null) {
                    deliverVo.setDeliverDateVos(new ArrayList());
                }
                if (deliverDates != null) {
                    int inventory = 1;
                    for (DeliverDateVo deliverDateVo : deliverVo.getDeliverDateVos()) {
                        if (deliverDateVo.getInventory() != 1) continue;
                        earliestDeliverDate = deliverDateVo.getDeliverDate();
                        break;
                    }
                    int nomalInventory = 1;
                    if (StringUtils.isEmpty((CharSequence)earliestDeliverDate)) {
                        nomalInventory = 0;
                    } else {
                        Date earliestDeliverDateTime = DateUtils.getDateFromString((String)earliestDeliverDate, (String)"yyyy-MM-dd");
                        earliestDeliverDateTime = DateUtils.getAddDateByDay((Date)earliestDeliverDateTime, (int)(-agingDays));
                        earliestPickupDate = DateUtils.formatDate((Date)earliestDeliverDateTime, (String)"yyyy-MM-dd");
                    }
                    if (nomalInventory != 1 && deliverVo.getSpeedupInventory() != 1) {
                        inventory = 0;
                    }
                    if (deliverVo != null && deliverVo.getInventory() == 0) {
                        if (StringUtils.isNotEmpty((CharSequence)deliverDate)) {
                            deliverVo.setDeliverDate(deliverDate);
                            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverDate));
                        } else {
                            deliverVo.setDeliverDate(earliestDeliverDate);
                            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                        }
                        deliverVo.setPickDate(earliestPickupDate);
                        deliverVo.setDeliverEndTime(finishTime);
                        deliverVo.setDelay(0);
                        deliverVo.setNomalInventory(nomalInventory);
                        deliverVo.setInventory(inventory);
                        deliverVo.setDeliverWeekShow(weekSetPickup);
                    }
                    deliverVo.getDeliverDateVos().sort((f1, f2) -> f1.getDeliverDate().compareTo(f2.getDeliverDate()));
                } else if (deliverVo != null && deliverVo.getInventory() == 0) {
                    deliverVo.setInventory(1);
                    deliverVo.setDeliverEndTime(finishTime);
                    deliverVo.setDeliverDate(earliestDeliverDate);
                    deliverVo.setPickDate(earliestPickupDate);
                    deliverVo.setDeliverDateShow(DateUtils.getDateName((String)earliestDeliverDate));
                    deliverVo.setDeliverEndTime(finishTime);
                    deliverVo.setDeliverWeekShow(weekSetPickup);
                }
                deliverVo.setDeliverDateVos(deliverVo.getDeliverDateVos());
                if (jsonArrayProduct != null && jsonArrayProduct.size() > 0 && deliverVo.getSpeedupInventory() != 1) {
                    List deliverProductVoList = JSON.parseArray((String)jsonArrayProduct.toJSONString(), DeliverProductVo.class);
                    this.logger.info("++++++++++++++++++++!!!!!!!!!!!!!getNoSeepUpProductDeliverByErp!!!!!!!!!!!!+++++++++++++++++++deliverProductVoList={}", (Object)JSON.toJSONString((Object)deliverProductVoList));
                    if (deliverProductVoList != null && deliverProductVoList.size() > 0) {
                        DeliverEntity deliverEntity = new DeliverEntity();
                        ArrayList<GroupProductEntity> gpList = new ArrayList<GroupProductEntity>();
                        int isInventory = 1;
                        boolean salseInt = false;
                        deliverProductVoList.sort((f1, f2) -> String.valueOf(f1.getSalesCount()).compareTo(String.valueOf(f2.getSalesCount())));
                        for (DeliverProductVo deliverProductVo : deliverProductVoList) {
                            int proInventory = 1;
                            GroupProductEntity groupProductEntity = new GroupProductEntity();
                            groupProductEntity.setDelay(deliverProductVo.getDelayDays());
                            groupProductEntity.setDelayDate(deliverProductVo.getDeliverDate());
                            groupProductEntity.setInventoryCount(deliverProductVo.getSalesCount());
                            groupProductEntity.setProductName(deliverProductVo.getProductName());
                            if (StringUtils.isNotEmpty((CharSequence)deliverProductVo.getBarCode())) {
                                groupProductEntity.setProductId(deliverProductVo.getProId());
                                if (StringUtils.isEmpty((CharSequence)deliverDate) && StringUtils.isEmpty((CharSequence)earliestDeliverDate)) {
                                    if (deliverProductVo.getSalesCount() <= 0) {
                                        salseInt = true;
                                        proInventory = 0;
                                        isInventory = 0;
                                    } else if (!salseInt) {
                                        proInventory = 0;
                                        isInventory = 0;
                                    }
                                }
                                groupProductEntity.setInventory(proInventory);
                            } else {
                                groupProductEntity.setInventory(-2);
                            }
                            gpList.add(groupProductEntity);
                        }
                        this.logger.info("<><><><><><><><><><><>!!!!!!!!!!!!getNoSeepUpProductDeliverByErp!!!!!!!!!!<><><><><><><><><><>gpList={}", (Object)JSON.toJSONString(gpList));
                        deliverVo.setInventory(isInventory);
                        deliverEntity.setGpList(gpList);
                    }
                }
            } else {
                this.logger.info("*************************getNoSeepUpProductDeliverByErp************\u8c03\u7528erp3\u30020\u83b7\u53d6\u914d\u9001\u65e5\u671f\u5931\u8d25****success={},status={}", (Object)success, (Object)status);
                deliverVo.setInventory(-1);
            }
            return deliverVo;
        }
        if (status == 1000 || status == 106) {
            deliverVo.setInventory(-1);
            return deliverVo;
        }
        if (cacheType != 2) {
            deliverVo.setInventory(1);
            deliverVo.setDeliverEndTime("20:00");
            deliverVo.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)1), (String)"yyyy-MM-dd"));
            deliverVo.setPickDate(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"));
            deliverVo.setDeliverDateShow(DateUtils.getDateName((String)deliverVo.getDeliverDate()));
        }
        return deliverVo;
    }

    public void bulidSoldProduct(List<DeliverSoldProductVo> deliverDates) {
        if (deliverDates != null && deliverDates.size() > 0) {
            for (DeliverSoldProductVo deliverSoldProductVo : deliverDates) {
                List productFormList = deliverSoldProductVo.getProductForms();
                if (productFormList != null && productFormList.size() > 0) {
                    for (ProductFormVo productFormVo : productFormList) {
                        if (!StringUtils.isNotEmpty((CharSequence)productFormVo.getPromotionId()) || !StringUtils.isNotEmpty((CharSequence)productFormVo.getPromotionName())) continue;
                        productFormVo.setProductName(productFormVo.getPromotionName());
                        productFormVo.setSalesCount(0);
                    }
                }
                List productFormVos = productFormList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ProductFormVo>(Comparator.comparing(t -> t.getProductName()))), ArrayList::new));
                deliverSoldProductVo.setProductForms(productFormVos);
            }
        }
        this.logger.info("deliverDates={}", (Object)JSON.toJSONString(deliverDates));
    }

    public List<WxOrderEntityVO> listWxOrderList(RefundParamDto refundParamDto) {
        WxOrderRequest wxOrderRequest = new WxOrderRequest();
        wxOrderRequest.setExternalOrderNo(refundParamDto.getOrderNo());
        wxOrderRequest.setRows(Integer.valueOf(15));
        wxOrderRequest.setPage(Integer.valueOf(1));
        BaseJsonVo orderInfoJson = this.orderEcInvoke.getOrderList(wxOrderRequest);
        ArrayList<WxOrderEntityVO> wxOrderEntityVOList = new ArrayList<WxOrderEntityVO>();
        if (orderInfoJson.isSuccess()) {
            this.logger.info("============listWxOrderList=========orderInfoJson={}", (Object)JSON.toJSONString((Object)orderInfoJson));
            JqGridData jqGridData = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJson.getValue()), JqGridData.class);
            List originOrderVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData.getRows()), OriginOrderVO.class);
            if (originOrderVOList != null && originOrderVOList.size() > 0) {
                List refundProductParamDtoList = refundParamDto.getRefundProductList();
                ArrayList<WxOrderProductVO> wxOrderProductVOList = new ArrayList<WxOrderProductVO>();
                for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                    WxOrderProductVO wxOrderProductVO = new WxOrderProductVO();
                    wxOrderProductVO.setProductNum(new BigDecimal(refundProductParamDto.getProductNum()));
                    wxOrderProductVO.setProductId(refundProductParamDto.getProductId());
                    wxOrderProductVO.setPayBalancePerAmount(refundProductParamDto.getRefundBalanceAmountCheck());
                    wxOrderProductVO.setCashAmount(refundProductParamDto.getRefundCashAmountCheck());
                    wxOrderProductVOList.add(wxOrderProductVO);
                }
                OriginOrderVO originOrderVO = (OriginOrderVO)originOrderVOList.get(0);
                WxOrderEntityVO wxOrderEntityVO = new WxOrderEntityVO();
                wxOrderEntityVO.setExternalOrderNo(refundParamDto.getOrderNo());
                wxOrderEntityVO.setOrderType(originOrderVO.getOrderType());
                wxOrderEntityVO.setAfterSaleStatus(refundParamDto.getAfterSaleStatus());
                wxOrderEntityVO.setAfterSaleUser(refundParamDto.getUserName());
                wxOrderEntityVO.setAfterSaleTime(new Date());
                wxOrderEntityVO.setAfterSaleReason(refundParamDto.getRefundReason());
                wxOrderEntityVO.setAfterStatus(refundParamDto.getAfterSaleType());
                wxOrderEntityVO.setWxOrderProductVOList(wxOrderProductVOList);
                wxOrderEntityVOList.add(wxOrderEntityVO);
                if (OrderSourceEnum.CARDPLAN.getValue() == originOrderVO.getOrderSource().intValue()) {
                    String sourceOrderNo = originOrderVO.getSourceOrderMainNo();
                    WxOrderRequest wxOrderRequestMike = new WxOrderRequest();
                    wxOrderRequestMike.setExternalMainOrderNo(sourceOrderNo);
                    wxOrderRequestMike.setRows(Integer.valueOf(15));
                    wxOrderRequestMike.setPage(Integer.valueOf(1));
                    BaseJsonVo orderInfoJsonMike = this.orderEcInvoke.getOrderList(wxOrderRequestMike);
                    if (orderInfoJsonMike.isSuccess()) {
                        this.logger.info("============listWxOrderList=========orderInfoJsonMike={}", (Object)JSON.toJSONString((Object)orderInfoJsonMike));
                        JqGridData jqGridDataMike = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoJsonMike.getValue()), JqGridData.class);
                        List originOrderVOListMike = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridDataMike.getRows()), OriginOrderVO.class);
                        if (originOrderVOList != null && originOrderVOList.size() > 0) {
                            OriginOrderVO originOrderVOMike = (OriginOrderVO)originOrderVOListMike.get(0);
                            ArrayList<WxOrderProductVO> wxOrderProductVOListMike = new ArrayList<WxOrderProductVO>();
                            WxOrderRequest wxOrderRequestProduct = new WxOrderRequest();
                            wxOrderRequestProduct.setExternalOrderNo(originOrderVOMike.getExternalOrderNo());
                            BaseJsonVo orderProductListJson = this.orderEcInvoke.getOrderProductList(wxOrderRequestProduct);
                            if (orderProductListJson.isSuccess()) {
                                List omsEcOrderProductEntityList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderProductListJson.getValue())).toJavaList(OriginOrderProductEntity.class);
                                for (OriginOrderProductEntity ordereProductVo : omsEcOrderProductEntityList) {
                                    WxOrderProductVO wxOrderProductVOMike = new WxOrderProductVO();
                                    wxOrderProductVOMike.setProductNum(ordereProductVo.getProductNum());
                                    wxOrderProductVOMike.setProductId(ordereProductVo.getProductId());
                                    if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
                                        wxOrderProductVOMike.setCashAmount(((RefundProductParamDto)refundProductParamDtoList.get(0)).getRefundCashAmountCheck());
                                    }
                                    wxOrderProductVOListMike.add(wxOrderProductVOMike);
                                }
                            }
                            WxOrderEntityVO wxOrderEntityVOMike = new WxOrderEntityVO();
                            wxOrderEntityVOMike.setExternalOrderNo(originOrderVOMike.getExternalOrderNo());
                            wxOrderEntityVOMike.setOrderType(originOrderVOMike.getOrderType());
                            wxOrderEntityVOMike.setAfterSaleStatus(refundParamDto.getAfterSaleStatus());
                            wxOrderEntityVOMike.setAfterSaleUser(refundParamDto.getUserName());
                            wxOrderEntityVOMike.setAfterSaleTime(new Date());
                            wxOrderEntityVOMike.setAfterSaleReason(refundParamDto.getRefundReason());
                            wxOrderEntityVOMike.setAfterStatus(refundParamDto.getAfterSaleType());
                            wxOrderEntityVOMike.setWxOrderProductVOList(wxOrderProductVOListMike);
                            wxOrderEntityVOList.add(wxOrderEntityVOMike);
                        }
                    }
                }
            }
        }
        return wxOrderEntityVOList;
    }
}

