/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.pay;

import cc.lechun.cms.dto.MallOrderMainDto;
import cc.lechun.cms.dto.MallOrderPayDto;
import cc.lechun.cms.dto.MallPlatformPayTypeDto;
import cc.lechun.csmsapi.apiinvoke.order.OrderEcInvoke;
import cc.lechun.csmsapi.apiinvoke.order.OrderProductInvoke;
import cc.lechun.csmsapi.apiinvoke.refund.RefundPrepayCardPlanInvoke;
import cc.lechun.csmsapi.entity.pay.PayInputEntity;
import cc.lechun.csmsapi.entity.pay.WechatRefundReturnEntity;
import cc.lechun.csmsapi.entity.refund.RefundEntity;
import cc.lechun.csmsapi.entity.refund.RefundPayDetailEntity;
import cc.lechun.csmsapi.enums.order.OrderSourceEnum;
import cc.lechun.csmsapi.enums.refund.RefundStatusEnum;
import cc.lechun.csmsapi.iservice.pay.PayInterface;
import cc.lechun.csmsapi.iservice.pay.PayRefundInterface;
import cc.lechun.csmsapi.iservice.refund.RefundInterface;
import cc.lechun.csmsapi.iservice.refund.RefundPayDetailInterface;
import cc.lechun.csmsapi.iservice.refund.RefundRecordInterface;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.omsv2.entity.order.origin.vo.OriginOrderVO;
import cc.lechun.omsv2.entity.order.third.weixin.WxOrderEntityVO;
import cc.lechun.omsv2.entity.order.third.weixin.request.WxOrderRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayRefundService
extends BaseService
implements PayRefundInterface {
    @Autowired
    private RefundInterface refundInterface;
    @Autowired
    private RefundPayDetailInterface refundPayDetailInterface;
    @Autowired
    private PayInterface payInterface;
    @Autowired
    private OrderEcInvoke orderEcInvoke;
    @Autowired
    private OrderProductInvoke orderProductInvoke;
    @Autowired
    private RefundRecordInterface refundRecordInterface;
    @Autowired
    private RefundPrepayCardPlanInvoke refundPrepayCardPlanInvoke;

    public BaseJsonVo refundPay() {
        this.logger.info("================csmsapi.PayRefundService.refundPay start================");
        BaseJsonVo result = new BaseJsonVo();
        int status = RefundStatusEnum.REFUND_AGREEE.getValue();
        int refundTime = 5;
        Date nowDate = new Date();
        Date refundDate = DateUtils.getAddDateBySecond((Date)nowDate, (int)(-(refundTime * 60)));
        List refundEntityList = this.refundInterface.queryRefundInfoByRefundStatusUpdateTime(status, refundDate);
        if (refundEntityList != null && refundEntityList.size() > 0) {
            for (RefundEntity refundEntity : refundEntityList) {
                List originOrderVOList1 = new ArrayList();
                WxOrderRequest wxOrderRequest1 = new WxOrderRequest();
                wxOrderRequest1.setExternalMainOrderNo(refundEntity.getOrderMainNo());
                wxOrderRequest1.setPage(Integer.valueOf(1));
                wxOrderRequest1.setRows(Integer.valueOf(15));
                BaseJsonVo orderInfoListJson = this.orderEcInvoke.getOrderList(wxOrderRequest1);
                this.logger.info("=============orderInfoListJson={}", (Object)JSON.toJSONString((Object)orderInfoListJson));
                if (!orderInfoListJson.isSuccess()) continue;
                JqGridData jqGridData1 = (JqGridData)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoListJson.getValue()), JqGridData.class);
                originOrderVOList1 = JSONObject.parseArray((String)JSONObject.toJSONString((Object)jqGridData1.getRows()), OriginOrderVO.class);
                this.logger.info("==================omsEcOrderResInfoDtoList1={}", (Object)JSON.toJSONString(originOrderVOList1));
                if (originOrderVOList1 == null || originOrderVOList1.size() == 0) continue;
                int isSuccess = 0;
                List refundPayDetailEntityList = this.refundPayDetailInterface.queryRefundPayDetailListByRefundIdStatus(isSuccess, refundEntity.getRefundNo());
                this.logger.info("=========refundPayDetailEntityList={}", (Object)JSON.toJSONString((Object)refundPayDetailEntityList));
                if (refundPayDetailEntityList == null || refundPayDetailEntityList.size() <= 0) continue;
                String refundNo = "";
                for (RefundPayDetailEntity refundPayDetailEntity : refundPayDetailEntityList) {
                    if (refundPayDetailEntity.getPaytypeId() != -1) {
                        PayInputEntity payInputEntity;
                        if (refundPayDetailEntity.getPaytypeId() == 2 || refundPayDetailEntity.getPaytypeId() == 7) {
                            BaseJsonVo baseJsonVo = this.refundInterface.buildRefundRecord(refundPayDetailEntity.getRefundPayDetailNo());
                            if (!baseJsonVo.isSuccess()) continue;
                            refundNo = baseJsonVo.getValue().toString();
                        }
                        if ((payInputEntity = this.getPayInputEntity(refundEntity.getOrderMainNo(), refundPayDetailEntity.getTradeNo())) == null) continue;
                        payInputEntity.setRefundAmount(refundPayDetailEntity.getRefundPayAmountCheck());
                        payInputEntity.setRefundBillNo(refundNo);
                        if (((OriginOrderVO)originOrderVOList1.get(0)).getOrderSource() < OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || ((OriginOrderVO)originOrderVOList1.get(0)).getOrderSource() > OrderSourceEnum.CARD_PREPAY_SHOP.getValue()) {
                            this.logger.info("++++++++++cc.lechun.mall.service.pay.PayOrderService.refundPay payRefund++++++++++OrderMainNo={}", (Object)payInputEntity.getOrderMainNo());
                            result = this.payInterface.payRefund(payInputEntity);
                            this.logger.info("++++++++++cc.lechun.mall.service.pay.PayOrderService.refundPay payRefund++++++++++payRefundResult1={},OrderMainNo1={}", (Object)JSON.toJSONString((Object)result), (Object)payInputEntity.getOrderMainNo());
                            if (!result.isSuccess()) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map = result.getValue() != null ? (Map)result.getValue() : map;
                                map.put("refundPayId", refundPayDetailEntity.getRefundPayDetailNo());
                                map.put("errorMessage", result.getError_msg());
                                continue;
                            }
                        }
                        if (refundPayDetailEntity.getPaytypeId() == 2 || refundPayDetailEntity.getPaytypeId() == 7) {
                            WechatRefundReturnEntity refundReturnEntity = (WechatRefundReturnEntity)result.getValue();
                            if (refundReturnEntity == null) continue;
                            this.refundRecordInterface.returnUpdateRecord(refundNo, refundReturnEntity.getThirdRefundId(), PriceUtils.multiply((BigDecimal)refundPayDetailEntity.getRefundPayAmountCheck(), (Integer)100).longValue(), JSON.toJSONString((Object)payInputEntity), JSON.toJSONString((Object)result));
                            if (!result.isSuccess()) continue;
                            this.refundInterface.successOrderRefund(refundEntity.getRefundNo(), refundPayDetailEntity.getPaytypeId().intValue(), refundNo);
                            if (OrderSourceEnum.CARD_PREPAY.getValue() != ((OriginOrderVO)originOrderVOList1.get(0)).getOrderSource().intValue()) continue;
                            this.updateMilkRefund((OriginOrderVO)originOrderVOList1.get(0), refundEntity, refundPayDetailEntity);
                            continue;
                        }
                        if (!result.isSuccess()) continue;
                        this.refundInterface.successOrderRefund(refundEntity.getRefundNo(), refundPayDetailEntity.getPaytypeId().intValue(), null);
                        continue;
                    }
                    this.refundInterface.successOrderRefund(refundEntity.getRefundNo(), refundPayDetailEntity.getPaytypeId().intValue(), null);
                }
            }
        }
        return result;
    }

    public BaseJsonVo updateMilkRefund(OriginOrderVO orderMainInfo, RefundEntity refundEntity, RefundPayDetailEntity refundPayDetailEntity) {
        this.logger.info("=======+++++++++++updateMilkRefund={},orderMainInfo={}", (Object)JSON.toJSONString((Object)refundEntity), (Object)JSON.toJSONString((Object)orderMainInfo));
        BaseJsonVo updateMilkRefundJson = new BaseJsonVo();
        String otherTkOrderNo = refundEntity.getOrderMainNo();
        int orderSource = 27;
        if (!orderMainInfo.getExternalMainOrderNo().equals(refundEntity.getOtherTkOrderNo())) {
            otherTkOrderNo = refundEntity.getOtherTkOrderNo();
            orderSource = 26;
        }
        this.logger.info("=======+++++++++++orderSource={}", (Object)orderSource);
        if (OrderSourceEnum.CARD_PREPAY.getValue() == orderSource) {
            String orderMainNo = refundEntity.getOrderMainNo();
            RefundEntity cardRefundEntity = new RefundEntity();
            cardRefundEntity.setOrderMainNo(orderMainNo);
            cardRefundEntity = this.refundInterface.getReturnAmountTotalByInfo(cardRefundEntity);
            BaseJsonVo cardOrderPayListJson = this.orderProductInvoke.getOrderPayListByCsms(orderMainInfo.getExternalMainOrderNo());
            List mallOrderPayList = new ArrayList();
            if (cardOrderPayListJson.isSuccess()) {
                mallOrderPayList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)cardOrderPayListJson.getValue()), MallOrderPayDto.class);
            }
            MallOrderPayDto cardOrderPayEntity = (MallOrderPayDto)mallOrderPayList.get(0);
            this.logger.info("===============updateMilkRefund=======cardRefundEntity={}\uff0ccardOrderPayEntity={}", (Object)JSON.toJSONString((Object)cardRefundEntity), (Object)JSON.toJSONString((Object)cardOrderPayEntity));
            if (cardRefundEntity == null || cardRefundEntity.getRefundAmountCheck().compareTo(cardOrderPayEntity.getPayamount()) == 0) {
                // empty if block
            }
        }
        if (OrderSourceEnum.CARDPLAN.getValue() == orderSource) {
            if (refundEntity.getRefundType() == 3) {
                this.logger.info("=======+++++++++++refundEntity.getRefundOrderType().intValue() ");
            }
            RefundEntity goodRefundEntity = new RefundEntity();
            goodRefundEntity.setOrderMainNo(refundEntity.getOrderMainNo());
            goodRefundEntity.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUND_FINISH.getValue()));
            goodRefundEntity = this.refundInterface.getReturnAmountTotalByInfo(goodRefundEntity);
            BaseJsonVo cardOrderPayListJson = this.orderProductInvoke.getOrderPayListByCsms(orderMainInfo.getExternalMainOrderNo());
            List mallOrderPayList = new ArrayList();
            if (cardOrderPayListJson.isSuccess()) {
                mallOrderPayList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)cardOrderPayListJson.getValue()), MallOrderPayDto.class);
            }
            MallOrderPayDto cardOrderPayEntity = (MallOrderPayDto)mallOrderPayList.get(0);
            if (goodRefundEntity == null || goodRefundEntity.getRefundAmountCheck().compareTo(cardOrderPayEntity.getPayamount()) == 0) {
                // empty if block
            }
        }
        return updateMilkRefundJson;
    }

    public BaseJsonVo mikeRefund(WxOrderEntityVO orderMainInfo, RefundEntity refundEntity, RefundPayDetailEntity refundPayDetailEntity) {
        BaseJsonVo refundPrePayJson = new BaseJsonVo();
        String otherTkOrderNo = refundEntity.getOrderMainNo();
        int orderSource = 27;
        if (orderMainInfo.getOrderSource() < OrderSourceEnum.CARD_PREPAY_TMALL.getValue() || orderMainInfo.getOrderSource() > OrderSourceEnum.CARD_PREPAY_SHOP.getValue()) {
            if (!orderMainInfo.getOrderMainNo().equals(refundEntity.getOtherTkOrderNo())) {
                otherTkOrderNo = refundEntity.getOtherTkOrderNo();
                orderSource = 26;
            }
        } else {
            orderSource = orderMainInfo.getOrderSource();
        }
        refundPrePayJson = this.refundPrepayCardPlanInvoke.refundOrderPlan(otherTkOrderNo, Integer.valueOf(orderSource), refundEntity.getRemark(), refundPayDetailEntity.getRefundPayAmountCheck(), refundEntity.getCreateId());
        this.logger.info("===========refundPrePayJson==========refundPrePayJson={}", (Object)JSON.toJSONString((Object)refundPrePayJson));
        return refundPrePayJson;
    }

    private PayInputEntity getPayInputEntity(String orderMainNo, String tradeNo) {
        this.logger.info("========getPayInputEntity======orderMainNo={},tradeNo={}", (Object)orderMainNo, (Object)tradeNo);
        PayInputEntity pe = null;
        List payInputEntities = this.getPayInputEntityList(orderMainNo, "");
        if (payInputEntities != null && (payInputEntities = payInputEntities.stream().filter(c -> c.getTradeNo().equals(tradeNo) || c.getPayId().equals(tradeNo)).collect(Collectors.toList())) != null) {
            pe = (PayInputEntity)payInputEntities.get(0);
        }
        return pe;
    }

    private List<PayInputEntity> getPayInputEntityList(String orderMainNo, String ip) {
        BaseJsonVo mallOrderMainJson = this.orderProductInvoke.getMallOrderMainInfoByCsms(orderMainNo);
        this.logger.info("========getPayInputEntityList======mallOrderMainJson={}", (Object)JSON.toJSONString((Object)mallOrderMainJson));
        MallOrderMainDto mallOrderMainEntity = new MallOrderMainDto();
        if (mallOrderMainJson.isSuccess()) {
            mallOrderMainEntity = (MallOrderMainDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)mallOrderMainJson.getValue()), MallOrderMainDto.class);
        }
        if (mallOrderMainEntity == null) {
            return new ArrayList<PayInputEntity>();
        }
        BaseJsonVo mallOrderPayJson = this.orderProductInvoke.getOrderPayListByCsms(orderMainNo);
        this.logger.info("========getPayInputEntityList======mallOrderPayJson={}", (Object)JSON.toJSONString((Object)mallOrderPayJson));
        List mallOrderPayEntitis = new ArrayList();
        if (mallOrderPayJson.isSuccess()) {
            mallOrderPayEntitis = JSONObject.parseArray((String)JSONObject.toJSONString((Object)mallOrderPayJson.getValue()), MallOrderPayDto.class);
        }
        if (mallOrderPayEntitis == null) {
            return new ArrayList<PayInputEntity>();
        }
        ArrayList<PayInputEntity> inputEntitis = new ArrayList<PayInputEntity>();
        for (MallOrderPayDto e : mallOrderPayEntitis) {
            PayInputEntity pe = new PayInputEntity();
            pe.setPayId(e.getPayId());
            pe.setOrderMainNo(orderMainNo);
            pe.setPayType(e.getPaytypeId().intValue());
            pe.setPaySubType(e.getPaySubtypeId().intValue());
            pe.setPayAmount(e.getPayamount());
            pe.setSuccess(e.getIssuccess() == 1);
            pe.setOrderCreateTime(mallOrderMainEntity.getCreateTime());
            pe.setOrder(e.getSort().intValue());
            pe.setTradeNo(e.getTradeNo());
            pe.setThirdTradeNo(e.getThirdTradeNo());
            pe.setCustomerId(mallOrderMainEntity.getCustomerId());
            pe.setIp(ip);
            pe.setCashType(e.getCashType().intValue());
            this.fillPayInputEntity(pe, mallOrderMainEntity.getPlatformId().intValue(), e.getPaySubtypeId().intValue());
            inputEntitis.add(pe);
        }
        this.logger.info("==============finalPayInputEntiye=====inputEntitis={}", (Object)JSON.toJSONString(inputEntitis));
        Comparator<PayInputEntity> orderSort = Comparator.comparingInt(PayInputEntity::getOrder);
        return inputEntitis.stream().sorted(orderSort).collect(Collectors.toList());
    }

    private void fillPayInputEntity(PayInputEntity pe, int platformId, int payTypeSubId) {
        BaseJsonVo jsonVo = this.orderProductInvoke.getPlatFormPayType(platformId, payTypeSubId);
        this.logger.info("========fillPayInputEntity======jsonVo={}", (Object)JSON.toJSONString((Object)jsonVo));
        MallPlatformPayTypeDto platformPayTypeEntity = (MallPlatformPayTypeDto)JSONObject.parseObject((String)JSONObject.toJSONString((Object)jsonVo.getValue()), MallPlatformPayTypeDto.class);
        this.logger.error("refundfile_is_here1:" + JsonUtils.toJson((Object)platformPayTypeEntity, (boolean)false));
        if (platformPayTypeEntity != null) {
            pe.setPayKey(platformPayTypeEntity.getPayKey());
            pe.setAppId(platformPayTypeEntity.getAppid());
            pe.setBody(platformPayTypeEntity.getBody());
            pe.setMchId(platformPayTypeEntity.getMchId());
            pe.setTradeType(platformPayTypeEntity.getTradeType());
            pe.setDomain(platformPayTypeEntity.getDomain());
            pe.setAppName(platformPayTypeEntity.getAppName());
            pe.setPublicKey(platformPayTypeEntity.getPublicKey());
            pe.setRequestDomain(platformPayTypeEntity.getRequestDomain());
            pe.setCharset(platformPayTypeEntity.getCharset());
            pe.setSignType(platformPayTypeEntity.getSignType());
            pe.setReturnUrl(platformPayTypeEntity.getReturnUrl());
            pe.setNotifyUrl(platformPayTypeEntity.getNotifyUrl());
            pe.setSellerEmail(platformPayTypeEntity.getSellerEmail());
            pe.setDataFormat(platformPayTypeEntity.getDataFormat());
            pe.setTimeOut(platformPayTypeEntity.getTimeout().intValue());
            pe.setRefundCertFile(platformPayTypeEntity.getRefundCertFile());
            pe.setOrderCancelTime(DateUtils.getAddDateBySecond((Date)pe.getOrderCreateTime(), (int)platformPayTypeEntity.getTimeout()));
        }
    }
}

