/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.pay.wechatpay;

import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.csmsapi.entity.pay.PayInputEntity;
import cc.lechun.csmsapi.entity.pay.PayOutputEntity;
import cc.lechun.csmsapi.entity.pay.WechatNotifyEntity;
import cc.lechun.csmsapi.entity.pay.WechatRefundNotifyEntity;
import cc.lechun.csmsapi.entity.pay.WechatRefundReturnEntity;
import cc.lechun.csmsapi.service.pay.wechatpay.WechatPayCommon;
import cc.lechun.csmsapi.service.pay.wechatpay.entity.CreateOrderReturnEntity;
import cc.lechun.csmsapi.service.pay.wechatpay.entity.PayInfo;
import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.XmlUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.sign.AES;
import cc.lechun.framework.common.utils.sign.EncodeUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class WechatPayImpl
extends BaseService {
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        PayOutputEntity payOutputEntity = new PayOutputEntity();
        PayInfo payInfo = WechatPayCommon.createPayInfo((PayInputEntity)inputEntity);
        CreateOrderReturnEntity createOrderReturnEntity = this.createOrder(payInfo, inputEntity);
        payOutputEntity.setSendUrl(createOrderReturnEntity.getSendUrl());
        payOutputEntity.setSendContent(createOrderReturnEntity.getSendContent());
        payOutputEntity.setReturnContent(createOrderReturnEntity.getReturnContent());
        if (createOrderReturnEntity.getStatus() == 1) {
            String prepay_id2;
            TreeMap<String, String> finalpackage = new TreeMap<String, String>();
            String appid2 = payInfo.getAppid();
            String timestamp = String.valueOf(DateUtils.nowMillis());
            String nonceStr2 = payInfo.getNonce_str();
            String packages = prepay_id2 = "prepay_id=" + createOrderReturnEntity.getPrepayId();
            if (payInfo.getPay_type_sub_id() == PaySubTypeEnum.WECHAT_SUB_ANDROID_PAY.getValue() || payInfo.getPay_type_sub_id() == PaySubTypeEnum.WECHAT_SUB_IOS_PAY.getValue()) {
                packages = "Sign=WXPay";
                finalpackage.put("appId", appid2);
                finalpackage.put("nonceStr", nonceStr2);
                finalpackage.put("package", packages);
                finalpackage.put("partnerid", payInfo.getMch_id());
                finalpackage.put("prepayid", createOrderReturnEntity.getPrepayId());
                finalpackage.put("timeStamp", timestamp);
            } else {
                finalpackage.put("appId", appid2);
                finalpackage.put("timeStamp", timestamp);
                finalpackage.put("nonceStr", nonceStr2);
                finalpackage.put("package", packages);
                finalpackage.put("signType", inputEntity.getSignType());
            }
            String finalsign = WechatPayCommon.createSign(finalpackage, (String)payInfo.getPayKey());
            payOutputEntity.setAppId(appid2);
            payOutputEntity.setPartnerId(payInfo.getMch_id());
            payOutputEntity.setPrepayId(createOrderReturnEntity.getPrepayId());
            payOutputEntity.setPackages(packages);
            payOutputEntity.setNonceStr(nonceStr2);
            payOutputEntity.setTimeStamp(timestamp);
            payOutputEntity.setSign(finalsign);
            payOutputEntity.setOrderMainNo(inputEntity.getOrderMainNo());
            payOutputEntity.setSignType(inputEntity.getSignType());
            payOutputEntity.setPayJsUrl(createOrderReturnEntity.getMwebUrl());
            payOutputEntity.setStatus(PayStatusEnum.TO_PAY_SUCCESS.getValue());
            payOutputEntity.setPayTypeId(inputEntity.getPayType());
            payOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
            payOutputEntity.setPayId(inputEntity.getPayId());
            result.setValue((Object)payOutputEntity);
            this.logger.info("\u652f\u4ed8\uff1a" + JsonUtils.toJson((Object)payOutputEntity, (boolean)false));
            return result;
        }
        result.setError(createOrderReturnEntity.getMessage());
        result.setValue((Object)payOutputEntity);
        this.logger.info("\u652f\u4ed8\uff1a" + createOrderReturnEntity.getMessage());
        return result;
    }

    private CreateOrderReturnEntity createOrder(PayInfo payInfo, PayInputEntity payInputEntity) {
        String mwebUrl;
        String prepay_id;
        String return_code;
        CreateOrderReturnEntity result = new CreateOrderReturnEntity();
        String requestBody = WechatPayCommon.getCreateOrderRequestBody((PayInfo)payInfo);
        this.logger.info(JsonUtils.toJson((Object)payInputEntity, (boolean)true));
        String json = HttpRequest.httpsPost((String)payInputEntity.getRequestDomain(), (String)requestBody);
        result.setSendUrl(payInputEntity.getRequestDomain());
        result.setSendContent(requestBody);
        result.setReturnContent(json);
        if (json.isEmpty()) {
            result.setStatus(0);
            result.setMessage("\u8c03\u7528\u652f\u4ed8\u9519\u8bef\uff1a\u8fd4\u56de\u503c\u4e3a\u7a7a");
            return result;
        }
        Map map = XmlUtils.doXMLParse((String)json);
        if (map != null && map.size() > 0) {
            return_code = (String)map.get("return_code");
            String result_code = (String)map.get("result_code");
            prepay_id = (String)map.get("prepay_id");
            mwebUrl = (String)map.get("mweb_url");
            if (!return_code.toUpperCase().equals("SUCCESS")) {
                result.setStatus(0);
                result.setMessage(map.get("return_msg").toString());
                return result;
            }
            if (!result_code.toUpperCase().equals("SUCCESS")) {
                result.setStatus(0);
                result.setMessage(map.get("err_code_des").toString());
                return result;
            }
            if (prepay_id.isEmpty()) {
                result.setStatus(0);
                result.setMessage("\u8c03\u7528\u652f\u4ed8\u9519\u8bef:\u9884\u652f\u4ed8Id\u4e3a\u7a7a");
                return result;
            }
        } else {
            result.setStatus(0);
            result.setMessage("\u8c03\u7528\u652f\u4ed8\u9519\u8bef:\u8fd4\u56de\u503c\u7a7a");
            return result;
        }
        result.setStatus(1);
        result.setReturnCode(return_code);
        result.setMwebUrl(mwebUrl);
        result.setPrepayId(prepay_id);
        return result;
    }

    public <T> BaseJsonVo payNotify(T notifyEntity) {
        BaseJsonVo result = new BaseJsonVo();
        WechatNotifyEntity notifyEntity1 = (WechatNotifyEntity)notifyEntity;
        if (notifyEntity1.getReturnCode().equalsIgnoreCase("SUCCESS") && notifyEntity1.getResultCode().equalsIgnoreCase("SUCCESS")) {
            String sign = WechatPayCommon.createSign((SortedMap)notifyEntity1.getMap(), (String)notifyEntity1.getPayKey());
            if (sign.equals(notifyEntity1.getSign())) {
                return result;
            }
        } else {
            result.setError("\u652f\u4ed8\u5931\u8d25");
        }
        return result;
    }

    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        String xml;
        String sign;
        String signTemp;
        BaseJsonVo result = new BaseJsonVo();
        String url = "https://api.mch.weixin.qq.com/pay/orderquery";
        String appId = inputEntity.getAppId();
        String mchId = inputEntity.getMchId();
        String nonceStr = WechatPayCommon.createNonceStr();
        String transactionId = inputEntity.getThirdTradeNo();
        if (!transactionId.isEmpty()) {
            signTemp = "appid=" + appId + "&mch_id=" + mchId + "&nonce_str=" + nonceStr + "&transaction_id=" + transactionId + "&key=" + inputEntity.getPayKey();
            sign = MD5.sign((String)signTemp).toUpperCase();
            xml = "<xml><appid>" + appId + "</appid><mch_id>" + mchId + "</mch_id><nonce_str>" + nonceStr + "</nonce_str><transaction_id>" + transactionId + "</transaction_id><sign>" + sign + "</sign></xml> ";
        } else {
            signTemp = "appid=" + appId + "&mch_id=" + mchId + "&nonce_str=" + nonceStr + "&out_trade_no=" + inputEntity.getTradeNo() + "&key=" + inputEntity.getPayKey();
            sign = MD5.sign((String)signTemp).toUpperCase();
            xml = "<xml><appid>" + appId + "</appid><mch_id>" + mchId + "</mch_id><nonce_str>" + nonceStr + "</nonce_str><out_trade_no>" + inputEntity.getTradeNo() + "</out_trade_no><sign>" + sign + "</sign></xml> ";
        }
        String s = HttpRequest.httpsPost((String)url, (String)xml);
        SortedMap resultMap = XmlUtils.doXMLParseSort((String)s);
        result.setValue((Object)resultMap);
        if (!((String)resultMap.get("return_code")).equalsIgnoreCase("SUCCESS")) {
            result.setError("\u83b7\u53d6\u652f\u4ed8\u6570\u636e\u9519\u8bef");
            return result;
        }
        if (((String)resultMap.get("result_code")).equalsIgnoreCase("SUCCESS") && ((String)resultMap.get("trade_state")).equalsIgnoreCase("SUCCESS")) {
            String sign1;
            String sign2 = (String)resultMap.get("sign");
            if (sign2.equals(sign1 = WechatPayCommon.createSign((SortedMap)resultMap, (String)inputEntity.getPayKey()))) {
                result.setValue((Object)resultMap);
                return result;
            }
            result.setError("\u7b7e\u540d\u9519\u8bef");
            return result;
        }
        result.setError("\u83b7\u53d6\u652f\u4ed8\u6570\u636e\u9519\u8bef");
        return result;
    }

    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        String url = "https://api.mch.weixin.qq.com/pay/closeorder";
        String appId = inputEntity.getAppId();
        String mchId = inputEntity.getMchId();
        String nonceStr = WechatPayCommon.createNonceStr();
        String tradeId = inputEntity.getTradeNo();
        String signTemp = "appid=" + appId + "&mch_id=" + mchId + "&nonce_str=" + nonceStr + "&out_trade_no=" + tradeId + "&key=" + inputEntity.getPayKey();
        String sign = MD5.sign((String)signTemp).toUpperCase();
        String xml = "<xml><appid>" + appId + "</appid><mch_id>" + mchId + "</mch_id><nonce_str>" + nonceStr + "</nonce_str><out_trade_no>" + tradeId + "</out_trade_no><sign>" + sign + "</sign></xml>";
        String s = HttpRequest.httpsPost((String)url, (String)xml);
        SortedMap resultMap = XmlUtils.doXMLParseSort((String)s);
        if (((String)resultMap.get("return_code")).equalsIgnoreCase("SUCCESS") && resultMap.containsKey("result_code") && ((String)resultMap.get("result_code")).equals("SUCCESS")) {
            return result;
        }
        this.logger.info("=========\u5173\u95ed\u5fae\u4fe1\u8ba2\u5355\u5931\u8d25=========");
        result.setError("\u6682\u65f6\u65e0\u6cd5\u53d6\u6d88");
        if (resultMap.containsKey("err_code") && ((String)resultMap.get("err_code")).equalsIgnoreCase("ORDERPAID")) {
            result.setError("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        return result;
    }

    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        String url = "https://api.mch.weixin.qq.com/secapi/pay/refund";
        String appId = inputEntity.getAppId();
        String mchId = inputEntity.getMchId();
        String nonceStr = WechatPayCommon.createNonceStr();
        String signTemp = "appid=" + appId + "&mch_id=" + mchId + "&nonce_str=" + nonceStr + "&op_user_id=" + mchId + "&out_refund_no=" + inputEntity.getRefundBillNo() + "&out_trade_no=" + inputEntity.getTradeNo() + "&refund_fee=" + PriceUtils.multiply((BigDecimal)inputEntity.getRefundAmount(), (Integer)100).intValue() + "&total_fee=" + PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).intValue() + "&key=" + inputEntity.getPayKey();
        String sign = MD5.sign((String)signTemp).toUpperCase();
        String xml = "<xml><appid>" + appId + "</appid><mch_id>" + mchId + "</mch_id><nonce_str>" + nonceStr + "</nonce_str><op_user_id>" + mchId + "</op_user_id><out_refund_no>" + inputEntity.getRefundBillNo() + "</out_refund_no><out_trade_no>" + inputEntity.getTradeNo() + "</out_trade_no><refund_fee>" + PriceUtils.multiply((BigDecimal)inputEntity.getRefundAmount(), (Integer)100).intValue() + "</refund_fee><total_fee>" + PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).intValue() + "</total_fee><sign>" + sign + "</sign></xml>";
        inputEntity.setEntity((Object)xml);
        this.logger.info("refundfile_is_here:" + inputEntity.getRefundCertFile());
        String s = HttpRequest.wechatRefundHttps((String)url, (String)xml, (String)inputEntity.getRefundCertFile(), (String)inputEntity.getMchId());
        this.logger.info("++++++++++++++++++++wechatPayImpl.payRefund++++++++++++++++++inputEntity={},xml={},wechatResult={}", new Object[]{JSON.toJSONString((Object)inputEntity), xml, s});
        if (s.isEmpty() || s == null) {
            result.setError("\u8bf7\u6c42\u5931\u8d25");
            return result;
        }
        if (s.contains("FAIL")) {
            result.setError(s);
            result.setValue((Object)XmlUtils.doXMLParseSort((String)s));
            return result;
        }
        SortedMap resultMap = XmlUtils.doXMLParseSort((String)s);
        if (((String)resultMap.get("return_code")).equalsIgnoreCase("SUCCESS")) {
            if (((String)resultMap.get("result_code")).equalsIgnoreCase("SUCCESS")) {
                String sign1 = (String)resultMap.get("sign");
                if (sign1.equals(WechatPayCommon.createSign((SortedMap)resultMap, (String)inputEntity.getPayKey()))) {
                    result.setValue(ObjectConvert.mapConvertToObject((SortedMap)resultMap, WechatRefundReturnEntity.class));
                    return result;
                }
                result.setError("\u7b7e\u540d\u9519\u8bef");
                result.setValue((Object)resultMap);
                return result;
            }
            result.setError("\u63d0\u4ea4\u4e1a\u52a1\u5931\u8d25");
            result.setValue((Object)resultMap);
            return result;
        }
        result.setError("\u7b7e\u540d\u5931\u8d25");
        result.setValue((Object)resultMap);
        return result;
    }

    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        WechatRefundNotifyEntity refundNotifyEntitytemp = (WechatRefundNotifyEntity)notifyInputEntity;
        if ("SUCCESS".equalsIgnoreCase(refundNotifyEntitytemp.getReturnCode())) {
            String reqInfo = EncodeUtils.base64Decode1((String)refundNotifyEntitytemp.getReqInfo());
            String key = MD5.sign((String)refundNotifyEntitytemp.getPayKey());
            reqInfo = AES.decryptor((String)key, (String)reqInfo);
            Map map = XmlUtils.doXMLParse((String)reqInfo);
            WechatRefundNotifyEntity refundNotifyEntity = (WechatRefundNotifyEntity)ObjectConvert.mapConvertToObject((Map)map, WechatRefundNotifyEntity.class);
            refundNotifyEntity.setReturnCode(refundNotifyEntitytemp.getReturnCode());
            refundNotifyEntity.setReturnMsg(refundNotifyEntitytemp.getReturnMsg());
            refundNotifyEntity.setAppId(refundNotifyEntitytemp.getAppId());
            refundNotifyEntity.setMchId(refundNotifyEntitytemp.getMchId());
            refundNotifyEntity.setNonceStr(refundNotifyEntitytemp.getNonceStr());
            refundNotifyEntity.setReqInfo(refundNotifyEntitytemp.getReqInfo());
            result.setValue((Object)refundNotifyEntity);
        } else {
            result.setError("\u9000\u6b3e\u901a\u77e5\u9519\u8bef");
        }
        return result;
    }
}

