/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.csmsapi.service.refund;

import cc.lechun.csmsapi.dao.refund.RefundPayDetailMapper;
import cc.lechun.csmsapi.dto.refund.RefundParamDto;
import cc.lechun.csmsapi.dto.refund.RefundProductParamDto;
import cc.lechun.csmsapi.entity.refund.RefundPayDetailEntity;
import cc.lechun.csmsapi.iservice.refund.RefundPayDetailInterface;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RefundPayDetailService
extends BaseService<RefundPayDetailEntity, String>
implements RefundPayDetailInterface {
    @Resource
    private RefundPayDetailMapper refundPayDetailMapper;

    public BaseJsonVo createRefundPayDetailInfo(RefundParamDto refundParamDto) {
        List refundProductParamDtoList = refundParamDto.getRefundProductList();
        BigDecimal cashAmount = BigDecimal.ZERO;
        BigDecimal balanceAmount = BigDecimal.ZERO;
        if (refundProductParamDtoList != null && refundProductParamDtoList.size() > 0) {
            for (RefundProductParamDto refundProductParamDto : refundProductParamDtoList) {
                cashAmount = cashAmount.add(refundProductParamDto.getRefundCashAmountApply());
                balanceAmount = balanceAmount.add(refundProductParamDto.getRefundBalanceAmountApply());
            }
        }
        ArrayList<RefundPayDetailEntity> refundPayDetailEntityList = new ArrayList<RefundPayDetailEntity>();
        if (cashAmount.doubleValue() > 0.0) {
            RefundPayDetailEntity refundPayDetailEntityCash = new RefundPayDetailEntity();
            refundPayDetailEntityCash.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
            refundPayDetailEntityCash.setRefundNo("");
            refundPayDetailEntityCash.setRefundProductNo("");
            refundPayDetailEntityCash.setOrderNo(refundParamDto.getOrderNo());
            refundPayDetailEntityCash.setPaytypeId(Integer.valueOf(1));
            refundPayDetailEntityCash.setPaytypeName("");
            refundPayDetailEntityCash.setRefundPayAmountApply(cashAmount);
            refundPayDetailEntityCash.setRefundPayAmountCheck(cashAmount);
            refundPayDetailEntityList.add(refundPayDetailEntityCash);
        }
        if (balanceAmount.doubleValue() > 0.0) {
            RefundPayDetailEntity refundPayDetailEntityBalance = new RefundPayDetailEntity();
            refundPayDetailEntityBalance.setRefundPayDetailNo(IDGenerate.getUniqueIdStr());
            refundPayDetailEntityBalance.setRefundNo("");
            refundPayDetailEntityBalance.setRefundProductNo("");
            refundPayDetailEntityBalance.setOrderNo(refundParamDto.getOrderNo());
            refundPayDetailEntityBalance.setPaytypeId(Integer.valueOf(1));
            refundPayDetailEntityBalance.setPaytypeName("");
            refundPayDetailEntityBalance.setRefundPayAmountApply(balanceAmount);
            refundPayDetailEntityBalance.setRefundPayAmountCheck(balanceAmount);
            refundPayDetailEntityList.add(refundPayDetailEntityBalance);
        }
        if (this.refundPayDetailMapper.batchInsert(refundPayDetailEntityList) <= 0) {
            return BaseJsonVo.error((String)"\u4fdd\u5b58\u4fe1\u606f\u6210\u529f");
        }
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u4fe1\u606f\u6210\u529f");
    }

    public List<RefundPayDetailEntity> selectRefundPayDetailList(RefundPayDetailEntity refundPayDetailEntity) {
        return this.refundPayDetailMapper.selectRefundPayDetailList(refundPayDetailEntity);
    }

    public List<RefundPayDetailEntity> queryRefundPayDetailListByRefundIdStatus(int isSuccess, String refundNo) {
        return this.refundPayDetailMapper.queryRefundPayDetailListByRefundIdStatus(isSuccess, refundNo);
    }

    public void SuccessOrderRefund(String refundId, int payTypeId) {
        RefundPayDetailEntity refundPayDetailEntity = new RefundPayDetailEntity();
        refundPayDetailEntity.setRefundNo(refundId);
        refundPayDetailEntity.setPaytypeId(Integer.valueOf(payTypeId));
        List refundPayDetailEntityList = this.refundPayDetailMapper.getList((Object)refundPayDetailEntity);
        refundPayDetailEntityList.forEach(refundPayDetailEntity1 -> {
            refundPayDetailEntity1.setIsSuccess(Integer.valueOf(1));
            refundPayDetailEntity1.setUpdateTime(new Date());
            this.refundPayDetailMapper.updateByPrimaryKey(refundPayDetailEntity1);
        });
    }
}

